import logging

from flask import Flask, render_template, request, make_response
from flaskext.mysql import MySQL
from flask_httpauth import HTTPBasicAuth
from passlib.hash import argon2

log = logging.getLogger(__name__)
app = Flask(__name__, template_folder='./templates')
mysql = MySQL(app)
auth = HTTPBasicAuth()

# MySQL configurations
app.config['MYSQL_DATABASE_USER'] = 'project1-web'
app.config['MYSQL_DATABASE_PASSWORD'] = 'webpassword'
app.config['MYSQL_DATABASE_DB'] = 'project1'
app.config['MYSQL_DATABASE_HOST'] = 'localhost'

def get_data(sql, params=None):
    conn = mysql.connect()
    cursor = conn.cursor()
    # print("Getting data...")
    try:
        # print("Using sql command: " + sql)
        cursor.execute(sql, params)
    except Exception as e:
        # print("Exception: " + e)
        return False

    result = cursor.fetchall()
    data = []
    for row in result:
        data.append(list(row))
    cursor.close()
    conn.close()

    return data

def get_temperature():
    temp_record = get_data("SELECT temperature FROM tbldata ORDER BY dateCreation DESC LIMIT 1;")
    temp = str(temp_record[0][0])
    # print("Temperature: " + temp)
    return temp

def get_lastUsed():
    lastUsed_record = get_data("SELECT dateCreation FROM tbldata WHERE used = 'Y' ORDER BY dateCreation DESC LIMIT 5;")
    # print(str(lastUsed_record))
    new_list = []
    for used in lastUsed_record:
        # print(used[0])
        # % H: % M: % S % m % B % Y
        # Monday 18 June 2018 23:14:10
        u = used[0].strftime('%A %d %B %Y %H:%M:%S')
        # print(u)
        new_list.append(u)
    return new_list

def isUserLoggedIn():
    try:
        isloggedin = int(request.cookies.get("loggedin"))
    except:
        isloggedin = 0
    if isloggedin == 1:
        return True
    return False

def userexists(u, email):
    data = get_data ("SELECT * from tbluser where username = BINARY %s or email = BINARY %s;", (u, email))
    # print(str(data))
    if len(data) > 0:
        return True
    else:
        return False

@app.route('/')
def index():
    if isUserLoggedIn():
        temp = get_temperature()
        lastUsed = get_lastUsed()

        # print("test" + str(get_lastUsed()))
        return render_template("home.html", temp=temp, new_list=lastUsed)
    return render_template("login.html")

@app.route('/smartmirror')
def smartmirror():
    t = get_temperature()
    return render_template("smartmirror.html",  temp=t)

@app.route('/register', methods=['GET', 'POST'])
def register():
    if request.method == "POST":
        username = request.form.get("username")
        password = request.form.get("password")
        email = request.form.get("email")

        if not userexists(username, email):
            try:
                connection = mysql.connect()
                cursor = connection.cursor()
                # generates encrypted hash
                pw_hash = argon2.hash(password)
                cursor.execute("INSERT INTO `tbluser`(`email`, `username`, `password`) VALUES (%s,%s,%s);", (email, username, pw_hash))
                connection.commit()
            except Exception as e:
                return str(e)
            finally:
                cursor.close()
            return render_template("login.html")
        return render_template("register.html", UserExists=True)
    return render_template("register.html")

@app.route('/login', methods=['GET', 'POST'])
def login():
    if request.method == "POST":
        password = request.form.get("password")
        user = request.form.get("username")

        record = (get_data("SELECT password FROM tbluser WHERE username = %s;", (user, )))
        # print("Existing encrypted password with corresponding username: " + str(record))

        # checks if user exists
        if record:
            # checks encrypted password
            pw_ok = argon2.verify(password, record[0][0])
            if pw_ok:
                temp = get_temperature()
                lastUsed = get_lastUsed()
                cookieHandler = make_response(render_template("home.html", temp=temp, new_list=lastUsed))
                cookieHandler.set_cookie("loggedin", "1")
                # cookieHandler.set_cookie("user", user)
                return cookieHandler
            return render_template("login.html", Warning=True)
        return render_template("login.html", Warning=True)
    return render_template("login.html", Warning=True)

@app.route('/logout/')
def logout():
    cookieHandler = make_response(render_template("login.html"))
    cookieHandler.set_cookie("loggedin", "0")
    return cookieHandler

# error pages
@app.errorhandler(404)
def page_not_found(e):
    return render_template("errors/404.html"), 404

@app.errorhandler(500)
def internal_error_server(e):
    return render_template("errors/500.html"), 500

if __name__ == '__main__':
    logging.basicConfig(level=logging.DEBUG)
    log.info("Flask app starting")
    app.run(host='0.0.0.0', debug=True)
