#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
  #include <avr/power.h>
#endif

#define PIN 9
#define PINR 6

// Parameter 1 = number of pixels in strip
// Parameter 2 = Arduino pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_KHZ800  800 KHz bitstream (most NeoPixel products w/WS2812 LEDs)
//   NEO_KHZ400  400 KHz (classic 'v1' (not v2) FLORA pixels, WS2811 drivers)
//   NEO_GRB     Pixels are wired for GRB bitstream (most NeoPixel products)
//   NEO_RGB     Pixels are wired for RGB bitstream (v1 FLORA pixels, not v2)
Adafruit_NeoPixel strip = Adafruit_NeoPixel(30, PIN, NEO_GRB + NEO_KHZ800);
Adafruit_NeoPixel stripr = Adafruit_NeoPixel(16, PINR, NEO_GRB + NEO_KHZ800);

// IMPORTANT: To reduce NeoPixel burnout risk, add 1000 uF capacitor across
// pixel power leads, add 300 - 500 Ohm resistor on first pixel's data input
// and minimize distance between Arduino and first pixel.  Avoid connecting
// on a live circuit...if you must, connect GND first.

void setup() {
  // This is for Trinket 5V 16MHz, you can remove these three lines if you are not using a Trinket
 // #if defined (__AVR_ATtiny85__)
//    if (F_CPU == 16000000) clock_prescale_set(clock_div_1);
//  #endif
  // End of trinket special code

  strip.begin();
  strip.show(); // Initialize all pixels to 'off'

  stripr.begin();
  stripr.show(); // Initialize all pixels to 'off'
}

void loop() {
  colorWiper(stripr.Color(255, 0, 0), 20); // Red
   colorWiper(stripr.Color(255, 255,255), 20); // white
   colorWiper(stripr.Color(255, 0, 0), 20); // Red
  colorWiper(stripr.Color(0, 255, 0), 20); // Green
   colorWiper(stripr.Color(0, 0, 255), 20); // Blue
  // Some example procedures showing how to display to the pixels:
  colorWipe(strip.Color(255, 0, 0), 80); // Red
 // colorWipe(strip.Color(0, 0, 0), 10); // OFF
  colorWipe(strip.Color(255, 75, 0), 40); // RedOrg
 // colorWipe(strip.Color(0, 255, 0), 50); // Green
 // colorWipe(strip.Color(0, 0, 255), 100); // Blue
  
 // colorWiper(stripr.Color(255, 0, 0), 20); // Red
 
 // colorWiper(stripr.Color(0, 255, 0), 50); // Green
 // colorWiper(stripr.Color(0, 0, 255), 50); // Blue
  
  // Send a theater pixel chase in...
  theaterChase(strip.Color(255, 165, 0), 45); // Orange
 theaterChase(strip.Color(255, 50, 0), 30); // Red
  theaterChase(strip.Color(255, 255, 0), 45); // Yellow
  theaterChase(strip.Color(0, 0, 255), 45); // blue
 colorWipe(strip.Color(255,100,0), 20); // Orange
  colorWipe(strip.Color(0,0,255), 40); // blue
 // theaterChaseRainbow(50);
 colorWipe(strip.Color(0, 0, 0), 40); // Lights off

   theaterChaser(stripr.Color(0, 0, 255), 20); // blue
   theaterChaser(stripr.Color(127, 0, 255), 20); // purple
   theaterChaser(stripr.Color(0, 0, 0),40); // blue

 // theaterChase(strip.Color(0, 0, 127), 50); // Blue  

 
 
 colorWiper(stripr.Color(255, 0, 0), 20); // Red


//  rainbowr(20);
  // rainbowr(20);

  colorWiper(stripr.Color(0, 0, 0), 20); // Lights off
  delay(1000);

//  rainbow(20);
 // rainbowCycle(20);
 // theaterChaseRainbow(50);
}

// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
  for(uint16_t i=0; i<strip.numPixels(); i++) {
    strip.setPixelColor(30-i, c);
    strip.show();
    delay(wait);
  }
}

// Fill the dots one after the other with a color
void colorWiper(uint32_t c, uint8_t wait) {
  for(uint16_t i=0; i<stripr.numPixels(); i++) {
    stripr.setPixelColor(i, c);
    stripr.show();
    delay(wait);
  }
}


void rainbow(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256; j++) {
    for(i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel((i+j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

void rainbowr(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256; j++) {
    for(i=0; i<stripr.numPixels(); i++) {
      stripr.setPixelColor(i, Wheelr((i+j) & 255));
    }
    stripr.show();
    delay(wait);
  }
}
// Slightly different, this makes the rainbow equally distributed throughout
void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
    for(i=0; i< strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

//Theatre-style crawling lights.
void theaterChase(uint32_t c, uint8_t wait) {
  for (int j=0; j<10; j++) {  //do 10 cycles of chasing
    for (int q=0; q < 3; q++) {
      for (int i=0; i < strip.numPixels(); i=i+3) {
        strip.setPixelColor(30-i+q, c);    //turn every third pixel on
      }
      strip.show();

      delay(wait);

      for (int i=0; i < strip.numPixels(); i=i+3) {
        strip.setPixelColor(30-i+q, 0);        //turn every third pixel off
      }
    }
  }
}
//Theatre-style crawling lights.
void theaterChaser(uint32_t c, uint8_t wait) {
  for (int j=0; j<10; j++) {  //do 10 cycles of chasing
    for (int q=0; q < 3; q++) {
      for (int i=0; i < stripr.numPixels(); i=i+3) {
        stripr.setPixelColor(i+q, c);    //turn every third pixel on
      }
      stripr.show();

      delay(wait);

      for (int i=0; i < stripr.numPixels(); i=i+3) {
        stripr.setPixelColor(i+q, 0);        //turn every third pixel off
      }
    }
  }
}

//Theatre-style crawling lights with rainbow effect
void theaterChaseRainbow(uint8_t wait) {
  for (int j=0; j < 256; j++) {     // cycle all 256 colors in the wheel
    for (int q=0; q < 3; q++) {
      for (int i=0; i < strip.numPixels(); i=i+3) {
        strip.setPixelColor(i+q, Wheel( (i+j) % 255));    //turn every third pixel on
      }
      strip.show();

      delay(wait);

      for (int i=0; i < strip.numPixels(); i=i+3) {
        strip.setPixelColor(i+q, 0);        //turn every third pixel off
      }
    }
  }
}

// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t Wheel(byte WheelPos) {
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85) {
   // return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3);
        return strip.Color(255 - WheelPos * 3, 0, 0);
  }
  if(WheelPos < 170) {
    WheelPos -= 85;
    return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
  WheelPos -= 170;
 // return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
}
// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t Wheelr(byte WheelPos) {
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85) {
    return stripr.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  }
  if(WheelPos < 170) {
    WheelPos -= 85;
    return stripr.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
  WheelPos -= 170;
  return stripr.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
}
