// Copyright (c) Arduino. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
// Refer to https://sites.google.com/view/make-iot/viziot for documentation

#include <WiFi101.h>
#include <Temboo.h>
#include "TembooAccount.h"
#include "iothub_client_sample_http.h"

#include "data_types.h"

/*****************************************/
/*        LED                           */
/*****************************************/
const int RED_PIN = 5;  // --> BLUE --> 4
const int GREEN_PIN = 3; // --> RED --> 5
const int BLUE_PIN = 4; // --> GREEN --> 3
const int  MAX_ITERATIONS = 10;

WiFiClient client;

char ssid[] = "YourNetworkSSID"; //  your network SSID (name)
char pass[] = "YourNetworkPWD";    // your network password (use for WPA, or use as key for WEP)

// Fixed configuration when Azure IoT is not used
// Foixed configutation to be used when Azure IoT is not configured
int app_mode_fixed = mkr_weather;
char modeArgsStatic[] = "STOCKS AAPL\0";


int status = WL_IDLE_STATUS;
int statusAzure = 0;
int app_mode = mkr_handle;
static int i_delay = 100; // wait message from IoT Hub for 1 min 
char modeArg[16];  // control messages from Azure IoT 

void setup() {
  Serial.begin(9600);

  // check for the presence of the shield :
  if (WiFi.status() == WL_NO_SHIELD) {
    Serial.println("WiFi shield not present");
    // don't continue:
    while (true);
  }

  // attempt to connect to Wifi network:
  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    status = WiFi.begin(ssid, pass);
    if (status != WL_CONNECTED) {
      // wait 10 seconds for connection:
      delay(10000);
    }
  }
  Serial.println("Connected to wifi \r\n");
    
  // Contact Azure IoT Hub
  statusAzure = iothub_client_sample_http_init();
  if ( statusAzure == 0 )  {
      Serial.println("Failed to initialize IoTHu. Use configuration set in code \r\n");
      analogWrite(RED_PIN, 255);
      analogWrite(BLUE_PIN, 0);
      analogWrite(GREEN_PIN, 0);     
      // while (1);  
      app_mode = app_mode_fixed;
      memcpy (modeArg,modeArgsStatic,16);
    }
    else {
       Serial.println("Initialized iot hub\r\n");
       Serial.println("\r\n");
    }   
   delay(10000);
  
   analogWrite(RED_PIN, 255);
   analogWrite(BLUE_PIN, 255);
   analogWrite(GREEN_PIN, 255);                     

}



void loop() {
  // yahoo stock
  float f_stock_value;
  // yahoo weather  
  float f_temp_value;


  if (statusAzure == 0){
     Serial.println("Skip IoT Hub interface \n\r");
     delay (30000);
    }
  else if( iothub_client_sample_http_run(i_delay, modeArg, &app_mode) < 0){
     Serial.println("Error in iothub_client_sample_http_run. Application exit \n\r");
     exit (0);
  }   
  Serial.println("Working mode is \n\r");
  Serial.print(app_mode);
  Serial.println("\r\n");

  int pinColor = 0;

  switch (app_mode)
  { 
    case mkr_stocks:
              Serial.print("Check stocks mode.   \n\r" );
              Serial.print(modeArg);
              delay(1000);
              f_stock_value = ReadYahooStock(modeArg); 
              // map stock value to pin number (5 --> 255)
              pinColor = ((255*abs(f_stock_value))/5);          
              if (f_stock_value < 0){
                    if (f_stock_value < -100){    
                        Serial.print("Error \n\r");
                        break;
                    }     
                    else {
                        analogWrite(RED_PIN, pinColor);
                        analogWrite(BLUE_PIN, 0);
                        analogWrite(GREEN_PIN, 0);
                      }      
              }
              else {
                  analogWrite(RED_PIN, 0);
                  analogWrite(GREEN_PIN, pinColor);
                  analogWrite(BLUE_PIN, 0);
              }    
      break;

  case mkr_weather:
          Serial.print("Check weather mode.  \n\r" );
          Serial.print(modeArg);
          delay(1000);
          Serial.print("\n\r");
          f_temp_value = ReadYahooweatherForecast(modeArg); 
      
          if (f_temp_value < 0){
              if (f_temp_value < -100){    
                  Serial.print("Error \n\r");
                  break;
              }
              else{    
                  analogWrite(RED_PIN, 0);
                  analogWrite(BLUE_PIN, 255);
                  analogWrite(GREEN_PIN, 0);
              }
          }
          else{
              if (f_temp_value < 5)
              {    
                  Serial.print("0 0 120\n\r");
                  analogWrite(RED_PIN, 0);
                  analogWrite(BLUE_PIN, 120);
                  analogWrite(GREEN_PIN, 0);
              }
              else  if (f_temp_value < 20)
              {    
                  Serial.print("0 180 0\n\r");
                  analogWrite(RED_PIN, 0);
                  analogWrite(BLUE_PIN, 0);
                  analogWrite(GREEN_PIN, 180);
              }
              else  if (f_temp_value < 30)
              {    
                  Serial.print("180 0 0\n\r");
                  analogWrite(RED_PIN, 120);
                  analogWrite(BLUE_PIN, 0);
                  analogWrite(GREEN_PIN, 0);
              }
              else        
              {    
                  Serial.print("255 0 0\n\r");
                  analogWrite(RED_PIN, 255);
                  analogWrite(BLUE_PIN, 0);
                  analogWrite(GREEN_PIN, 0);
              }    
          }
       break;
       

 case mkr_test:
    // Test colors  
    Serial.print("Test white \n\r");
    analogWrite(RED_PIN, 255);
    analogWrite(BLUE_PIN, 255);
    analogWrite(GREEN_PIN, 255); 
    delay (1000);	
    Serial.print("Test red \n\r");
    analogWrite(RED_PIN, 255);
    analogWrite(BLUE_PIN, 0);
    analogWrite(GREEN_PIN, 0);    
    delay (1000);
    Serial.print("Test blue \n\r");
    analogWrite(RED_PIN, 0);
    analogWrite(BLUE_PIN, 255);
    analogWrite(GREEN_PIN, 0);        
    Serial.print("Test green \n\r");
    analogWrite(RED_PIN, 0);
    analogWrite(BLUE_PIN, 0);
    analogWrite(GREEN_PIN, 255);        
    break;

 case mkr_handle:      
    Serial.print("Handle mode. do nothing \n\r");
    Serial.print(modeArg);
    delay(1000);
    break;

 case mkr_quit:      
    Serial.print("Application stop \n\r");
    exit(0);
    break;

  } // switch

  
}




/* Look for substring */ 
int Contains(String s, String search, int size) {
    int max = s.length() - search.length();

    for (int i = 0; i <= max; i++) {
        if ( (s.substring(i,i+size)) == search) 
           return i; 
    }

    return -1;
} 


/* Retrieve percentage change given stock name */ 
float ReadYahooStock(String StockSymbolValue) {
    String tembooStr = "";
    String retString = "";    
    int index;
    int i,j;
    i = 0;
    index = 0;

    TembooChoreo GetStockQuoteChoreo(client);

    // Invoke the Temboo client
    GetStockQuoteChoreo.begin();

    // Set Temboo account credentials
    GetStockQuoteChoreo.setAccountName(TEMBOO_ACCOUNT);
    GetStockQuoteChoreo.setAppKeyName(TEMBOO_APP_KEY_NAME);
    GetStockQuoteChoreo.setAppKey(TEMBOO_APP_KEY);

    // Set Choreo inputs
    GetStockQuoteChoreo.addInput("StockSymbol", StockSymbolValue);

    // Identify the Choreo to run
    GetStockQuoteChoreo.setChoreo("/Library/Yahoo/Finance/GetStockQuote");

    // Run the Choreo; when results are available, print them to serial
    GetStockQuoteChoreo.run();

    while(GetStockQuoteChoreo.available()) {
      char c = GetStockQuoteChoreo.read();
      tembooStr += c;
      i++;
      if (i>=2495)
      {
          Serial.print("Error in ReadYahooStock. Temboo string too long \n");
          return -101.0;
      }       
    }
    GetStockQuoteChoreo.close();
    // look for percentage change                              
    index = Contains(tembooStr, "\"PercentChange\"", 15);
    if (index > 0)
    {
       j = 0;
       while(tembooStr[index+17+j]!='%')
       {
            retString +=tembooStr[index+17+j];
            j++;
       }            
    }
    else
    {
         Serial.print("Error in ReadYahooStock \n"); 
         return -101.0;
    }
    
    Serial.print("\n\r PercentageChange : \n\r");
    Serial.println(retString.toFloat());
    Serial.println("\n\r");    
    
    return retString.toFloat();
  }


/* Retrieve temeprature given city name */ 
float ReadYahooweatherForecast(String AddressValue) {
    String tembooStr = "";
    String retString = ""; 
    int j;   
    int index;
      
    TembooChoreo GetTemperatureChoreo(client);

    // Invoke the Temboo client
    GetTemperatureChoreo.begin();

    // Set Temboo account credentials
    GetTemperatureChoreo.setAccountName(TEMBOO_ACCOUNT);
    GetTemperatureChoreo.setAppKeyName(TEMBOO_APP_KEY_NAME);
    GetTemperatureChoreo.setAppKey(TEMBOO_APP_KEY);

    // Set Choreo inputs
    GetTemperatureChoreo.addInput("Address", AddressValue);
    String UnitsValue = "Celsius";
    GetTemperatureChoreo.addInput("Units", UnitsValue);

    // Identify the Choreo to run
    GetTemperatureChoreo.setChoreo("/Library/Yahoo/Weather/GetTemperature");

    // Run the Choreo; when results are available, print them to serial
    GetTemperatureChoreo.run();

    while(GetTemperatureChoreo.available()) {
       char c = GetTemperatureChoreo.read();
       Serial.print(c);
       tembooStr += c;
    }
    GetTemperatureChoreo.close();
 
    index = Contains(tembooStr, "Temperature", 11);
    
    if (index > 0)
    {
       j = 0;
       while(tembooStr[index+13+j]!='\n')
       {
            retString +=tembooStr[index+13+j];
            j++;
       }
            
    }

    Serial.print("\n\tRetrieve temperature:");
    Serial.println(retString.toFloat());
    Serial.println("\n\r");    
    
    return retString.toFloat();   
}










