// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include <stdio.h>
#include <stdlib.h>

/* This sample uses the _LL APIs of iothub_client for example purposes.
   That does not mean that HTTP only works with the _LL APIs.
   Simply changing the using the convenience layer (functions not having _LL)
   and removing calls to _DoWork will yield the same results. */

#ifdef ARDUINO
#include "AzureIoT.h"
#else
#include "iothub_client_ll.h"
#include "iothub_message.h"
#include "crt_abstractions.h"
#include "iothubtransporthttp.h"
#endif

#ifdef MBED_BUILD_TIMESTAMP
#include "certs.h"
#endif // MBED_BUILD_TIMESTAMP

#include "data_types.h"


static const char* connectionString = NULL; // Type here the connection string once registered your device to Azure IoT Hub


static int callbackCounter;
bool b_exit_run = false;
int working_mode = mkr_handle;
static char msgCmd[16];
static char msgText[254];
static char propText[256];
#define MESSAGE_COUNT 1
IOTHUB_CLIENT_LL_HANDLE iotHubClientHandle;
typedef struct EVENT_INSTANCE_TAG
{
    IOTHUB_MESSAGE_HANDLE messageHandle;
    int messageTrackingId;  // For tracking the messages within the user callback.
} EVENT_INSTANCE;

EVENT_INSTANCE messages[MESSAGE_COUNT];
DEFINE_ENUM_STRINGS(IOTHUB_CLIENT_CONFIRMATION_RESULT, IOTHUB_CLIENT_CONFIRMATION_RESULT_VALUES);



static IOTHUBMESSAGE_DISPOSITION_RESULT ReceiveMessageCallback(IOTHUB_MESSAGE_HANDLE message, void* userContextCallback)
{
  //  int* counter = (int*)userContextCallback;
    const char* buffer;
    size_t size;
    int j =0;
    int offset = 0;

    
    if (IoTHubMessage_GetByteArray(message, (const unsigned char**)&buffer, &size) != IOTHUB_MESSAGE_OK)
    {
        printf("unable to retrieve the message data\r\n");
    }
    else
    {
        (void)printf("Received Message  with Data: <<<%.*s>>> & Size=%d\r\n",  (int)size, buffer, (int)size);
        memset(msgCmd, '\0', 16);

        if ((memcmp(buffer, "TEST", 4)) == 0)
        {
              (void)printf("Set mode to TEST_LIGHTS \r\n");
              working_mode = mkr_test;
              b_exit_run = true;
        }
        else if ((memcmp(buffer, "QUIT", 4)) == 0)
        {
              (void)printf("Set mode to QUIT. \r\n");
              working_mode = mkr_quit;
              b_exit_run = true;
        }
        else if ((memcmp(buffer, "HANDLE", 6)) == 0)
        {
              (void)printf("Set mode to HANDLE. \r\n");
              working_mode = mkr_handle;
              b_exit_run = true;
        }

        else if ((memcmp(buffer, "TEMP", 4)) == 0)
        {
              working_mode = mkr_weather;
              b_exit_run = true;
              offset = 4;
              j = 1;
              while ( (size-offset-j) > 0  ){  
                    msgCmd[(j-1)] = buffer[offset+j];
                    j++;
                }   
              msgCmd[j] = '\0';
             (void)printf("Set mode to WEATHER. City name \r\n");        
        }     
        else if ((memcmp(buffer, "STOCKS", 6)) == 0)
        {
              working_mode = mkr_stocks;
              b_exit_run = true;
              offset = 6;
              j = 1;
              while ( (size-offset-j) > 0  ){  
                    msgCmd[(j-1)] = buffer[offset+j];
                    j++;
             }   
             msgCmd[j] = '\0';
            (void)printf("Set mode to STOCKS. date \r\n"); 
        } 
        
    }

    return IOTHUBMESSAGE_ACCEPTED;
}

static void SendConfirmationCallback(IOTHUB_CLIENT_CONFIRMATION_RESULT result, void* userContextCallback)
{
    EVENT_INSTANCE* eventInstance = (EVENT_INSTANCE*)userContextCallback;
    (void)printf("Confirmation[%d] received for message tracking id = %d with result = %s\r\n", callbackCounter, eventInstance->messageTrackingId, ENUM_TO_STRING(IOTHUB_CLIENT_CONFIRMATION_RESULT, result));
    /* Some device specific action code goes here... */
    callbackCounter++;
    IoTHubMessage_Destroy(eventInstance->messageHandle);
}


int iothub_client_sample_http_init(void)
{
    srand((unsigned int)time(NULL));
    double avgWindSpeed = 10.0;

    callbackCounter = 0;
    int receiveContext = 0;

    (void)printf("Starting the IoTHub client sample HTTP...\r\n");

    if ((iotHubClientHandle = IoTHubClient_LL_CreateFromConnectionString(connectionString, HTTP_Protocol)) == NULL)
    {
        (void)printf("ERROR: iotHubClientHandle is NULL!\r\n");
        return 0;
    }
    else
    {
        unsigned int timeout = 241000;
        if (IoTHubClient_LL_SetOption(iotHubClientHandle, "timeout", &timeout) != IOTHUB_CLIENT_OK)
        {
            printf("failure to set option \"timeout\"\r\n");
        }

        unsigned int minimumPollingTime = 9; /*because it can poll "after 9 seconds" polls will happen effectively at ~10 seconds*/
        if (IoTHubClient_LL_SetOption(iotHubClientHandle, "MinimumPollingTime", &minimumPollingTime) != IOTHUB_CLIENT_OK)
        {
            printf("failure to set option \"MinimumPollingTime\"\r\n");
        }

#ifdef MBED_BUILD_TIMESTAMP
        // For mbed add the certificate information
        if (IoTHubClient_LL_SetOption(iotHubClientHandle, "TrustedCerts", certificates) != IOTHUB_CLIENT_OK)
        {
            printf("failure to set option \"TrustedCerts\"\r\n");
        }
#endif // MBED_BUILD_TIMESTAMP

        /* Setting Message call back, so we can receive Commands. */
        if (IoTHubClient_LL_SetMessageCallback(iotHubClientHandle, ReceiveMessageCallback, &receiveContext) != IOTHUB_CLIENT_OK)
        {
            (void)printf("ERROR: IoTHubClient_LL_SetMessageCallback..........FAILED!\r\n");
            return 0;
        }
        else
        {
            (void)printf("IoTHubClient_LL_SetMessageCallback...successful.\r\n");

        }       
    }
    return 1;
}


int iothub_client_sample_http_run(int timeToWaitForCommands, char *argument, int *currentWM)
{
        int index = 0;
      
        // Send msg : working mode 
        sprintf_s(msgText, sizeof(msgText), "Current working, mode %d \r\n", *currentWM);
        working_mode = *currentWM;

		// Send to IoTHub a message with working mode	
        if ((messages[0].messageHandle = IoTHubMessage_CreateFromByteArray((const unsigned char*)msgText, strlen(msgText))) == NULL){
                    (void)printf("ERROR: iotHubMessageHandle is NULL!\r\n");
                    return -1;
        } else {
                    messages[0].messageTrackingId = 0; 
                    if (IoTHubClient_LL_SendEventAsync(iotHubClientHandle, messages[0].messageHandle, SendConfirmationCallback, &messages[0]) != IOTHUB_CLIENT_OK)
                    {
                        (void)printf("ERROR: IoTHubClient_LL_SendEventAsync..........FAILED!\r\n");
                        return -1;
                    }
        }

        (void)printf("Now wait for commands.  \r\n");
              
        /* Wait for Commands. */
        while ( (b_exit_run == false) && (index < timeToWaitForCommands) )
        {
            IoTHubClient_LL_DoWork(iotHubClientHandle);
            delay(100);
            index++;
        }
        

        if ( (b_exit_run == true) && ( (working_mode == mkr_weather) || (working_mode == mkr_stocks) ) ) {
             index = 0;
             while (msgCmd[index] != '\0'){
                 argument[index] = msgCmd[index];
                 index++;
              }
              argument[index] = '\0';
             
          }
        
        if ( *currentWM != working_mode){
          *currentWM = working_mode;
        }  
        b_exit_run = false;
 
        return 0;
}


void iothub_client_sample_http_close(void)
{
    IoTHubClient_LL_Destroy(iotHubClientHandle);
}



