Option Explicit
'
'  Script.....:  pictureupdate.vbs
'  Author.....:  John Mangan - www.manganlabs.com
'  Purpose....:  This script will read files from a configurable directory above it and output
'                a text file with this list of the image files found in the following format:
'                below. 
'                 pics\filename1.jpg
'                 pics\filename2.jpg
'                The picture file folder name and output filename are definable below
'                It will output JPG, GIF, BMP, and PNG image files only
'  Inputs.....:  None
'  Output.....:  File with list of pictures (overwritten if it already exists)
'
'
'
Dim sFileName 
Dim objFSO
Dim iFileCount
Dim sPicFolder
iFileCount = 0
sFileName = "pictureshow.txt"
sPicFolder = "pics"


getFiles
Set objFSO = Nothing

'StartHere
Sub getFiles()
	Dim objStartFolder
	Dim objFolder 'As Scripting.Folder
  Dim objFile 'As Scripting.File
  Dim colFiles 'As file collection
   
  Set objFSO = CreateObject("Scripting.FileSystemObject") 
  objStartFolder = getCurDirectory()
  Set objFolder = objFSO.GetFolder(objStartFolder & "\" & sPicFolder)
	Set colFiles = objFolder.Files

	For Each objFile in colFiles
    Call fileFilter(objFile.Name)
	Next 'objFile
	
	WScript.Echo "=============================================="
	WScript.Echo "Operation Complete!"
	WScript.Echo iFileCount & " files found and logged."
	WScript.Echo "=============================================="
  
End Sub

'
'  Sub........:  fileFilter
'  Author.....:  John Mangan 09/15/2007
'  Purpose....:  Logs only file extensions that are
'                captured in the select case statement
'                below. 
'  Inputs.....:  sFile
'  Output.....:  File logged
' 
Sub fileFilter(ByVal sFile)
	Dim sFileExtension
	
	sFileExtension = UCase(objFSO.GetExtensionName(sFile))
	
	Select Case sFileExtension
	Case "JPG"
		Call foundOne(sFile)
	Case "GIF"
		Call foundOne(sFile)
	Case "BMP"
		Call foundOne(sFile)
	Case "PNG"
		Call foundOne(sFile)
	End Select

End Sub

Sub foundOne(sFile)
	'Delete the old file list if found
	If iFileCount = 0 Then
		If objFSO.FileExists(sFileName) Then
  		objFSO.DeleteFile sFileName
   		WScript.Echo "* Old File Deleted" & vbCrLf
		End If 
	End If
	
	Wscript.Echo "File Found: " & sFile
  Call WriteFile(sFileName, sPicFolder & "\" & sFile)		
  iFileCount = iFileCount + 1
End Sub

'
'  Function...:  getCurDirectory
'  Author.....:  John Mangan 09/15/2007
'  Purpose....:  Returns the current directory in which
'                the script is running.
'  Inputs.....:  None
'  Returns....:  Current Direcotry
' 
Function getCurDirectory()
	Dim oShell
	set oShell = createobject("wscript.shell")
	getCurDirectory = oShell.currentdirectory
	
End Function

'
'  Sub........:  WriteFile
'  Author.....:  John Mangan 08/01/2003
'  Purpose....:  Writes the given string to a given file name
'                If file does not exist, it is created.
'                New entries are appended.
'  Inputs.....:  sLogFile, sString
'  Output.....:  
' 
Sub WriteFile(ByVal sLogFile, ByVal sString)
  Dim sOutputFile
  Dim objFSO
  Dim objFile
  Dim sTime
  Const ForAppending = 8
  
  sOutputFile = date
  sOutputFile = Replace(sOutPutFile, " ", "")
  sOutputFile = Replace(sOutPutFile, "/", "-")
    
  sOutputFile = sLogFile
  
  Set objFSO = CreateObject("Scripting.FileSystemObject")
  
  If objFSO.FileExists(sLogFile) Then
    Set objFile = objFSO.OpenTextFile(sLogFile, ForAppending)
  Else
    Set objFile = objFSO.CreateTextFile(sLogFile, True)
  End If
    
  objFile.WriteLine sString
    
  objFile.Close  
  Set objFile = Nothing 
  
End Sub