// Arduino Leonardo USB keyboard Joystick for use with ESP32 Bot web page key presses

#include<Keyboard.h>
#define jY A0 // the ports are actually reversed because joystick oriented with pins at top in use
#define jX A1
int jXval=0;
int jYval=0;
int lastDir = 5;
int dir = 0;
int xC = 0;
int yC = 0;

void setup() {
 Keyboard.begin();
 
}

void loop() {
  // put your main code here, to run repeatedly:
  jXval = map(analogRead(jX), 1023, 0, -2, 2);
  jYval = map(analogRead(jY), 1023, 0, -2, 2);

  if (jXval > 0 && jYval == 0) { // rotate right
    dir = 6;
  } else if (jXval <0 && jYval == 0) { // rotate left
    dir = 4;
  } else if (jYval < 0 && jXval == 0) { // reverse
    dir = 2;
  } else if (jYval > 0 && jXval == 0) { // forward
    dir = 8;
  } else if (jYval == 0 && jXval == 0) { // stop
    dir = 5;
  } else if (jYval >= 1 && jXval < 0) { // forward left
    dir = 7;
  } else if (jYval >= 1 && jXval > 0) {// forward right
    dir = 9;
  } else if (jYval <= -1 && jXval <= -1) {// reverse left
    dir = 1;
  } else if (jYval <= -1 && jXval >= 1) {// reverse right
    dir = 3;
  }
  if (dir != lastDir) {// if the current direction is different from the last

    lastDir = dir;
   Keyboard.print(lastDir); // send key value to the web page
  }
 delay(180);
}
