# Untitled - By: liented - 週三 10月 9 2019
# 插上電源，手放置鏡頭前，進入充電模式，否則匯入控制函式

import sensor, image, lcd, time
from machine import PWM, Timer

def init():
    # 檢查是否進入充電模式
    lcd.init()
    lcd.mirror(True)
    sensor.reset()
    sensor.set_pixformat(sensor.RGB565)
    sensor.set_framesize(sensor.QVGA)
    sensor.skip_frames(time = 100)
    img = sensor.snapshot()
    hog = img.get_histogram()
    th = hog.get_threshold()
    lcd.draw_string(160,100,str(th.l_value()))
    if th.l_value() < 30:    
        while True:    
            continue
# 小車行進控制
c0 = Timer(Timer.TIMER0, Timer.CHANNEL0, mode=Timer.MODE_PWM)
p0 = PWM(c0, freq=500000, duty=0, pin=0)

c1 = Timer(Timer.TIMER0, Timer.CHANNEL1, mode=Timer.MODE_PWM)
p1 = PWM(c1, freq=500000, duty=0, pin=1)

c2 = Timer(Timer.TIMER0, Timer.CHANNEL2, mode=Timer.MODE_PWM)
p2 = PWM(c2, freq=500000, duty=0, pin=2)

c3 = Timer(Timer.TIMER0, Timer.CHANNEL3, mode=Timer.MODE_PWM)
p3 = PWM(c3, freq=500000, duty=0, pin=3)

def stop():
    p0.duty(0)
    p1.duty(0)
    p2.duty(0)
    p3.duty(0)

def f_l(sp):
    p2.duty(0)
    p3.duty(sp)

def f_r(sp):
    p0.duty(sp)
    p1.duty(0)

def b_l(sp):
    p2.duty(sp)
    p3.duty(0)

def b_r(sp):
    p0.duty(0)
    p1.duty(sp)

def forward(sp):
    f_l(sp)
    f_r(sp)

def back(sp):
    b_l(sp)
    b_r(sp)

def left_run(sp):
    f_l(0)
    f_r(sp)

def right_run(sp):
    f_r(0)
    f_l(sp)

def left_turn(sp):
    b_l(sp)
    f_r(sp)

def right_turn(sp):
    f_l(sp)
    b_r(sp)
