# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：循線
# 本例輸出為左右旋轉角度
# 用法：鏡頭跟跑道呈約45度，而且視線內只有線
import car, sensor, image, math
car.init()
GRAYSCALE_THRESHOLD = [(128, 255)]  # 追踪白線
#GRAYSCALE_THRESHOLD = [(0, 64)]    # 追踪黑線
# 各區域權重 roi (x, y, w, h)，視情形調整
ROIS = [ # [ROI, weight]
        (0, 100, 160, 20, 0.6), 
        (0,  50, 160, 20, 0.3), 
        (0,   0, 160, 20, 0.1)
       ]
sensor.set_framesize(sensor.QQVGA)
sensor.set_auto_gain(False) 
sensor.set_auto_whitebal(False) 
lcd.mirror(True)
while(True):
    clock.tick() 
    img = sensor.snapshot() 
    center_pos = 0
    for r in ROIS:
        # 找出每個區域符合閾值的色塊
        blobs = img.find_blobs(GRAYSCALE_THRESHOLD, 
            roi=r[0:4], merge=True) # r[0:4] is roi tuple.
        if blobs:
            # 挑出色塊內單一像素最多的那一塊，此例為一截白色塊
            largest_blob = max(blobs, key=lambda b: b.pixels())
            # 針對目標物繪制長方形和十字
            img.draw_rectangle(largest_blob.rect())
            img.draw_cross(largest_blob.cx(),
                           largest_blob.cy())
            # 調整中心點X位置
            center_pos += largest_blob.cx() * r[4] 
            # r[4] is the roi weight.
    lcd.display(img)
    deflection_angle = 0
    # 80：X半軸，60：Y半軸 
    # 透過三角函數atan得到輸出範圍：-45度～45度
    deflection_angle = -math.atan((center_pos-80)/60)
    deflection_angle = math.degrees(deflection_angle)
    lcd.draw_string(20,20, str(deflection_angle), lcd.RED, lcd.BLACK)
