# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：顏色追踪
import car, sensor, image
car.init()
# step 1: 一開始不要放待追踪物件（例如：圓形綠球）
# step 2: "put object"..將物件放置於鏡頭前，充滿整個ROI視窗
# step 3: "tracking..."..改變物件位置，物件將被追踪
sensor.set_pixformat(sensor.RGB565)
sensor.set_auto_gain(False)
sensor.set_auto_whitebal(False)
lcd.mirror(True)
# ROI 視窗
r = [(320//2)-(50//2), (240//2)-(50//2), 50, 50]
lcd.draw_string(60,100,'put object', lcd.RED, lcd.BLACK)
time.sleep(2)
threshold = [50, 50, 0, 0, 0, 0] 
for i in range(60):
    img = sensor.snapshot()
    # 計算ROI內的直方圖，直方圖為圖片的色彩分佈圖
    hist = img.get_histogram(roi=r)
    # 以直方圖1%和99%之間為範圍取樣，共計60次，之後做為閾值
    lo = hist.get_percentile(0.01) 
    hi = hist.get_percentile(0.99)  
    threshold[0] = (threshold[0] + lo.l_value()) // 2
    threshold[1] = (threshold[1] + hi.l_value()) // 2
    threshold[2] = (threshold[2] + lo.a_value()) // 2
    threshold[3] = (threshold[3] + hi.a_value()) // 2
    threshold[4] = (threshold[4] + lo.b_value()) // 2
    threshold[5] = (threshold[5] + hi.b_value()) // 2
    for blob in img.find_blobs([threshold], pixels_threshold=100, 
        area_threshold=100, merge=True, margin=10):
        img.draw_rectangle(blob.rect())
        img.draw_cross(blob.cx(), blob.cy())
        img.draw_rectangle(r)
    lcd.display(img)   
    
lcd.draw_string(60,140,'Tracking...', lcd.RED, lcd.BLACK)
time.sleep(2)
# 自由移動物體進行偵測
while(True):
    clock.tick()
    img = sensor.snapshot()
    for blob in img.find_blobs([threshold], pixels_threshold=100, 
        area_threshold=100, merge=True, margin=10):
        img.draw_rectangle(blob.rect())
        img.draw_cross(blob.cx(), blob.cy())
    lcd.display(img)
