# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：顏色追踪
# 將待測物放置鏡頭中央
'''
註：導引棒顏色
紅 47 52    54 63   17 35
綠 62 69   -59-49   14 33
黃 89 95   -29-20   40 52
藍 25 31    20 42  -73-54 
'''
import car, sensor, image
car.init()
sensor.set_pixformat(sensor.RGB565)
lcd.mirror(False)
sensor.set_hmirror(False)
# ROI 視窗
r = [(320//2)-(50//2), (240//2)-(50//2), 50, 50]
lcd.draw_string(60,100,'put object', lcd.RED, lcd.BLACK)
#time.sleep(2)
threshold = [50, 50, 0, 0, 0, 0] 
for t in range(60):
    img = sensor.snapshot()
    # 計算ROI內的直方圖，直方圖為圖片的色彩分佈圖
    hist = img.get_histogram(roi=r)
    # 以直方圖1%和99%之間為範圍取樣，共計60次，之後做為閾值
    lo = hist.get_percentile(0.01) 
    hi = hist.get_percentile(0.99)  
    threshold[0] = (threshold[0] + lo.l_value()) // 2
    threshold[1] = (threshold[1] + hi.l_value()) // 2
    threshold[2] = (threshold[2] + lo.a_value()) // 2
    threshold[3] = (threshold[3] + hi.a_value()) // 2
    threshold[4] = (threshold[4] + lo.b_value()) // 2
    threshold[5] = (threshold[5] + hi.b_value()) // 2
    for blob in img.find_blobs([threshold], pixels_threshold=100, 
        area_threshold=100, merge=True, margin=10):
        img.draw_rectangle(blob.rect())
        img.draw_cross(blob.cx(), blob.cy())
        img.draw_rectangle(r)
    # 顯示顏色LAB thresholds   
    c = (0,255,0) if t==59 else (255,0,0)   
    for i in range(0,3):
        idx = 2*i
        img.draw_string(10, 170+i*20, '[%d]=%4d ,[%d]=%4d'%(idx,threshold[idx],idx+1,threshold[idx+1]),color=c, scale=2)  
    img.replace(hmirror=True)    
    lcd.display(img)      

