# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：臉部和眼睛辨識 約5fps
import car, sensor, image
car.init()
sensor.set_contrast(1)
sensor.set_gainceiling(16)
lcd.mirror(True)
#載入臉部特徵
face_cascade = image.HaarCascade("frontalface", stages=25)
#載入眼睛特徵
eyes_cascade = image.HaarCascade("eye", stages=24)
while (True):
    img = sensor.snapshot()
    # 找臉部，倍率放大些 1.5
    objects = img.find_features(face_cascade, threshold=0.5, 
      scale_factor=1.5)
    for face in objects:
        # 畫臉部
        img.draw_rectangle(face)
        # 從臉部找眼睛，倍率小些 1.2 
        eyes = img.find_features(eyes_cascade, threshold=0.5, 
          scale_factor=1.2, roi=face)
        for e in eyes:
            img.draw_rectangle(e)
    lcd.display(img)
    lcd.draw_string(10,10, str(clock.fps()), lcd.RED, lcd.BLACK)
