# Face Detection Example
# 臉部識別
# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：臉部辨識
# 本例力能為調整對比和AGC，以比較不同的識別度
import car, sensor, image
car.init()
img = image.Image()
sensor.set_contrast(1)      # 設定對比度為1，其值通常為-2～2
sensor.set_gainceiling(16)  # 設定上限為16的自動增益
lcd.mirror(True)
# 載入臉部特徵
face_cascade = image.HaarCascade("frontalface", stages=25)
while (True):
    img = sensor.snapshot()
    objects = img.find_features(face_cascade, threshold=0.75, 
      scale_factor=1.25)
    for r in objects:
        img.draw_rectangle(r)
    lcd.display(img)
