"""
    tinyLiDAR GUI Terminal Menu Variables in micropython for ESP32
    Last Edit: April 12, 2018 by Dinesh Bhatia
    Copyright © 2018 MicroElectronicDesign, Inc. (www.microed.co)
    This work is licensed under Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0)
    https://creativecommons.org/licenses/by-sa/3.0/legalcode
"""

default_tinyLiDAR_address = 0x10  # the Default tinyLiDAR address
I2C_Address = default_tinyLiDAR_address # I2C address that ESP32 will talk to (ie Terminal's address)
i2cAdr =  default_tinyLiDAR_address  	# tinyLiDAR's address
cal_offset_distance = 100 # exact distance to target in mm used for the CD command 
cal_xtalk_distance = 400 # exact distance to target in mm used for the CX command

# default config values for the W command
SignalRateLimit = 10 #default value for SignalRateLimit which can be 0.00 to 65.00 MCPS, is entered here as 100x the required value
SignalEstimateLimit = 60 #default value for SignalEstimateLimit in mm 
TimingBudget = 20 #default value for TimingBudget in milliseconds (ms), value can be 18 to 2000ms for tinyLiDAR

TimingBudget_max = 200 # default max in case tinyLiDAR was set to PH in previous session
_bufferTime = 40 # some extra time for for ESP to read data

VCELperiod = 18 #default value for VCELperiod selection, can choose either 18/14 or 14/10. 18 = 18/14, 14 = 14/10
rebootTime = 1000 # time in ms

# default config values for the A command
LowLimit = 10 # in mm 
HighLimit = 100 # in mm
RepetitionInt = 20 # in 0.1sec increments
PulseWidth = 5 # default PW is 0 for 1ms else in 0.1sec increments 
LEDind = True # is ON, False is OFF

# default config values for the B command
Op_Mode_B = 0 # 0 is false to indicate State Tracking Mode, 1 for Object Detection mode
LowLimit_B = 50 # default Lower threshold in mm, 10 to 2000mm 
HighLimit_B = 100 # default Upper threshold in mm, 10 to 2000mm 
Delay_Btwn_B = 100 # default delay between measurements in ms, 1 to 65535ms 
LEDind_B = True # default is LED indicator ON when triggered, False = Off, True = On

# available commands
tinyLiDAR_commands = {  

	'D': "'D' to measure distance                                                          ", 
	'DC': "'DC' Continuous Read from Terminal                                              ", 
	'Y': " 'Y' to save LED config and reboot                                               ", 
	'E': " 'E' LED off                                                                     ", 
	'F': " 'F' LED indicator                                                               ", 
	'G': " 'G' LED on                                                                      ", 
	'I': " 'I' set terminal's I2C address                                                  ", 
	'Q': " 'Q' configuration parameters                                                    ", 
	'R': " 'R' set tinyLiDAR's I2C address                                                 ", 
	'W': " 'W' write custom VL53L0X config                                                 ", 
	'PL': " 'P L' long range preset                                                        ",
	'PS': " 'P S' high speed preset                                                        ",
	'PH': " 'P H' high accuracy preset                                                     ",
	'PT': " 'P T' tinyLiDAR preset                                                         ",
	'MS': " 'M S' SingleStep Ultralow Power mode                                           ",
	'MR': " 'M R' Real Time mode                                                           ",
	'RESET': " 'Reset' command will set all connected boards to Factory Defaults           ", 
	'X': " 'X' reboot tinyLiDAR                                                            ", 
	'T0': " 'T 0' WDT Off                                                                  ", 
	'T1': " 'T 1' WDT On                                                                   ", 
	'CD': " 'C D' Perform Offset Cal at a distance of 100mm                                ", 
	'CX': " 'C X' calibrate crosstalk                                                      ", 
	'A': " 'A' start auto mode                                                             ", 
	'B': " 'B' start Autonomous IoT mode                                                   ",
	'AZ': " 'A Z' Autonomous Mode Exit                                                     ",
	'U': " 'U' start ultrasonic emulation mode                                             ",
	'UZ': " 'U Z' ultrasonic Emulation Mode Exit                                           " 

}

    # ============================================================================
    # ============================================================================
    # ============================================================================ 