"""
    tinyLiDAR GUI Terminal Menu in micropython for ESP32
    Last Edit: April 1, 2018 by Dinesh Bhatia
    Copyright © 2018 MicroElectronicDesign, Inc. (www.microed.co)
    This work is licensed under Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0)
    https://creativecommons.org/licenses/by-sa/3.0/legalcode
"""

import tinyLiDAR_var as tlv
   
def printMenu():
   print(u"\u001b[2J\u001b[100A")
   print(u" \u001b[32;1m\
 tinyLiDAR Command Terminal GUI v0.95 for ESP32\u001b[0m ")
   print(u"\u001b[34m  Default I2C target address is \u001b[7m0x%X\u001b[0m " % tlv.I2C_Address)

def printMenu1(): 
   print(u"\
   \u001b[33;1md\u001b[0m - read distance                    \u001b[33;1mdc\u001b[0m - continuous read (from terminal) \n\
   \u001b[33;1mq\u001b[0m - query settings                   \u001b[33;1mw\u001b[0m - write custom VL53L0X config \n\
   \u001b[33;1mmr\u001b[0m - real time mode                  \u001b[33;1mms\u001b[0m - single step/ULP mode\n\
   \u001b[33;1mreset\u001b[0m - reset to factory defaults    \u001b[33;1mb\u001b[0m - start autonomous IoT mode \n\
   \u001b[33;1mpl\u001b[0m - long range preset               \u001b[33;1mps\u001b[0m - high speed preset \n\
   \u001b[33;1mph\u001b[0m - high accuracy preset            \u001b[33;1mpt\u001b[0m - tinyLiDAR preset \n\
   \u001b[33;1me\u001b[0m - disable LED indicator            \u001b[33;1mf\u001b[0m - enable LED indicator \n\
   \u001b[33;1mg\u001b[0m - LED on                           \u001b[33;1mt0/t1\u001b[0m - Disable/Enable WatchDog Timer \n\
   \u001b[33;1mcd\u001b[0m - cal offset distance             \u001b[33;1mcx\u001b[0m - cal crosstalk \n\
   \u001b[33;1mx\u001b[0m - reboot tinyLiDAR                 \u001b[33;1my\u001b[0m - save LED mode and reboot tinyLiDAR \n\
   \u001b[33;1marXX\u001b[0m - auto I2C addr config loop     \u001b[33;1mv\u001b[0m - scan & verify I2C addr loop \n\
   \u001b[33;1mrXX\u001b[0m - change tinyLiDAR's I2C addr    \u001b[33;1miXX\u001b[0m - change Terminal's I2C addr \n\
   \u001b[33;1ma\u001b[0m - start autonomous mode            \u001b[33;1maz\u001b[0m - end autonomous mode \n\
   \u001b[33;1mu\u001b[0m - start ultrasonic emulation mode  \u001b[33;1muz\u001b[0m - end ultrasonic emulation mode \n\
    \
" )
   print("> Please enter a command [XX = Hex I2C Addr, \u001b[7mCTRL+C\u001b[0m to quit]")

def home(extraLines = 0):
	i = 17+extraLines
	print(u"\u001b[40A\u001b[90D\u001b[%dB" % i) # position cursor

def home_clr(extraLines = 0):
	i = 17+extraLines
	print(u"\u001b[40A\u001b[90D\u001b[%dB" % i) # position cursor
	print("                                                                            ") # clear line
	print("                                                                            ") # clear line	
	print("                                                                            ") # clear line
	print(u"\u001b[3A") # position cursor

def _clrScrn():
	print(u"\u001b[2J\u001b[100A")
	printMenu()
	printMenu1()

    # ============================================================================
    # ============================================================================
    # ============================================================================ 