""" 

	Startup code to connect ESP32 to WiFi network using a static IP address
    Last Edit: April 12, 2018 by Dinesh Bhatia
    Copyright © 2018 MicroElectronicDesign, Inc. (www.microed.co)
    This work is licensed under Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0)
    https://creativecommons.org/licenses/by-sa/3.0/legalcode

"""

    # ============================================================================
	# TODO: Change as needed for your WiFi network
    # ============================================================================
desired_IP_address = '192.168.0.107'  # desired static IP address
gateway_address = '192.168.0.1' # your AP's address
dns_address = '192.168.0.1'  # your AP's address
wifi_ssid = 'YOURSSID'  # your AP's SSID
wifi_password = 'YOURPASSWORD' # your WiFi network password
connection_timeout = 15 # timeout in seconds - increase if needed
    # ============================================================================

import machine, time
from network import WLAN

if machine.reset_cause() != machine.SOFT_RESET:
	wlan = WLAN(mode=WLAN.STA)
	wlan.ifconfig(config=(desired_IP_address, '255.255.255.0', gateway_address, dns_address))
	wlan.connect(ssid=wifi_ssid, auth=(WLAN.WPA2, wifi_password))

	i = 0
	print("\n\r> Connecting to WiFi network, please wait...")
	while (not wlan.isconnected() and i < connection_timeout) :
		time.sleep(1)
		i +=1
		print(i)

	if (i==connection_timeout):
		print("> *** Error! *** Timed out connecting to the WiFi network. \n\r")
	else:
		print("> Success! Address = %s " % wlan.ifconfig()[0] )    
		print("> Ready for FTP \n\r")   
            
    # ============================================================================
    # ============================================================================
    # ============================================================================
	