// Adafruit IO Feed Reading
// Tutorial Link: https://learn.adafruit.com/adafruit-io-basics-feeds/sharing-a-feed
//
// Adafruit invests time and resources providing this open source code.
// Please support Adafruit and open source hardware by purchasing
// products from Adafruit!
//
// Written by Brent Rubell for Adafruit Industries
// Copyright (c) 2018 Adafruit Industries
// Licensed under the MIT license.
//
// All text above must be included in any redistribution.


//***********************************************************

// THIS EXAMPLE WAS MADE BY JOOST HUTER
// instructables: https://www.instructables.com/id/Remote-Controlled-Timer-With-NodeMCU

//***********************************************************

// edit the config.h tab and enter your Adafruit IO credentials
// and any additional configuration needed for WiFi, cellular,
// or ethernet clients.
#include "config.h"



// the Adafruit IO username of whomever owns the feed
#define FEED_OWNER "XXXXXXXXXXXX"

// set up the `sharedFeed`
AdafruitIO_Feed *sharedFeed = io.feed("XXXXXXXXXXX", FEED_OWNER);

// set up NeoPixel connection
#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
#include 
#endif
#define LED_PIN     D5 // Where is the LED strip connected to?
#define LED_COUNT  30 // How many pixels does it have?
#define BRIGHTNESS 50 // NeoPixel brightness, 0 (min) to 255 (max)
Adafruit_NeoPixel strip(LED_COUNT, LED_PIN, NEO_GRB + NEO_KHZ800);


unsigned long previousMillis = 0;        // will store last time the LED strip was updated
int interval = 1000;           // interval of our timer (milliseconds)

int blinkStatus = 1; // tells the blinkie(); function wether the light should be on or off
int leds = LED_COUNT-1; // tels how many pixels should be lit

int adaData; // collects the data AdaFruit sends us

void setup() {
  
  // start the serial connection
  Serial.begin(115200);

  // wait for serial monitor to open
  while(! Serial);

  // connect to io.adafruit.com
  Serial.print("Connecting to Adafruit IO");
  io.connect();

  // set up a message handler for the 'sharedFeed' feed.
  // the handleMessage function (defined below)
  // will be called whenever a message is
  // received from adafruit io.
  sharedFeed->onMessage(handleMessage);

  // wait for a connection
  while(io.status() < AIO_CONNECTED) {
    Serial.print(".");
    delay(500);
  }

  // we are connected
  Serial.println();
  Serial.println(io.statusText());
  sharedFeed->get();

  strip.begin();           // INITIALIZE NeoPixel strip object (REQUIRED)
strip.show();            // Turn OFF all pixels ASAP
strip.setBrightness(50); // Set BRIGHTNESS to about 1/5 (max = 255)
  ledsOn(); // Calls the function to turn on each LED one by one


}

void loop() {

  // io.run(); is required for all sketches.
  // it should always be present at the top of your loop
  // function. it keeps the client connected to
  // io.adafruit.com, and processes any incoming data.
  io.run();

unsigned long currentMillis = millis();

// start TIMER RYTHM ******************************************************
if (currentMillis - previousMillis >= interval) {
    previousMillis = currentMillis;

    if (adaData == 0) {
      Serial.println("im not running");
    } else if (adaData == 1) {
      timer();
    }   else if (adaData == 2) {
      rerun();
    }
    strip.show();

  }
// end TIMER RYTHM ********************************************************





}

// this function is called whenever an 'sharedFeed' feed message
// is received from Adafruit IO. it was attached to
// the 'digital' feed in the setup() function above.
void handleMessage(AdafruitIO_Data *data) {

  adaData = data->toInt();

  Serial.print("received <-  ");
  Serial.println(data->toInt());
  
}

void ledsOn() {
  for (int i = 0; i < strip.numPixels(); i++) { // For each pixel in strip...
    strip.setPixelColor(i, 0, 0, 255);         //  Set pixel's color to blue
    strip.show();                          //  Update strip to match
}
}

void timer() {
  strip.setPixelColor(leds, 0, 0, 0);
 if (leds > -1) {
    leds--;
  } else {
    blinkie();
  }
}

void blinkie() {

  if (blinkStatus == 1) {
    blinkStatus = 0;
    strip.clear();
  } else {
    blinkStatus = 1;
    for (int i = 0; i < strip.numPixels(); i++) { // For each pixel in strip...
      strip.setPixelColor(i, 255, 0, 0);         //  Set pixel's color (in RAM)
      strip.show();                          //  Update strip to match    } 
 }
}
}

void rerun() {
  leds = LED_COUNT;
  ledsOn();
}
