#!/usr/bin/python

# Troubleshooting
# Make sure the ref to python in line one /usr/bin/python point to your python directory
# Make sure the file WebInterfaceKit.py is in the cgi-bin /var/www/cgi-bin and executable (run chmod -R /var/www/cgi-bin)

from Phidgets.PhidgetException import *
from Phidgets.Events.Events import *
from Phidgets.Devices.InterfaceKit import *
 
import cgi
import cgitb
 
cgitb.enable()
errors = ""
 
# Print the HTML header
print('Content-type: text/html\n\n')
print('<html><head><meta http-equiv="refresh" content="30"><meta http-equiv="pragma" content="no-cache" ><meta http-equiv="expires" content="-1"><title>SUNLOG MANAGEMENT</title><body background="/images/homeiq.jpg" size="300">\n')
print('<center><b><font size="16" color="#0000ff">SUNLOG MANAGEMENT</font></b></center><br>')

# Create, Open, and Attach the Interface Kit
try:
    ifk = InterfaceKit()
except RuntimeError as e:
    errors = errors + "<h5>Runtime Exception on object creation: " + e.details + "</h5>\n"
try:
    ifk.openPhidget()
except PhidgetException as e:
    errors = errors + "<h5>Phidget Exception on Open: " + e.details + "</h5>\n"
try:
    ifk.waitForAttach(10000)
except PhidgetException as e:
    errors = errors + "<h5>Phidget Exception on Attach: " + e.details + "</h5>\n"
    errors = errors + "<h5>If Phidget is 'Not Physically Attached' it may be in use</h5>\n"

# Generate the Analog Sensor Value table for Sunlog
try:
    s1Current=ifk.getSensorValue(0)
    s2Current=ifk.getSensorValue(1)
    s3Current=ifk.getSensorValue(2)
    sunAmps=ifk.getSensorValue(3)
    loadedAmps=ifk.getSensorValue(4)
    temp=ifk.getSensorValue(5)
    batVolt=ifk.getSensorValue(6)
    acCurrentIn=ifk.getSensorValue(7)
    acCurrentInState=ifk.getOutputState(0)
    s1CurrentState=ifk.getOutputState(6)
    s2CurrentState=ifk.getOutputState(5)
    s3CurrentState=ifk.getOutputState(7)    
except:
    print('<br>Coould not read analog censors')

if acCurrentInState==True:
    acIn='ON'
else:
    acIn='OFF'
if s1CurrentState==True:
    s1State='ON'
else:
    s1State='OFF'
if s2CurrentState==True:
    s2State='ON'
else:
    s2State='OFF'
if s3CurrentState==True:
    s3State='ON'
else:
    s3State='OFF'

# DC current censors can not be <0
transLoadedAmps=loadedAmps/13.2-37.8787
transSunAmps=sunAmps/13.2-37.8787
if transLoadedAmps<0.001:
    transLoadedAmps=0.0
if transSunAmps<0.001:
    transSunAmps=0.0

print('<table><tr><td><table border="1"><tr><td><b>Sensor<br>num</b></td><td><b>Sensor Description</b></td><td><b>Sensor Value</b></td><td><b>Transformed<br>Sensor Value</b></td><td><b>State</b></td><td><b>Switch<br>On</b></td><td><b>Switch<br>Off</br></td></tr>')
print('<tr><td>0</td><td>AC Current Output delivered to S1</td><td>'+str(s1Current)+'</td><td>'+str(s1Current*0.04204)+' Amp</td><td>'+s1State+' (DO 6)</td><td><a href="s1_on.py">ON</a></td><td><a href="s1_off.py">Off</a></td></tr>')
print('<tr><td>1</td><td>AC Current Output Delivered to S2</td><td>'+str(s2Current)+'</td><td>'+str(s2Current*0.04204)+' Amp</td><td>'+s2State+' (DO 5)</td><td><a href="s2_on.py">ON</a></td><td><a href="s2_off.py">Off</a></td></tr>')
print('<tr><td>2</td><td>AC Current Output Delivered to S3</td><td>'+str(s3Current)+'</td><td>'+str(s3Current*0.04204)+' Amp</td><td>'+s3State+' (DO 7)</td><td><a href="s3_on.py">ON</a></td><td><a href="s3_off.py">Off</a></td></tr>')
print('<tr><td>3</td><td>DC Current Generated by Solar Sun</td><td>'+str(sunAmps)+'</td><td>'+str(transSunAmps)+' Amp</td><td>Always On</td><td>N/A</td><td>N/A</td></tr>')
print('<tr><td>4</td><td>DC Current Loaded on batteries</td><td>'+str(loadedAmps)+'</td><td>'+str(transLoadedAmps)+' Amp</td><td>Always On</td><td>N/A</td><td>N/A</td></tr>')
print('<tr><td>5</td><td>Inside Temperature</td><td>'+str(temp)+'</td><td>'+str(temp*0.22222-61.11)+' &deg;C</td><td>Always On</td><td>N/A</td><td>N/A</td></tr>')
print('<tr><td>6</td><td>Battery Voltage</td><td>'+str(batVolt)+'</td><td>'+str(batVolt*0.071482-33.7504)+' Volt</td><td>Always On</td><td>N/A</td><td>N/A</td></tr>')
print('<tr><td>7</td><td>AC Current Input from Utility</td><td>'+str(acCurrentIn)+'</td><td>'+str(acCurrentIn*0.04204)+' Amp</td><td>'+acIn+' (DO 0)</td><td><a href="acinput_on.py">ON</a></td><td><a href="acinput_off.py">Off</a></td></tr>')

print('</table></td></tr></table>')

print('<br>&#169 J J Slabbert') 
print('<br><a href="mailto:jaco.slabbert@mweb.co.za">jaco.slabbert@mweb.co.za</a><br><br>')
print('</body></head></html>\n')
 
ifk.closePhidget()
exit()
