#!/usr/bin/python

#Troubleshooting
#Make sure the ref to python in line one /usr/bin/python point to your python directory
#Make sure the file WebInterfaceKit.py is in the cgi-bin /var/www/cgi-bin and executable (run chmod -R /var/www/cgi-bin)

from Phidgets.PhidgetException import *
from Phidgets.Events.Events import *
from Phidgets.Devices.InterfaceKit import *
 
import cgi
import cgitb
import time
 
cgitb.enable()
errors = ""
 
#Print the HTML header
print('Content-type: text/html\n\n')
print('<html><title>SUNLOG MANAGEMENT</title><body>\n')
print('<center><b><font size="16" color=" 0000ff">SUNLOG MANAGEMENT</font></b></center><br>')
print('<br>& 169 J J Slabbert') 
print('<br><a href="mailto:jaco.slabbert@mweb.co.za">jaco.slabbert@mweb.co.za</a><br><br>')

#Create, Open, and Attach the Interface Kit
try:
    ifk = InterfaceKit()
except RuntimeError as e:
    errors = errors + "<h5>Runtime Exception on object creation: " + e.details + "</h5>\n"
try:
    ifk.openRemoteIP('192.168.10.106',5001)
except PhidgetException as e:
    errors = errors + "<h5>Phidget Exception on Open: " + e.details + "</h5>\n"
try:
    ifk.waitForAttach(10000)
except PhidgetException as e:
    errors = errors + "<h5>Phidget Exception on Attach: " + e.details + "</h5>\n"
    errors = errors + "<h5>If Phidget is 'Not Physically Attached' it may be in use</h5>\n"
ifk.closePhidget()
i=0
sunamps=0.00
print('.........................................|0.00-0.90|1.00-1.90|2.00-2.90|3.00-3.90|4.00-4.90|5.00-5.90|6.00-6.90|7.00-7.90|8.00-8.90|9.00-9.90|10.0-10.9|11.0-11.9|12.0-12.9|13.0-13.9|')
bar=''
while i<3:
    try:
        ifk = InterfaceKit()
        ifk.openRemoteIP('192.168.10.106',5001)
        ifk.waitForAttach(10000)
        sunamps=ifk.getSensorValue(3)/13.2-37.8787
    except:
        print('<br>Could not read sun amps')
    if sunamps<0.05:
        sunamps=0
    if sunamps>0.1:
        bar='|-........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|'
    if sunamps>0.3:
        bar='|---......|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|'
    if sunamps>0.5:
        bar='|-----....|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|'
    if sunamps>0.7:
        bar='|-------..|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|.........|'
    if sunamps>0.9:
        bar='|---------|         |         |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>1.1:
        bar='|---------|-        |         |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>1.3:
        bar='|---------|---      |         |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>1.5:
        bar='|---------|-----    |         |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>1.7:
        bar='|---------|-------  |         |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>1.9:
        bar='|---------|---------|         |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>2.1:
        bar='|---------|---------|-        |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>2.3:
        bar='|---------|---------|---      |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>2.5:
        bar='|---------|---------|-----    |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>2.7:
        bar='|---------|---------|-------  |         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>2.9:
        bar='|---------|---------|---------|         |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>3.1:
        bar='|---------|---------|---------|--       |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>3.3:
        bar='|---------|---------|---------|----     |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>3.5:
        bar='|---------|---------|---------|------   |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>3.7:
        bar='|---------|---------|---------|-------- |         |         |         |         |         |         |         |         |         |         |'
    if sunamps>3.9:
        bar='|---------|---------|---------|---------|         |         |         |         |         |         |         |         |         |         |'
    if sunamps>4.1:
        bar='|---------|---------|---------|---------|--       |         |         |         |         |         |         |         |         |         |'
    if sunamps>4.3:
        bar='|---------|---------|---------|---------|----     |         |         |         |         |         |         |         |         |         |'
    if sunamps>4.5:
        bar='|---------|---------|---------|---------|------   |         |         |         |         |         |         |         |         |         |'
    if sunamps>4.7:
        bar='|---------|---------|---------|---------|-------- |         |         |         |         |         |         |         |         |         |'
    if sunamps>4.9:
        bar='|---------|---------|---------|---------|---------|         |         |         |         |         |         |         |         |         |'
    if sunamps>5.1:
        bar='|---------|---------|---------|---------|---------|--       |         |         |         |         |         |         |         |         |'
    if sunamps>5.3:
        bar='|---------|---------|---------|---------|---------|----     |         |         |         |         |         |         |         |         |'
    if sunamps>5.5:
        bar='|---------|---------|---------|---------|---------|------   |         |         |         |         |         |         |         |         |'
    if sunamps>5.7:
        bar='|---------|---------|---------|---------|---------|-------  |         |         |         |         |         |         |         |         |'
    if sunamps>5.9:
        bar='|---------|---------|---------|---------|---------|---------|         |         |         |         |         |         |         |         |'
    if sunamps>6.1:
        bar='|---------|---------|---------|---------|---------|---------|--       |         |         |         |         |         |         |         |'
    if sunamps>6.3:
        bar='|---------|---------|---------|---------|---------|---------|----     |         |         |         |         |         |         |         |'
    if sunamps>6.5:
        bar='|---------|---------|---------|---------|---------|---------|------   |         |         |         |         |         |         |         |'
    if sunamps>6.7:
        bar='|---------|---------|---------|---------|---------|---------|-------- |         |         |         |         |         |         |         |'
    if sunamps>6.9:
        bar='|---------|---------|---------|---------|---------|---------|---------|         |         |         |         |         |         |         |'
    if sunamps>7.1:
        bar='|---------|---------|---------|---------|---------|---------|---------|--       |         |         |         |         |         |         |'
    if sunamps>7.3:
        bar='|---------|---------|---------|---------|---------|---------|---------|----     |         |         |         |         |         |         |'
    if sunamps>7.5:
        bar='|---------|---------|---------|---------|---------|---------|---------|------   |         |         |         |         |         |         |'
    if sunamps>7.7:
        bar='|---------|---------|---------|---------|---------|---------|---------|-------- |         |         |         |         |         |         |'
    if sunamps>7.9:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|         |         |         |         |         |         |'
    if sunamps>8.1:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|--       |         |         |         |         |         |'
    if sunamps>8.3:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|----     |         |         |         |         |         |'
    if sunamps>8.5:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|------   |         |         |         |         |         |'
    if sunamps>8.7:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|-------- |         |         |         |         |         |'
    if sunamps>8.9:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|         |         |         |         |         |'
    if sunamps>9.1:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|--       |         |         |         |         |'
    if sunamps>9.3:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|----     |         |         |         |         |'
    if sunamps>9.5:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|------   |         |         |         |         |'
    if sunamps>9.7:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|-------- |         |         |         |         |'
    if sunamps>9.9:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|         |         |         |         |'
    if sunamps>10.1:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|--       |         |         |         |'
    if sunamps>10.3:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|----     |         |         |         |'
    if sunamps>10.5:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|------   |         |         |         |'
    if sunamps>10.7:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|-------  |         |         |         |'
    if sunamps>10.9:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|         |         |         |'
    if sunamps>11.1:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|--       |         |         |'
    if sunamps>11.3:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|----     |         |         |'
    if sunamps>11.5:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|------   |         |         |'
    if sunamps>11.7:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|-------- |         |         |'
    if sunamps>11.9:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|         |         |'
    if sunamps>12.1:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|--       |         |'
    if sunamps>12.3:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|----     |         |'
    if sunamps>12.5:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|------   |         |'
    if sunamps>12.7:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|-------- |         |'
    if sunamps>12.9:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|         |'
    if sunamps>13.1:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|--       |'
    if sunamps>13.3:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|----     |'
    if sunamps>13.5:
        bar='|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|---------|------   |'
    i=i+1
    t=t=time.strftime('%H:%M:%S')
    print('<br>'+t+' '+str(sunamps)+' '+bar)
    ifk.closePhidget()
    time.sleep(3)
print ('<br><br>This page does not automaticly refresh')
print ('<br><br><a href="sunlog.py">Refresh this page</a>')
print('</body></html>\n')
 
ifk.closePhidget()
exit()
