;;======================================================================;;
;;		DCC dcoder for 8x MP1 sitch maxhine	 		;;
;;======================================================================;;
;;									;;
;; Program:		blikajici stromek				;;
;; Code:		Jindra Fucik ( http://www.fucik.name )		;;
;; Platform:		Microchip PIC16F15323, 4 Mhz			;;
;; Date:		10.11.2018					;;
;; First release:	10.11.2018					;;
;; LastDate:		10.11.2018					;;
;;									;;
;;======================================================================;;

; This program is for charlieplexed christmass tree

; Processor PIC 16F15323 running at 1MHz internal oscillator.
;
; Revisions:
;
; 10/11/2018	Start of writing code. (PIC16F15323)


; ----- Definitions
;#define		LED_DEBUG	1

#define		__VERNUM	0x01
#define		__SUBVERNUM	0x00
#define		__VERDAY	0x10
#define		__VERMONTH	0x11
#define		__VERYEAR	0x18

    list    p=16F15323,r=hex

    errorlevel -302	; Register in operand not in bank 0.  Ensure that bank bits are correct.
    ;errorlevel -305 ; Using default destination of 1 (file).

; PIC16F15344 Configuration Bit Settings
; Assembly source line config statements

#include "p16f15323.inc"

; CONFIG1
; __config 0xFFEC
 __CONFIG _CONFIG1, _FEXTOSC_OFF & _RSTOSC_HFINT1 & _CLKOUTEN_OFF & _CSWEN_ON & _FCMEN_ON
; CONFIG2
; __config 0xF7FF
 __CONFIG _CONFIG2, _MCLRE_ON & _PWRTE_OFF & _LPBOREN_OFF & _BOREN_ON & _BORV_LO & _ZCD_OFF & _PPS1WAY_OFF & _STVREN_ON
; CONFIG3
; __config 0xFF9F
 __CONFIG _CONFIG3, _WDTCPS_WDTCPS_31 & _WDTE_OFF & _WDTCWS_WDTCWS_7 & _WDTCCS_SC
; CONFIG4
; __config 0xFFEF
 __CONFIG _CONFIG4, _BBSIZE_BB512 & _BBEN_OFF & _SAFEN_ON & _WRTAPP_OFF & _WRTB_OFF & _WRTC_OFF & _WRTSAF_OFF & _LVP_ON
; CONFIG5
; __config 0xFFFF
 __CONFIG _CONFIG5, _CP_OFF
; __CONFIG _CONFIG5, _CP_ON


#define		RAMINI0		0x020		; 80 bytes
#define		RAMINI1		0x0A0		; 80 bytes
#define		RAMINI2		0x120		; 80 bytes
#define		RAMINT		0x070		; 16 bytes

#define		MUI0		0x8100		; Microchip Unique Identifier
#define		MUI8		0x8108		; Microchip Unique Identifier

; ----- Macros

#define		DNOP		goto	$+1

; ----- Constant values

FXTAL		equ	D'1000000'		; Internal oscillator frequency


; PMD = PERIPHERAL MODULE DISABLE
PMD0_INI	equ	b'01000001'	; CLKRMD CLKR enabled; SYSCMD SYSCLK enabled; FVRMD FVR disabled; IOCMD IOC disabled; NVMMD NVM enabled; 
PMD1_INI	equ	b'00000011'	; TMR0MD TMR0 disabled; TMR1MD TMR1 disabled; TMR2MD TMR2 enabled; NCOMD DDS(NCO) enabled; 
PMD2_INI	equ	b'01000111'	; ZCDMD ZCD disabled; CMP1MD CMP1 disabled; ADCMD ADC enaabled; CMP2MD CMP2 disabled; DAC1MD DAC1 disabled; 
PMD3_INI	equ	b'00111111'	; CCP2MD CCP2 disabled; CCP1MD CCP1 disabled; PWM4MD PWM4 disabled; PWM3MD PWM3 disabled; PWM6MD PWM6 disabled; PWM5MD PWM5 disabled; 
PMD4_INI	equ	b'01010001'	; CWG1MD CWG1 disabled; MSSP1MD MSSP1 disabled; UART1MD EUSART disabled; 
PMD5_INI	equ	b'00011110'	; CLC3MD CLC3 disabled; CLC4MD CLC4 disabled; CLC1MD CLC1 disabled; CLC2MD CLC2 disabled; 

; PIN manager
LATA_INI    equ 0x00	    ; all outputs to zero (only RA2, RA4 is out)
LATC_INI    equ 0x00	    ; all outputs to zero (all out)

TRISA_INI   equ b'00101011' ; RA2 is output, RA3 is MCLR
TRISC_INI   equ b'00000000' ; RC0=CMP0out, RC1=eusart.Rx, RC2=cfg button, RC3-5=LEDs

ANSELA_INI  equ b'00100000' ; RA5 to analog = ADC
ANSELC_INI  equ b'00000000' ; all digital

WPUA_INI    equ	0x03	    ; RA0 RA1 WPU
WPUC_INI    equ	0x00	    ; disable WPU

ODCONA_INI  equ	0x00	    ; disable open drain outputs
ODCONC_INI  equ	0x00	    ; disable open drain outputs

; oscilator management
OSCCON1_INI equ 0x60	    ; NOSC HFINTOSC; NDIV 4; 
;OSCCON2 is read only
OSCCON3_INI equ 0x00	    ; CSWHOLD may proceed; 
OSCEN_INI   equ 0x00	    ; MFOEN disabled; LFOEN disabled; ADOEN disabled; EXTOEN disabled; HFOEN disabled; 
OSCFRQ_INI  equ 0x00	    ; HFFRQ 1_MHz; 
OSCSTAT_INI equ 0x00	    ; MFOR not ready; do not understand, it is read only
;OSCTUNE_INI equ 0x20	    ; HFTUN 32; do not understand why MCC set this?
OSCTUNE_INI equ 0x00	    ; HFTUN 0; default

; Timer2 management
T2CLKCON_INI	equ 0x01    ; T2CS FOSC/4; 
T2HLT_INI   equ 0x00    ; T2PSYNC Not Synchronized; T2MODE Software control; T2CKPOL Rising Edge; T2CKSYNC Not Synchronized; 
T2RST_INI   equ 0x00	; T2RSEL T2INPPS pin; 
T2PR_INI    equ d'110'	; T2PR 110 (0.3B); 
;T2TMR = 0x00; TMR2 0; 
T2CON_INI   equ 0x00	; T2CKPS 1:1; T2OUTPS 1:1; TMR2ON off; 

; Timer1 management
;T1GCON_INI	equ 0x00	; T1GE disabled; T1GTM disabled; T1GPOL low; T1GGO done; T1GSPM disabled; 
;T1GATE_INI	equ 0x00	; GSS T1G_pin; 
;T1CLK_INI	equ 0x01	; ClockSelect FOSC/4; 
;;TMR1H = 0x00;    //TMR1H 0; 
;;TMR1L = 0x00;    //TMR1L 0; 
;T1CON_INI	equ 0x34	; CKPS 1:8; nT1SYNC do_not_synchronize; TMR1ON disabled; T1RD16 disabled; 

; Timer0 management
;T0CON1_INI	equ 0x50	; T0CS FOSC/4; T0CKPS 1:1; T0ASYNC not_synchronised; 
;T0CON0_INI	equ 0x10	; T0OUTPS 1:1; T0EN disabled; T016BIT 16-bit; 
;TMR0H_INI	equ 0xFF	; in 8 bit mode the TMR0H is compared same as timer2
;TMR0L = 0x00; TMR0L 0; 

;Analog to digital
ADCCON0_INI	equ b'00010101' ; ADC enabled, ADC input RA5
ADCCON1_INI	equ b'00000000' ; ADCFM=0 Left justified, ADCS=FOSC/2, ADPREF=Vdd
ADACT_INI	equ b'00000000' ; disable triger
	
PIE0_INI	equ 0x00	; Enable TMR0 interrupt.
PIE1_INI	equ 0x00	; none used
PIE2_INI	equ 0x00	; Enabling CMP1 interrupt.
PIE3_INI	equ 0x00	; enable receive interrupt
PIE4_INI	equ 0x02	; Enabling TMR2 interrupt.
PIE5_INI	equ 0x00	; none used
PIE6_INI	equ 0x00	; none used
PIE7_INI	equ 0x00	; none used

INTC_INI	equ 0xC0	; GIE enable, PIE enable

; --- Pin assignement

; --- Port A
; RA0
; RA1
; RA2	Charlieplax bit 7
; RA3=MCLR	Procesor rset
; RA4	LED 8
; RA5	ADC trimer

; --- Port C
; RC0	Charlieplax bit 1
; RC1	Charlieplax bit 2
; RC2	Charlieplax bit 3
; RC3	Charlieplax bit 4
; RC4	Charlieplax bit 5
; RC5	Charlieplax bit 6


; --- EEPROM Section
;  here is no EEPROM, we have to use storage area flash (SAF)
;  SAF is defined as Last Program Memory Address - 7Fh
;  0x07FF - 0x7F = 0x780
;  Row Erase (words) = 32, then one row is dedicated to address and 2nd to random
;  RTLW k = 11 0100 kkkk kkkk (0x 34 kk)

#define		SAF1_INI	0x00780

; ----- Variables

; --- Internal RAM Section

; --- Top on all banks
	cblock RAMINT
NXT_PORTA	; Data for next port character
NXT_PORTC	; Data for next port character
NXT_TRIS	; Data for next tristate character
FLAGS		; various flags

	endc

; --- Bank 0

	cblock RAMINI0
BIT_CNT		; Counter of bits (pixels)
BYTE_CNT	; Counter of bytes
BITE_CNT	; Counter of bytes

;MSCNT		; Counter of miliseconds (decreased every 1ms)

MSB		; pointer to characters H
LSB		; pointer to characters L
STEPS		; number of steps left

FCOUNT		; Frame counter
COUNT		; universal counter

SCRINI:0	; First screen buffer location
SCR0  		; Screen buffer - row 1
SCR1  		; Screen buffer - row 2
SCR2  		; Screen buffer - row 3
SCR3  		; Screen buffer - row 4
SCR4  		; Screen buffer - row 5
SCR5 		; Screen buffer - row 6
;STATEND		; Last screen buffer location

	endc

; --- Bank 1


;----- Flags

#define		N_STEP	FLAGS,0		; Time for next frame

; --------------- Program Section --------------------------------------


		org	0x000

PowerUp:
	clrf	INTCON			; Disable all interrupts
	clrf	PCLATH			; Tables on page 0
	;clrf	STATUS			; reset flags
	goto	INIT


; ----- ISR (Interrupt Service Routines)

		org	0x004

Interrupt:
	BANKSEL	PIR4
	bcf	PIR4,TMR2IF	; open int for timer2
	BANKSEL	LATC
	clrf	LATC		; off all leds
	bcf		LATA,2
	comf	NXT_TRIS,w	; prepare tri state
	movwf	TRISC		; upload tri state
	btfss	NXT_TRIS,6
	bsf		TRISA,2
	btfsc	NXT_TRIS,6
	bcf		TRISA,2
	movf	NXT_PORTC,w	; prepare port data
	movwf	LATC		; upload portC data
	movf	NXT_PORTA,w	; prepare port data
	movwf	LATA		; upload portA data

	incf	BIT_CNT,f	; next bit
	incf	BIT_CNT,w	; check for xxxx x111
	andlw	0x07
	btfsc	STATUS,Z
	incf	BIT_CNT,f	; skip, if xxxx x111
	
	movlw	0x30		; last bit is 48d=30h
	xorwf	BIT_CNT,w	; last bit
	btfsc	STATUS,Z
	clrf	BIT_CNT		; clear counter

	;movf	BIT_CNT,w
	;xorlw	0x2E
	;btfss	STATUS,Z
	;goto	IntNoNewFrame

	decfsz	FCOUNT,f
	goto	IntNoNewFrame
	bsf		N_STEP

IntNoNewFrame:
	movf	BIT_CNT,w
	call	BitConvert
	movwf	NXT_PORTC
	movf	BIT_CNT,w
	call	TrisConvert
	movwf	NXT_TRIS

	rlf		BIT_CNT,w	; BIT_CNT=xxAAADDD (AAA = byte DDD = bit in bite)
	andlw	0x70		; 0AAA0000
	movwf	FSR0L
	clrf	FSR0H
	swapf	FSR0L,w		; 00000AAA
	addlw	SCRINI		; + first addr of buffer
	movwf	FSR0L		; into FSR
	movf	BIT_CNT,w
	call	BitConvert	; bit position of DDD
	andwf	INDF0,w		; check if is 0 or 1
	btfsc	STATUS,Z	; if zero = dark
	clrf	NXT_PORTC	; disable leds
	clrf	NXT_PORTA
	btfsc	NXT_PORTC,6
	bsf		NXT_PORTA,2
	btfsc	INDF0,7
	bsf		NXT_PORTA,4

EndInt:
		retfie



; ----- Tables on first 256 bytes

BitConvert:				; also for conversion of portb mask
		andlw	0x07
		;addwf	PCL,f		; Convert bit position to byte mask
		brw
		retlw	0x01
		retlw	0x02
		retlw	0x04
		retlw	0x08
		retlw	0x10
		retlw	0x20
		retlw	0x40
		retlw	0x80


TrisConvert:
		andlw	0x3F
		;addwf	PCL,f		; Convert position to tris mask
		brw
		retlw 0x03	;L1.1
		retlw 0x03	;L1.2
		retlw 0x05	;L1.3
		retlw 0x09	;L1.4
		retlw 0x11	;L1.5
		retlw 0x21	;L1.6
		retlw 0x41	;L1.7
		retlw 0x81	;----
		retlw 0x05	;L2.1
		retlw 0x06	;L2.2
		retlw 0x06	;L2.3
		retlw 0x0A	;L2.4
		retlw 0x12	;L2.5
		retlw 0x22	;L2.6
		retlw 0x42	;L2.7
		retlw 0x82	;----
		retlw 0x09	;L3.1
		retlw 0x0A	;L3.2
		retlw 0x0C	;L3.3
		retlw 0x0C	;L3.4
		retlw 0x14	;L3.5
		retlw 0x24	;L3.6
		retlw 0x44	;L3.7
		retlw 0x84	;----
		retlw 0x11	;L4.1
		retlw 0x12	;L4.2
		retlw 0x14	;L4.3
		retlw 0x18	;L4.4
		retlw 0x18	;L4.5
		retlw 0x28	;L4.6
		retlw 0x48	;L4.7
		retlw 0x88	;----
		retlw 0x21	;L5.1
		retlw 0x22	;L5.2
		retlw 0x24	;L5.3
		retlw 0x28	;L5.4
		retlw 0x30	;L5.5
		retlw 0x30	;L5.6
		retlw 0x50	;L5.7
		retlw 0x90	;----
		retlw 0x41	;L6.1
		retlw 0x42	;L6.2
		retlw 0x44	;L6.3
		retlw 0x48	;L6.4
		retlw 0x50	;L6.5
		retlw 0x60	;L6.6
		retlw 0x60	;L6.7
		retlw 0xA0	;----


	if ($ > d'255') 
		ERROR "  Tables exceded page 0.   If it works, why do you change it?   "
	endif


; ----- Initialization

INIT:

	BANKSEL	PORTA		; BANK 0
	movlw	LATA_INI	; all outputs to zero (only RA2 is out)
	movwf	LATA
	movlw	LATC_INI	; all outputs to zero (only RC5,RC4,RC3)
	movwf	LATC

	movlw	TRISA_INI	; RA2 is output, RA3 is MCLR
	movwf	TRISA
	movlw	TRISC_INI	; RC0=CMP0out, RC1=eusart.Rx, RC2=cfg button, RC3-5=LEDs
	movwf	TRISC

	; PMD = PERIPHERAL MODULE DISABLE
	BANKSEL	PMD0		; BANK 15
	movlw	PMD0_INI	; CLKRMD CLKR enabled; SYSCMD SYSCLK enabled; FVRMD FVR disabled; IOCMD IOC enabled; NVMMD NVM enabled; 
	movwf	PMD0
	movlw	PMD1_INI	; TMR0MD TMR0 enabled; TMR1MD TMR1 enabled; TMR2MD TMR2 enabled; NCOMD DDS(NCO) enabled; 
	movwf	PMD1
	movlw	PMD2_INI	; ZCDMD ZCD disabled; CMP1MD CMP1 enabled; ADCMD ADC disabled; CMP2MD CMP2 disabled; DAC1MD DAC1 disabled; 
	movwf	PMD2
	movlw	PMD3_INI	; CCP2MD CCP2 disabled; CCP1MD CCP1 disabled; PWM4MD PWM4 disabled; PWM3MD PWM3 disabled; PWM6MD PWM6 disabled; PWM5MD PWM5 disabled; 
	movwf	PMD3
	movlw	PMD4_INI	; CWG1MD CWG1 disabled; MSSP1MD MSSP1 disabled; UART1MD EUSART enabled; 
	movwf	PMD4
	movlw	PMD5_INI	; CLC3MD CLC3 disabled; CLC4MD CLC4 disabled; CLC1MD CLC1 disabled; CLC2MD CLC2 disabled; 
	movwf	PMD5

; PIN manager
	BANKSEL	ANSELA		; BANK 62

	movlw	ANSELA_INI	; RA0 and RA1 to analog = comparator inuts
	movwf	ANSELA
	movlw	ANSELC_INI	; all digital
	movwf	ANSELC

	movlw	WPUA_INI	; disable WPU
	movwf	WPUA
	movlw	WPUC_INI	; disable WPU
	movwf	WPUC
	movlw	ODCONA_INI	; disable open drain outputs
	movwf	ODCONA
	movlw	ODCONC_INI	; disable open drain outputs
	movwf	ODCONC
	;movlw	RC0PPS_INI	; RC0->CMP1:C1OUT;
	;movwf	RC0PPS
	;movlw	RC4PPS_INI	; RC4->GPIO;
	;movwf	RC4PPS
	;BANKSEL	RX1DTPPS	; BANK 61
	;movlw	RX1DTPPS_INI	; RC1->EUSART1:RX1;
	;movwf	RX1DTPPS

; oscilator management
	BANKSEL	OSCCON1		; BANK 17
	movlw	OSCCON1_INI	; NOSC HFINTOSC; NDIV 4; 
	movwf	OSCCON1
		;OSCCON2 is read only
	movlw	OSCCON3_INI	; CSWHOLD may proceed; 
	movwf	OSCCON3
	movlw	OSCEN_INI	; MFOEN disabled; LFOEN disabled; ADOEN disabled; EXTOEN disabled; HFOEN disabled; 
	movwf	OSCEN
	movlw	OSCFRQ_INI	; HFFRQ 8_MHz; 
	movwf	OSCFRQ
	movlw	OSCSTAT_INI	; MFOR not ready; do not understand, it is read only
	movwf	OSCSTAT
	movlw	OSCTUNE_INI	; HFTUN 32; do not understand why MCC set this?
	movwf	OSCTUNE

; Comparator CM1 management
	;BANKSEL	CM1CON0		; BANK 19
	;movlw	CM1CON0_INI	; C1HYS disabled; C1EN enabled; C1POL not inverted; C1SYNC asynchronous;
	;movwf	CM1CON0
	;movlw	CM1CON1_INI	; C1INTN intFlag_neg; C1INTP intFlag_pos; interrupt on change, both edges
	;movwf	CM1CON1
	;movlw	CM1NCH_INI	; NCH CIN0- (RA0)
	;movwf	CM1NCH
	;movlw	CM1PCH_INI	; PCH C1IN0+ (RA1)
	;movwf	CM1PCH
	;movlw	CM2CON0_INI	; C2HYS disabled; C2EN disabled; C2POL not inverted; C2SYNC asynchronous;
	;movwf	CM2CON0

; Timer2 management
	BANKSEL	TMR2		; BANK 5
	movlw	T2CLKCON_INI	; T2CS FOSC/4; 
	movwf	T2CLKCON
	movlw	T2HLT_INI	; T2PSYNC Not Synchronized; T2MODE Software control; T2CKPOL Rising Edge; T2CKSYNC Not Synchronized; 
	movwf	T2HLT
	movlw	T2RST_INI	; T2RSEL T2INPPS pin; 
	movwf	T2RST
	movlw	T2PR_INI	; T2PR 59 (0.3B); 
	movwf	T2PR
		;T2TMR = 0x00; TMR2 0; 
	movlw	T2CON_INI	; T2CKPS 1:2; T2OUTPS 1:1; TMR2ON on; 
	movwf	T2CON

; Timer1 management
	;BANKSEL	TMR1L		; BANK 4
	;movlw	T1GCON_INI	; T1GE disabled; T1GTM disabled; T1GPOL low; T1GGO done; T1GSPM disabled; 
	;movwf	T1GCON
	;movlw	T1GATE_INI	; GSS T1G_pin; 
	;movwf	T1GATE
	;movlw	T1CLK_INI	; ClockSelect FOSC/4; 
	;movwf	T1CLK
		;TMR1H = 0x00;    //TMR1H 0; 
		;TMR1L = 0x00;    //TMR1L 0; 
	;movlw	T1CON_INI	; CKPS 1:8; nT1SYNC do_not_synchronize; TMR1ON disabled; T1RD16 disabled; 
	;movwf	T1CON

; Timer0 management
	;BANKSEL	TMR0L		; BANK 11
	;movlw	T0CON1_INI	; T0CS FOSC/4; T0CKPS 1:16; T0ASYNC not_synchronised; 
	;movwf	T0CON1
	;movlw	T0CON0_INI	; T0OUTPS 1:1; T0EN disaabled; T016BIT 16-bit; 
	;movwf	T0CON0
	;movlw	TMR0H_INI	; in 8 bit mode the TMR0H is compared same as timer2
	;movwf	TMR0H
	;TMR0L = 0x00; TMR0L 0; 

; EUSART management
	;BANKSEL	BAUD1CON	; BANK 2
	;movlw	BAUD1CON_INI	; ABDOVF no_overflow; SCKP Non-Inverted; BRG16 16bit_generator; WUE disabled; ABDEN disabled; 
	;movwf	BAUD1CON
	;movlw	RC1STA_INI	; SPEN enabled; RX9 8-bit; CREN enabled; ADDEN disabled; SREN disabled; 
	;movwf	RC1STA
	;movlw	TX1STA_INI	; TX9 8-bit; TX9D 0; SENDB sync_break_complete; TXEN disabled; SYNC asynchronous; BRGH hi_speed; CSRC slave; 
	;movwf	TX1STA
	;movlw	SP1BRGL_INI	; SP1BRGL 29; 
	;movwf	SP1BRGL
	;movlw	SP1BRGH_INI	; SP1BRGH 0; 
	;movwf	SP1BRGH

; Analog to digital

	BANKSEL	ADCON0	; BANK 1
	movlw	ADCCON1_INI	; ADCFM=0 Left justified, ADCS=FOSC/2, ADPREF=Vdd
	movwf	ADCON1
	movlw	ADCCON0_INI	; ADC enabled, ADC input RA5
	movwf	ADCON0
	movlw	ADACT_INI	; disable trigger
	movwf	ADACT
	DNOP
	DNOP
	bsf	ADCON0,GOnDONE	; Start conversion

; Interrupts
	BANKSEL	PIE0	; BANK 2
	movlw	PIE0_INI	; Enable TMR0 interrupt set TMR0IE = 1.
	movwf	PIE0
	movlw	PIE1_INI	; none used
	movwf	PIE1
	movlw	PIE2_INI	; Enabling CMP1 interrupt.
	movwf	PIE2
	movlw	PIE3_INI	; enable receive interrupt
	movwf	PIE3
	movlw	PIE4_INI	; Enabling TMR2 interrupt.
	movwf	PIE4
	movlw	PIE5_INI	; none used
	movwf	PIE5
	movlw	PIE6_INI	; none used
	movwf	PIE6
	movlw	PIE7_INI	; none used
	movwf	PIE7


	movlb	0	; BANK 0
	movlw	RAMINI0			; Clear variables bank0
	movwf	FSR0L
	clrf	FSR0H
ClearRAM:
	clrf	INDF0
	incf	FSR0L,f
	btfss	FSR0L,7			; to address 7F
	goto	ClearRAM

	BANKSEL	PIR0
	;clrf	PIR0
	;clrf	PIR2
	;clrf	PIR3
	clrf	PIR4
	movlw	INTC_INI			; GIE enable, PEIE enable
	movwf	INTCON

	movlb	0	; BANK 0
	movlw	HIGH(HeloWorld)
	movwf	FSR1H
	movlw	LOW(HeloWorld)
	movwf	FSR1L
	movlw	1
	movwf	FCOUNT
	
	BANKSEL	T2CON	; BANK 5
	bsf	T2CON,T2ON	; Enable TMR2 interrupt set TMR2IE = 1.

	movlb	0	; BANK 0
	
; --- Main Loop


MainLoop:

	btfss	N_STEP
	goto	MainLoop

	bcf	N_STEP
	BANKSEL	ADRESH
	incf	ADRESH,w
	bsf		ADCON0,GOnDONE	; Start conversion
	movlb	0	; BANK 0
	movwf	FCOUNT

	moviw	FSR1++
	movwf	SCR0
	moviw	FSR1++
	movwf	SCR1
	moviw	FSR1++
	movwf	SCR2
	moviw	FSR1++
	movwf	SCR3
	moviw	FSR1++
	movwf	SCR4
	movf	INDF1,w
	movwf	SCR5
	moviw	FSR1--	; 4
	moviw	FSR1--	; 3
	moviw	FSR1--	; 2
	moviw	FSR1--	; 1

	movlw	HIGH(EndHW)
	xorwf	FSR1H,w
	btfss	STATUS,Z
	goto	MainLoop
	movlw	LOW(EndHW)
	xorwf	FSR1L,w
	btfss	STATUS,Z
	goto	MainLoop
	
	movlw	HIGH(HeloWorld)
	movwf	FSR1H
	movlw	LOW(HeloWorld)
	movwf	FSR1L
	goto	MainLoop

	
HeloWorld:
	retlw b'00000000' ;48
	retlw b'00000000' ;49
	retlw b'00000000' ;50
	retlw b'00000000' ;51
	retlw b'00000000' ;52
	retlw b'00000000' ;53
	retlw b'10000000' ;1
	retlw b'11000000' ;2
	retlw b'11100000' ;3
	retlw b'11110000' ;4
	retlw b'11111000' ;5
	retlw b'11111100' ;6
	retlw b'11111110' ;7
	retlw b'11111111' ;8
	retlw b'11111111' ;9
	retlw b'10111111' ;10
	retlw b'10011111' ;11
	retlw b'10001111' ;11
	retlw b'10000111' ;12
	retlw b'10000011' ;13
	retlw b'10000001' ;14
	retlw b'10000000' ;1
	retlw b'11000000' ;2
	retlw b'11100000' ;3
	retlw b'11110000' ;4
	retlw b'11111000' ;5
	retlw b'11111100' ;6
	retlw b'11111110' ;7
	retlw b'11111111' ;8
	retlw b'11111111' ;9
	retlw b'10111111' ;10
	retlw b'10011111' ;11
	retlw b'10001111' ;11
	retlw b'11000111' ;12
	retlw b'10100011' ;13
	retlw b'10010001' ;14
	retlw b'10001000' ;12
	retlw b'11000100' ;15
	retlw b'10100010' ;13
	retlw b'10010001' ;14
	retlw b'10001000' ;12
	retlw b'11000100' ;15
	retlw b'10100010' ;13
	retlw b'10010001' ;14
	retlw b'10001000' ;12
	retlw b'11000100' ;15
	retlw b'10100010' ;13
	retlw b'10010001' ;14
	retlw b'10001000' ;12
	retlw b'11000100' ;15
	retlw b'10100010' ;13
	retlw b'10010001' ;14
	retlw b'10001000' ;12
	retlw b'11000100' ;15
	retlw b'10100010' ;13
	retlw b'10010001' ;14
	retlw b'10001000' ;12
	retlw b'11000100' ;15
	retlw b'11100010' ;13
	retlw b'11110001' ;14
	retlw b'11111000' ;5
	retlw b'11111100' ;6
	retlw b'11111110' ;7
	retlw b'11111111' ;8
	retlw b'11111111' ;9
	retlw b'00111111' ;10
	retlw b'00011111' ;11
	retlw b'00001111' ;11
	retlw b'00000111' ;12
	retlw b'00000011' ;13
	retlw b'00000001' ;14
	retlw b'00000000' ;48
	retlw b'00000000' ;49
	retlw b'11111111' ;49
	retlw b'00000000' ;50
	retlw b'00000000' ;51
	retlw b'00000000' ;52
	retlw b'00000000' ;53
	retlw b'00000000' ;53
	retlw b'11111111' ;49
	retlw b'00000000' ;50
	retlw b'00000000' ;51
	retlw b'00000000' ;52
	retlw b'00000000' ;53
	retlw b'00000000' ;53
	retlw b'11111111' ;49
	retlw b'00000000' ;50
	retlw b'00000000' ;51
	retlw b'00000000' ;52
	retlw b'00000000' ;53
	retlw b'00000000' ;53
	retlw b'11111111' ;49
	retlw b'00000000' ;50
	retlw b'00000000' ;51
	retlw b'00000000' ;52
	retlw b'00000000' ;53
	retlw b'00000000' ;53
	retlw b'11111111' ;49
	retlw b'00000000' ;50
	retlw b'00000000' ;51
	retlw b'00000000' ;52
	retlw b'00000000' ;53
	retlw b'00000000' ;53
	retlw b'11111111' ;49
	retlw b'11111111' ;49
	retlw b'11111111' ;49
	retlw b'11111111' ;49
	retlw b'11111111' ;49
	retlw b'11111111' ;49
EndHW:
	retlw b'00000000' ;48
	retlw b'00000000' ;49
	retlw b'00000000' ;50
	retlw b'00000000' ;51
	retlw b'00000000' ;52
	retlw b'00000000' ;53

	end


