/******************************************************************
  John F. Porter
  Soft latch power switch.
  NOTE: This code may not be complete, and may need to be modified 
        for your application.  No warrany is implied.
  DATE: 07/24/2013
*******************************************************************/

// Define sounds as notes
#define NOTE_C5  523
#define NOTE_D5  587
#define NOTE_E5  659
#define NOTE_F5  698
#define NOTE_G5  784
#define NOTE_A5  880
#define NOTE_B5  988

// Define system sound
#define sysSound NOTE_C5                 // System sound (button press, power down)

// Pin numbers assignments - Note: these can be changed to match your application.
const int spPin = 11;                    // Speaker pin
const int pwrLedI = 13;                  // Power indicator (on board LED)
const int softLatch = 19;                // Soft latch power   - A0
const int pwrSwitch = 0;                 // Power switch input - D0

// Shutdown timer
const int shutdownTime = 300;            // Tenths of a second - currently set for 30 seconds
unsigned int shutdownTimer = 0;

// Setup the IO pins
void setup(){ 
  // Apply soft latch power
  pinMode(softLatch, OUTPUT);
  digitalWrite(softLatch, HIGH);
  
  // Set power switch as input
  pinMode(pwrSwitch, INPUT);

  // Setup speaker
  pinMode(spPin, OUTPUT);
}

// Main loop
void loop(){
 
  // Monitor for power switch pressed (input goes low)
  if(digitalRead(pwrSwitch) == LOW){
    digitalWrite(pwrLedI, LOW);      // Turn off power LED to indicate input (turned back on later)
    tone(spPin, sysSound,100);       // Play a short tone to indicate input
    delay(100);                      // Delay for switch debounce
    buttonPressed();                 // Button has been pressed, monitor it and react accordingly
    shutdownTimer = 0;               // Reset the auto-shutdown timer (since an input was received)
    digitalWrite(pwrLedI, HIGH);     // Turn the power LED indicator back on
  }
  
  // Monitor for auto-shutdown
  shutdownTimer++;
  if(shutdownTimer > shutdownTime){
    tone(spPin, sysSound,1000);       // Play a long tone before auto shutdown
    delay(1000);
    digitalWrite(softLatch, LOW);     // Power off the soft latch output, system powers down.
  }
  
  // System delay
  delay(50);
}

// Button has been pressed, need to monitor it.
// If button is held down, system will power off.
// If released within 2 seconds, remaining code will be run.
void buttonPressed(){
  int i = 0;
  
  // Power down if held 2 seconds
  while(digitalRead(pwrSwitch) == LOW){
    delay(50);
    i++;
    if(i == 40){
      tone(spPin, sysSound,1000);
      digitalWrite(softLatch, LOW);
    }
  }
  
  // INSERT CODE HERE FOR WHEN SWITCH IS ONLY MOMENTARILY PRESSED AND RELEASED
  
}
