/******************************************/
/* Zegar Cieni v1.8                       */
/* 3 x 60 LEDs (Charlieplexing 3 x 9 pin) */
/* www.protonik.pl                        */
/* Sebastian Wac, 2014                    */
/******************************************/

#include <Time.h>
#include <DS1307RTC.h>
#include <Wire.h>

#define DS1307_ADDRESS 0x68

#define Asek 24  //ustawia wyjście 24 na płytce Arduino jako linię A wskazówki sekund  (Patrz rysunek 2)
#define Bsek 25
#define Csek 26
#define Dsek 27
#define Esek 28
#define Fsek 29
#define Gsek 30
#define Hsek 31
#define Isek 32

#define Amin 34
#define Bmin 35
#define Cmin 36
#define Dmin 37
#define Emin 38
#define Fmin 39
#define Gmin 40
#define Hmin 41
#define Imin 42

#define Agodz 44
#define Bgodz 45
#define Cgodz 46
#define Dgodz 47
#define Egodz 48
#define Fgodz 49
#define Ggodz 50
#define Hgodz 51 
#define Igodz 52

#define PIN_CONFIG 0
#define PIN_STATE 1
#define LED_COUNT 60

byte zero = 0x00;
const int buttonPin = 22; //ustawia wyjście 22 dla przycisku ustawiania czasu
int buttonState = 0;
int pr = 0; //licznik przyspieszenia ustawiania czasu

int matrix[LED_COUNT][2][9] = {
  //                             PIN_CONFIG                                                 PIN_STATE
  //    A       B       C      D      E      F      G      H     I         A     B    C    D    E    F    G    H    I         Piny|Nr diody

  { { INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT}, { LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW } }, // DH  31 (ustawia +5V na linii D i masę na linii H, zapalając diodę LED31)
  { { INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT}, { LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW } }, // DI  32

  { { OUTPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW } }, // EA  33
  { { INPUT, OUTPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW } }, // EB  34
  { { INPUT, INPUT, OUTPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW } }, // EC  35
  { { INPUT, INPUT, INPUT, OUTPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW } }, // ED  36
  { { INPUT, INPUT, INPUT, INPUT, OUTPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW } }, // EF  37
  { { INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW } }, // EG  38
  { { INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, OUTPUT, INPUT}, { LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW } }, // EH  39
  { { INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, OUTPUT}, { LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW } }, // EI  40

  { { OUTPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW } }, // FA  41
  { { INPUT, OUTPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW } }, // FB  42
  { { INPUT, INPUT, OUTPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW } }, // FC  43
  { { INPUT, INPUT, INPUT, OUTPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW } }, // FD  44
  { { INPUT, INPUT, INPUT, INPUT, OUTPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW } }, // FE  45
  { { INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW } }, // FG  46
  { { INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, OUTPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW } }, // FH  47
  { { INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, OUTPUT}, { LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW, LOW } }, // FI  48

  { { OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW } }, // GA  49
  { { INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW } }, // GB  50
  { { INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW } }, // GC  51
  { { INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW } }, // GD  52
  { { INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW } }, // GE  53
  { { INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW } }, // GF  54
  { { INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, OUTPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW } }, // GH  55
  { { INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, OUTPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW, LOW } }, // GI  56

  { { OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW } }, // HA  57
  { { INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW } }, // HB  58
  { { INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW } }, // HC  59
  { { INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT}, { LOW, LOW, LOW, LOW, LOW, LOW, LOW, HIGH, LOW } }, // HD  60
  
  { { OUTPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // AB  01
  { { OUTPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // AC  02
  { { OUTPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // AD  03
  { { OUTPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT}, { HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // AE  04
  { { OUTPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT}, { HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // AF  05
  { { OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT}, { HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // AG  06
  { { OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT}, { HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // AH  07
  { { OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT}, { HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // AI  08

  { { OUTPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // BA  09
  { { INPUT, OUTPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // BC  10
  { { INPUT, OUTPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // BD  11
  { { INPUT, OUTPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // BE  12
  { { INPUT, OUTPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // BF  13
  { { INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // BG  14
  { { INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT}, { LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // BH  15
  { { INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT}, { LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW, LOW } }, // BI  16

  { { OUTPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW } }, // CA  17
  { { INPUT, OUTPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW } }, // CB  18
  { { INPUT, INPUT, OUTPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW } }, // CD  19
  { { INPUT, INPUT, OUTPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW } }, // CE  20
  { { INPUT, INPUT, OUTPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW } }, // CF  21
  { { INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW } }, // CG  22
  { { INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT, INPUT}, { LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW } }, // CH  23
  { { INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT, OUTPUT}, { LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW, LOW } }, // CI  24

  { { OUTPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW } }, // DA  25
  { { INPUT, OUTPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW } }, // DB  26
  { { INPUT, INPUT, OUTPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW } }, // DC  27
  { { INPUT, INPUT, INPUT, OUTPUT, OUTPUT, INPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW } }, // DE  28
  { { INPUT, INPUT, INPUT, OUTPUT, INPUT, OUTPUT, INPUT, INPUT, INPUT}, { LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW } }, // DF  29
  { { INPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT, OUTPUT, INPUT, INPUT}, { LOW, LOW, LOW, HIGH, LOW, LOW, LOW, LOW, LOW } }, // DG  30
  //    A       B       C      D      E      F      G      H     I         A     B    C    D    E    F    G    H    I
  //                             PIN_CONFIG                                                 PIN_STATE
};

void turnOnsek( int led ) {
  pinMode( Asek, matrix[led][PIN_CONFIG][0] );
  pinMode( Bsek, matrix[led][PIN_CONFIG][1] );
  pinMode( Csek, matrix[led][PIN_CONFIG][2] );
  pinMode( Dsek, matrix[led][PIN_CONFIG][3] );
  pinMode( Esek, matrix[led][PIN_CONFIG][4] );
  pinMode( Fsek, matrix[led][PIN_CONFIG][5] );
  pinMode( Gsek, matrix[led][PIN_CONFIG][6] );
  pinMode( Hsek, matrix[led][PIN_CONFIG][7] );
  pinMode( Isek, matrix[led][PIN_CONFIG][8] );
  digitalWrite( Asek, matrix[led][PIN_STATE][0] );
  digitalWrite( Bsek, matrix[led][PIN_STATE][1] );
  digitalWrite( Csek, matrix[led][PIN_STATE][2] );
  digitalWrite( Dsek, matrix[led][PIN_STATE][3] );
  digitalWrite( Esek, matrix[led][PIN_STATE][4] );
  digitalWrite( Fsek, matrix[led][PIN_STATE][5] );
  digitalWrite( Gsek, matrix[led][PIN_STATE][6] );
  digitalWrite( Hsek, matrix[led][PIN_STATE][7] );
  digitalWrite( Isek, matrix[led][PIN_STATE][8] );
}

void turnOnmin (int ledm) {
  pinMode( Amin, matrix[ledm][PIN_CONFIG][0] );
  pinMode( Bmin, matrix[ledm][PIN_CONFIG][1] );
  pinMode( Cmin, matrix[ledm][PIN_CONFIG][2] );
  pinMode( Dmin, matrix[ledm][PIN_CONFIG][3] );
  pinMode( Emin, matrix[ledm][PIN_CONFIG][4] );
  pinMode( Fmin, matrix[ledm][PIN_CONFIG][5] );
  pinMode( Gmin, matrix[ledm][PIN_CONFIG][6] );
  pinMode( Hmin, matrix[ledm][PIN_CONFIG][7] );
  pinMode( Imin, matrix[ledm][PIN_CONFIG][8] );
  digitalWrite( Amin, matrix[ledm][PIN_STATE][0] );
  digitalWrite( Bmin, matrix[ledm][PIN_STATE][1] );
  digitalWrite( Cmin, matrix[ledm][PIN_STATE][2] );
  digitalWrite( Dmin, matrix[ledm][PIN_STATE][3] );
  digitalWrite( Emin, matrix[ledm][PIN_STATE][4] );
  digitalWrite( Fmin, matrix[ledm][PIN_STATE][5] );
  digitalWrite( Gmin, matrix[ledm][PIN_STATE][6] );
  digitalWrite( Hmin, matrix[ledm][PIN_STATE][7] );
  digitalWrite( Imin, matrix[ledm][PIN_STATE][8] );
}

void turnOngodz (int ledg) {
  pinMode( Agodz, matrix[ledg][PIN_CONFIG][0] );
  pinMode( Bgodz, matrix[ledg][PIN_CONFIG][1] );
  pinMode( Cgodz, matrix[ledg][PIN_CONFIG][2] );
  pinMode( Dgodz, matrix[ledg][PIN_CONFIG][3] );
  pinMode( Egodz, matrix[ledg][PIN_CONFIG][4] );
  pinMode( Fgodz, matrix[ledg][PIN_CONFIG][5] );
  pinMode( Ggodz, matrix[ledg][PIN_CONFIG][6] );
  pinMode( Hgodz, matrix[ledg][PIN_CONFIG][7] );
  pinMode( Igodz, matrix[ledg][PIN_CONFIG][8] );
  digitalWrite( Agodz, matrix[ledg][PIN_STATE][0] );
  digitalWrite( Bgodz, matrix[ledg][PIN_STATE][1] );
  digitalWrite( Cgodz, matrix[ledg][PIN_STATE][2] );
  digitalWrite( Dgodz, matrix[ledg][PIN_STATE][3] );
  digitalWrite( Egodz, matrix[ledg][PIN_STATE][4] );
  digitalWrite( Fgodz, matrix[ledg][PIN_STATE][5] );
  digitalWrite( Ggodz, matrix[ledg][PIN_STATE][6] );
  digitalWrite( Hgodz, matrix[ledg][PIN_STATE][7] );
  digitalWrite( Igodz, matrix[ledg][PIN_STATE][8] );
}

void setup() {
  pinMode(buttonPin, INPUT);
  Wire.begin();
  Serial.begin(9600);
  while (!Serial) ;
  delay(200);
}

void settime() {
    pr = pr+1; //licznik przyspieszenia ustawiania czasu
    tmElements_t tm;
    RTC.read(tm);
    tm.Second = 0;
    tm.Minute = tm.Minute + 1;
    if (tm.Minute > 59) {tm.Minute=0; tm.Hour=tm.Hour+1;}
    if (tm.Hour > 23 ) {tm.Hour=0;}
    RTC.write(tm);
    if (pr > 0 && pr < 15) delay(500);
    if (pr > 14 && pr < 35) delay(200);
    if (pr > 34 && pr < 85) delay(120);        
    if (pr > 84 && pr < 185) delay(60);        
    if (pr > 184) delay(10);        
    displaytime();
}
void displaytime() {
      
      tmElements_t tm;
      if (RTC.read(tm)) {
      turnOnsek(tm.Second); //odczytuje wartość minuty z modułu RTC i włącza jedną z 60 diod wskazówki sekundowej
      turnOnmin(tm.Minute); 

//korekta wyświetlania godziny
if (tm.Hour==0 && tm.Minute < 12) turnOngodz(tm.Hour);
if (tm.Hour==0 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 1);
if (tm.Hour==0 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 2);
if (tm.Hour==0 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 3);
if (tm.Hour==0 && tm.Minute > 47) turnOngodz(tm.Hour + 4);

if (tm.Hour==1 && tm.Minute < 12) turnOngodz(tm.Hour + 4);
if (tm.Hour==1 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 5);
if (tm.Hour==1 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 6);
if (tm.Hour==1 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 7);
if (tm.Hour==1 && tm.Minute > 47) turnOngodz(tm.Hour + 8);

if (tm.Hour==2 && tm.Minute < 12) turnOngodz(tm.Hour + 8);
if (tm.Hour==2 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 9);
if (tm.Hour==2 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 10);
if (tm.Hour==2 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 11);
if (tm.Hour==2 && tm.Minute > 47) turnOngodz(tm.Hour + 12);

if (tm.Hour==3 && tm.Minute < 12) turnOngodz(tm.Hour + 12);
if (tm.Hour==3 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 13);
if (tm.Hour==3 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 14);
if (tm.Hour==3 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 15);
if (tm.Hour==3 && tm.Minute > 47) turnOngodz(tm.Hour + 16);

if (tm.Hour==4 && tm.Minute < 12) turnOngodz(tm.Hour + 16);
if (tm.Hour==4 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 17);
if (tm.Hour==4 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 18);
if (tm.Hour==4 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 19);
if (tm.Hour==4 && tm.Minute > 47) turnOngodz(tm.Hour + 20);

if (tm.Hour==5 && tm.Minute < 12) turnOngodz(tm.Hour + 20);
if (tm.Hour==5 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 21);
if (tm.Hour==5 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 22);
if (tm.Hour==5 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 23);
if (tm.Hour==5 && tm.Minute > 47) turnOngodz(tm.Hour + 24);

if (tm.Hour==6 && tm.Minute < 12) turnOngodz(tm.Hour + 24);
if (tm.Hour==6 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 25);
if (tm.Hour==6 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 26);
if (tm.Hour==6 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 27);
if (tm.Hour==6 && tm.Minute > 47) turnOngodz(tm.Hour + 28);

if (tm.Hour==7 && tm.Minute < 12) turnOngodz(tm.Hour + 28);
if (tm.Hour==7 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 29);
if (tm.Hour==7 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 30);
if (tm.Hour==7 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 31);
if (tm.Hour==7 && tm.Minute > 47) turnOngodz(tm.Hour + 32);

if (tm.Hour==8 && tm.Minute < 12) turnOngodz(tm.Hour + 32);
if (tm.Hour==8 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 33);
if (tm.Hour==8 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 34);
if (tm.Hour==8 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 35);
if (tm.Hour==8 && tm.Minute > 47) turnOngodz(tm.Hour + 36);

if (tm.Hour==9 && tm.Minute < 12) turnOngodz(tm.Hour + 36);
if (tm.Hour==9 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 37);
if (tm.Hour==9 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 38);
if (tm.Hour==9 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 39);
if (tm.Hour==9 && tm.Minute > 47) turnOngodz(tm.Hour + 40);

if (tm.Hour==10 && tm.Minute < 12) turnOngodz(tm.Hour + 40);
if (tm.Hour==10 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 41);
if (tm.Hour==10 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 42);
if (tm.Hour==10 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 43);
if (tm.Hour==10 && tm.Minute > 47) turnOngodz(tm.Hour + 44);

if (tm.Hour==11 && tm.Minute < 12) turnOngodz(tm.Hour + 44);
if (tm.Hour==11 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 45);
if (tm.Hour==11 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 46);
if (tm.Hour==11 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 47);
if (tm.Hour==11 && tm.Minute > 47) turnOngodz(tm.Hour + 48);

if (tm.Hour==12 && tm.Minute < 12) turnOngodz(tm.Hour - 12);
if (tm.Hour==12 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour - 11);
if (tm.Hour==12 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour - 10);
if (tm.Hour==12 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour - 9);
if (tm.Hour==12 && tm.Minute > 47) turnOngodz(tm.Hour - 8);

if (tm.Hour==13 && tm.Minute < 12) turnOngodz(tm.Hour - 8);
if (tm.Hour==13 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour - 7);
if (tm.Hour==13 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour - 6);
if (tm.Hour==13 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour - 5);
if (tm.Hour==13 && tm.Minute > 47) turnOngodz(tm.Hour - 4);

if (tm.Hour==14 && tm.Minute < 12) turnOngodz(tm.Hour - 4);
if (tm.Hour==14 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour - 3);
if (tm.Hour==14 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour - 2);
if (tm.Hour==14 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour - 1);
if (tm.Hour==14 && tm.Minute > 47) turnOngodz(tm.Hour);

if (tm.Hour==15 && tm.Minute < 12) turnOngodz(tm.Hour);
if (tm.Hour==15 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 1);
if (tm.Hour==15 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 2);
if (tm.Hour==15 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 3);
if (tm.Hour==15 && tm.Minute > 47) turnOngodz(tm.Hour + 4);

if (tm.Hour==16 && tm.Minute < 12) turnOngodz(tm.Hour + 4);
if (tm.Hour==16 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 5);
if (tm.Hour==16 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 6);
if (tm.Hour==16 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 7);
if (tm.Hour==16 && tm.Minute > 47) turnOngodz(tm.Hour + 8);

if (tm.Hour==17 && tm.Minute < 12) turnOngodz(tm.Hour + 8);
if (tm.Hour==17 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 9);
if (tm.Hour==17 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 10);
if (tm.Hour==17 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 11);
if (tm.Hour==17 && tm.Minute > 47) turnOngodz(tm.Hour + 12);

if (tm.Hour==18 && tm.Minute < 12) turnOngodz(tm.Hour + 12);
if (tm.Hour==18 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 13);
if (tm.Hour==18 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 14);
if (tm.Hour==18 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 15);
if (tm.Hour==18 && tm.Minute > 47) turnOngodz(tm.Hour + 16);

if (tm.Hour==19 && tm.Minute < 12) turnOngodz(tm.Hour + 16);
if (tm.Hour==19 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 17);
if (tm.Hour==19 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 18);
if (tm.Hour==19 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 19);
if (tm.Hour==19 && tm.Minute > 47) turnOngodz(tm.Hour + 20);

if (tm.Hour==20 && tm.Minute < 12) turnOngodz(tm.Hour + 20);
if (tm.Hour==20 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 21);
if (tm.Hour==20 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 22);
if (tm.Hour==20 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 23);
if (tm.Hour==20 && tm.Minute > 47) turnOngodz(tm.Hour + 24);

if (tm.Hour==21 && tm.Minute < 12) turnOngodz(tm.Hour + 24);
if (tm.Hour==21 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 25);
if (tm.Hour==21 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 26);
if (tm.Hour==21 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 27);
if (tm.Hour==21 && tm.Minute > 47) turnOngodz(tm.Hour + 28);

if (tm.Hour==22 && tm.Minute < 12) turnOngodz(tm.Hour + 28);
if (tm.Hour==22 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 29);
if (tm.Hour==22 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 30);
if (tm.Hour==22 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 31);
if (tm.Hour==22 && tm.Minute > 47) turnOngodz(tm.Hour + 32);

if (tm.Hour==23 && tm.Minute < 12) turnOngodz(tm.Hour + 32);
if (tm.Hour==23 && tm.Minute > 11 && tm.Minute < 24) turnOngodz(tm.Hour + 33);
if (tm.Hour==23 && tm.Minute > 23 && tm.Minute < 36) turnOngodz(tm.Hour + 34);
if (tm.Hour==23 && tm.Minute > 35 && tm.Minute < 48) turnOngodz(tm.Hour + 35);
if (tm.Hour==23 && tm.Minute > 47) turnOngodz(tm.Hour + 36);

    }
}

void loop() {

  buttonState = digitalRead(buttonPin); // sprawdza czy przycisk ustawiania godziny jest wciśnięty
  if (buttonState == HIGH) {            // jeśli tak to ustawia jego stan na wysoki
    settime();
  }
  else {  // display time
    displaytime();
    pr = 0;
  }
}

