import logging, signal, subprocess, time
from RPi import GPIO
import mysql.connector as mariadb

log = logging.getLogger(__name__)

running = True

GPIO.setmode(GPIO.BCM)

TRIG = 23
ECHO = 24

GPIO.setup(TRIG, GPIO.OUT)
GPIO.setup(ECHO, GPIO.IN)

def get_temperature(slave_id):
    # open het 'w1_slave' bestand voor de sensor:
    path = "/sys/bus/w1/devices/" + slave_id + "/w1_slave"
    # haal er er de juiste regel uit:
    with open(path, 'r') as f:
        lines = [line.rstrip('\n') for line in f]

    # haal de waarde van t uit de regel:
    t = str(lines)
    t = t[74:79]
    # zet om naar int en deel door 1000 alvorens de waarde te returnen
    t = int(t)
    t = t / 1000

    return t

def get_distance():
    GPIO.output(TRIG, False)
    time.sleep(2)
    GPIO.output(TRIG, True)
    time.sleep(0.0001)
    GPIO.output(TRIG, False)

    while GPIO.input(ECHO) == 0:
        pulse_start = time.time()

    while GPIO.input(ECHO) == 1:
        pulse_end = time.time()

    pulse_duration = pulse_end - pulse_start
    distance = pulse_duration * 17150
    distance = round(distance, 2)
    return distance

def setup():
    def shutdown(*args):
        global running
        running = False
        # try:
        #     sys.exit(0)
        # except KeyError as ex:
        #     pass

    signal.signal(signal.SIGTERM, shutdown)


def loop():
    slave_id = "28-0316a1f8a0ff"
    temp = get_temperature(slave_id)
    used = "N"
    if get_distance() < 100:
        used = "Y"
    conn = mariadb.connect(database='project1', user='project1-admin', password='adminpassword')
    cursor = conn.cursor()
    cursor.execute("INSERT INTO project1.tbldata (temperature, used) VALUES (%s, %s)",(temp, used))
    conn.commit()
    time.sleep(180)

if __name__ == '__main__':
    logging.basicConfig(level=logging.DEBUG)
    try:
        setup()
        while running:
            loop()
    except KeyboardInterrupt:
        pass
