
void send_nec(void);
void set_38(void);

unsigned char ir_byte[5];
int _change = 0;

void Interrupt(){
    if (INT0IF_bit){
       INT0IF_bit = 0;
       _change =  1;
    }
    
    if (INT1IF_bit){
       INT1IF_bit = 0;
       _change =  1;
    }
    
    if (INT2IF_bit){
       INT2IF_bit = 0;
       _change =  1;
    }
    
    if (INT3IF_bit){
       INT3IF_bit = 0;
       _change =  1;
    }
    
    if (RBIF_bit){
       RBIE_bit = 0;
       PORTB;
       RBIF_bit = 0;
       _change = 1;
    }
}

void main(){
     char _dat[50];
     
     //Analog pins as digital
     ANCON0 = 0x1F;
     ANCON1 =  0x1F;
     
     PLLEN_bit = 1;
     delay_ms(150);
     
     TRISB = 255;
     LATB = 255;
     RBPU_bit = 0;
     
     TRISC6_bit = 0;
     RC6_bit = 0;
     
     TRISA0_bit = 0;
     RA0_bit = 0;
     
     delay_ms(100);
     
     INT0IF_bit = 0;
     INT0IE_bit = 1;
     INTEDG0_bit = 0;

     INT1IF_bit = 0;
     INT1IE_bit = 1;
     INTEDG1_bit = 0;
     
     INT2IF_bit = 0;
     INT2IE_bit = 1;
     INTEDG2_bit = 0;
     
     INT3IF_bit = 0;
     INT3IE_bit = 1;
     INTEDG3_bit = 0;

     RBIE_bit = 1;
     IPEN_bit = 1;
     GIE_bit = 1;
     PEIE_bit = 1;
     delay_ms(100);
     
     IDLEN_bit = 0;
     DSEN_bit = 1;
     
     delay_ms(1000);
     

     //Initialize UART2 module with Peripheral Pin Select
     Unlock_IOLOCK();
     PPS_Mapping_NoLock(0, _OUTPUT , _CCP1_P1A);
     PPS_Mapping_NoLock(4, _INPUT , _INT1);
     PPS_Mapping_NoLock(5, _INPUT , _INT2);
     PPS_Mapping_NoLock(6, _INPUT , _INT3);
     Lock_IOLOCK();
     
     PWM1_Init(38000);
     PWM1_Set_Duty(80);
     

     while(1){
          if (_change == 1){
              _change = 0;
              if (RB0_bit == 0){
                 LATC6_bit = 1;
                 ir_byte[3]=0x09;             // Backspace
                 send_nec();
                 LATC6_bit = 0;
                 delay_ms(200);
                 while(RB0_bit == 0){
                     LATC6_bit = 1;
                     ir_byte[3]=0x00;
                     send_nec();
                     LATC6_bit = 0;
                     delay_ms(5);
                 }
              }
              if (RB1_bit == 0){
                 LATC6_bit = 1;
                 ir_byte[3]=0x0A;             // Left
                 send_nec();
                 LATC6_bit = 0;
                 delay_ms(200);
                 while(RB1_bit == 0){
                     LATC6_bit = 1;
                     ir_byte[3]=0x00;
                     send_nec();
                     LATC6_bit = 0;
                     delay_ms(5);
                 }
              }
              if (RB2_bit == 0){
                 LATC6_bit = 1;
                 ir_byte[3]=0x1F;             // Context menu
                 send_nec();
                 LATC6_bit = 0;
                 delay_ms(200);
                 while(RB2_bit == 0){
                     LATC6_bit = 1;
                     ir_byte[3]=0x00;
                     send_nec();
                     LATC6_bit = 0;
                     delay_ms(5);
                 }
              }
              if (RB3_bit == 0){
                 LATC6_bit = 1;
                 ir_byte[3]=0x02;             // Down
                 send_nec();
                 LATC6_bit = 0;
                 delay_ms(200);
                 while(RB3_bit == 0){
                     LATC6_bit = 1;
                     ir_byte[3]=0x00;
                     send_nec();
                     LATC6_bit = 0;
                     delay_ms(5);
                 }
              }
              if (RB4_bit == 0){
                 LATC6_bit = 1;
                 ir_byte[3]=0x1C;             // Ok
                 send_nec();
                 LATC6_bit = 0;
                 delay_ms(200);
                 while(RB4_bit == 0){
                     LATC6_bit = 1;
                     ir_byte[3]=0x00;
                     send_nec();
                     LATC6_bit = 0;
                     delay_ms(5);
                 }
              }
              if (RB5_bit == 0){
                 LATC6_bit = 1;
                 ir_byte[3]=0x05;             // Up
                 send_nec();
                 LATC6_bit = 0;
                 delay_ms(200);
                 while(RB5_bit == 0){
                     LATC6_bit = 1;
                     ir_byte[3]=0x00;
                     send_nec();
                     LATC6_bit = 0;
                     delay_ms(5);
                 }
              }
              if (RB6_bit == 0){
                 LATC6_bit = 1;
                 ir_byte[3]=0x16;             // Mute
                 send_nec();
                 LATC6_bit = 0;
                 delay_ms(200);
                 while(RB6_bit == 0){
                     LATC6_bit = 1;
                     ir_byte[3]=0x00;
                     send_nec();
                     LATC6_bit = 0;
                     delay_ms(5);
                 }
              }
              if (RB7_bit == 0){
                 LATC6_bit = 1;
                 ir_byte[3]=0x1E;             // Right
                 send_nec();
                 LATC6_bit = 0;
                 delay_ms(200);
                 while(RB7_bit == 0){
                     LATC6_bit = 1;
                     ir_byte[3]=0x00;
                     send_nec();
                     LATC6_bit = 0;
                     delay_ms(5);
                 }
              }
              delay_ms(10);
              RBIE_bit = 1;
              RBIF_bit = 0;
          }
          asm sleep;
     }
}

void send_nec(void){
     char bitnum;
     char bytenum;

     ir_byte[4] = ~ir_byte[3];                       // byte 4 is inverse of byte 3
     Delay_ms(100);                                  // precaution to be certain of some dead time before message start
     PWM1_Start();                                   // mark
     Delay_us(9000);                                 // 9mS mark start bit
     PWM1_Stop();                                    // space
     Delay_us(4500);                                 // 4.5mS space ends start bit
     for(bytenum = 1; bytenum < 5; bytenum++){       // 4 bytes to send
         for(bitnum = 0; bitnum < 8; bitnum++){      // 8 bits LSB first
             PWM1_Start();                           // mark
             Delay_us(560);                          // 560uS mark for '0' or '1'
             PWM1_Stop();                            // space
             if(ir_byte[bytenum] & (1 << bitnum)){   // test bit <bitnum>
                 Delay_us(1680);                     // 1.68mS space for a '1'
             }
             else{
                 Delay_us(560);                      // 560uS space for a '0'
             }


         }
     }
     PWM1_Start();                                   // mark
     Delay_us(560);                                  // stop bit of '1'
     PWM1_Stop();                                    // space
     Delay_us(1680);                                 // stop bit of 1
}