#!/usr/bin/env python3

from flask import Flask,render_template,request,Response,jsonify,send_from_directory
from picamera import PiCamera
from time import time,sleep, strftime,localtime
import VL53L1X_2 as VL53L1X
import subprocess
import os
from threading import Thread
import math 
from stat import S_ISREG, ST_CTIME, ST_MODE
import RPi.GPIO as GPIO

app = Flask(__name__)
tof = VL53L1X.VL53L1X(i2c_bus=1, i2c_address=0x29)
recording=False
converting=False
camera = PiCamera()
camera.rotation=90
camera.framerate=25
camera.annotate_background = True
camera.annotate_text_size=16
camera.annotate_text = strftime('%Y-%m-%d %H:%M:%S %Z', localtime(time()))
videoName=""
distance_in_mm=0
shutdown_pin=26
led_pin=4

GPIO.setmode(GPIO.BCM)
GPIO.setwarnings(False)
GPIO.setup(led_pin,GPIO.OUT)
GPIO.output(led_pin,GPIO.HIGH)

GPIO.setup(shutdown_pin, GPIO.IN, pull_up_down=GPIO.PUD_UP)

def button_press_event(channel):
    global recording
    start_time = time()
    elapsed_time=0
    while GPIO.input(channel) == 0: # Wait for the button up
      elapsed_time=time() - start_time
      if elapsed_time>5:
        shutdown()

    if elapsed_time<0.1:
      return

    if(recording):
      stop_recording() 
    else:
      start_recording()

def shutdown():

  if(recording):
    stop_recording()
  GPIO.output(led_pin,GPIO.LOW)

  subprocess.call(['shutdown', '-h', 'now'], shell=False)

GPIO.add_event_detect(shutdown_pin, GPIO.FALLING, callback=button_press_event, bouncetime=500)


def start_recording_int():

  global tof,recording,camera,videoName,distance_in_mm,led_pin
  tof.open() # Initialise the i2c bus and configure the sensor
  tof.start_ranging(3)
  startTime=time()
  videoName='/share/video-%s'% strftime("%Y-%m-%d_%H-%M-%S", localtime(time()))
#  f=open("/share/distances-%s.csv"% strftime("%Y-%m-%d_%H-%M-%S", localtime(time()) ),"a")
  camera.start_recording("%s.h264" % (videoName))
  recording=True
  i=0
  while(recording):

    i=(i+1)%6
    if(i==0):
      GPIO.output(led_pin,GPIO.HIGH)
    if(i==3):
      GPIO.output(led_pin,GPIO.LOW)

    try:
      fl = tof.get_full_measurement()
      if(fl[1]==0):
        distance_in_mm=fl[0]
        sd=fl[2]
        secondsSinceStart=time()-startTime
        minutes=math.floor(secondsSinceStart/60)
        seconds=secondsSinceStart%60
        camera.annotate_text = '%s %.0fmm +/- %.1fmm'% (strftime("%Y-%m-%d %H:%M:%S", localtime(time())), distance_in_mm,sd)
    except Exception as e:
      print(e)

    sleep(0.1)


def start_recording():
    print ("Starting recording")
    t = Thread(target=start_recording_int)
    t.start()
    return "Processing"


def stop_recording():

  global recording, camera,videoName,converting,led_pin
  print ("Stopping recording")
  GPIO.output(led_pin,GPIO.HIGH)
  recording=False
  converting=True
  camera.stop_recording()
  try:
    tof.stop_ranging() # Stop ranging
  except:
    pass

  command = "MP4Box -add %s.h264 %s.mp4"%(videoName,videoName)
  output = subprocess.call(command,  shell=True)
  os.remove("%s.h264"%(videoName))
  converting=False


@app.route('/')
def index():
    return render_template('index.html', tree=make_tree("/share"))

@app.route('/camera/start')
def start():

  return Response(start_recording(), mimetype="text/html")


@app.route('/camera/stop')
def stop():
  stop_recording()
  return "Stopped"

@app.route('/camera/status')
def status():

  global recording,converting,distance_in_mm
  return jsonify(
        recording=recording,
        converting=converting,
        distance=distance_in_mm
  )

@app.route('/files')
def files():

        path = '/share'
        return render_template('files.html', tree=make_tree(path))
 


@app.route('/files/<path:path>')
def static_proxy(path):
  print(path)
  # send_static_file will guess the correct MIME type
  return send_from_directory('/share',path)

def make_tree(dirpath):
    tree = dict(name=os.path.basename(dirpath), children=[])

    
    entries = (os.path.join(dirpath, fn) for fn in os.listdir(dirpath))
    entries = ((os.stat(path), path) for path in entries)
    entries = ((stat[ST_CTIME], path)
           for stat, path in entries if S_ISREG(stat[ST_MODE]))

    for cdate, path in sorted(entries,reverse=True):
      tree['children'].append(dict(name=os.path.basename(path)))
    return tree


if __name__ == '__main__':
    app.run(debug=False, port=8080,host='0.0.0.0')

