#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#include <Wire.h>
#include <Adafruit_MLX90614.h>
/* 
buttons are normally low
y sets the value for repeats to reading algorythm
*/
Adafruit_MLX90614 mlx = Adafruit_MLX90614();
#define OLED_RESET 4
#define ButtonMax A3
#define ButtonMin A2
#define ButtonHold A1
Adafruit_SSD1306 display(OLED_RESET);

/////////////storage for temperature////////////////
float minTemp=0;
float maxTemp=0;
float tempx=0;
///////////////storage for button "was button pressed? flags"////////////////////
int button1 = 0; 
int button2 = 0; 
int button3 = 0; 
/////////////////////////////////variable x,y determins display refresh rate///////////////////////
int x=0;
const int y=500;
void setup() {

 display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
 //  Serial.begin(9600);

 ///////////////////////////////////////
 
   delay(10);
   mlx.begin();  
   ////////////////////////////////////to have values of meter correct since first reading/////////////////
   minTemp = mlx.readObjectTempC();
   maxTemp = mlx.readObjectTempC();
   tempx =  mlx.readObjectTempC();
   /////////////////////////////////////sets DDR register//////////////////////////
   pinMode(ButtonMax, INPUT_PULLUP);
   pinMode(ButtonMin, INPUT_PULLUP);
   pinMode(ButtonHold, INPUT_PULLUP);
}

void loop() 
{ x=0;
  while(x<y)///////////////////////to skip display refresh,thus reducing display refresh rate//////////////////////////
  {
    float temp = mlx.readObjectTempC(); // stores current temp

    
    ////////////////////////////////////////////////read button state,no debounce needed because of the nature of the problem/////////////////////
    button1 = digitalRead(ButtonHold); 
    button2 = digitalRead(ButtonMin);
    button3 = digitalRead(ButtonMax);
    ////////////////////////////////////////////////update min max///////////////////////////////
      if (temp < minTemp) 
      {
        minTemp = temp;
      }
      if (temp > maxTemp) 
      {
        maxTemp = temp;
      } 
    
      ////////////////////////////////////////////react to button press///////////////////////
          if (button1 == LOW) {
           tempx = mlx.readObjectTempC();
          }
          if (button2 == LOW) {
           minTemp = mlx.readObjectTempC();
           }
          if (button3 == LOW) {
           maxTemp = mlx.readObjectTempC();
           }


           
          x++;
          ////////////////for debugging//////////////
        // Serial.print(mlx.readObjectTempC());
   }

   ///////////////////////////////////refresh display///////////////////////////////
  display.clearDisplay();
  display.setTextSize(2);//to have current temp show in big fonts
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("IR:"); display.print(mlx.readObjectTempC());
  display.setTextSize(1); // to show all the rest in small font
  display.setCursor(0,16);
  display.write(0x19);display.print(":");display.println(minTemp); //0x19 shows downwards arrow
  display.setCursor(70,16);
  display.write(0x18);display.print(":");display.print(maxTemp); //0x18 shows upwards arrow
  display.setCursor(0,25);
  display.write(185);display.print(":");display.print(tempx);  //185 shows pause like symbol
  display.setCursor(70,25);
  display.write(246);display.print(":"); display.print(mlx.readAmbientTempC()); //246 shows "approximate symbol", a symbol I thought is suitable for ambient for 
  display.display();
 
}
