#include <DHT.h>

//This code has been written for use with the instructable
//Indoor Environmental Quality station
//http://www.instructables.com/member/donmatito/

//Every 30s, sensors are averaged over 5 measures
//with exception for sound sensors for which the max value is used
//then the values are sent through the Serial port

//Electronic Brick sound sensor in A0
int pinSonEB = A0;
int sonEB = 0;
//DFRobot sound sensor in A1
int pinSonDFR = A1;
int sonDFR = 0;
//Temperature TMP36 in A2
int pinTMP = A2;
float tempTMP = 0;
//DHT11 (temperature and humidity from Electronic Brick) on pin 3
int pinDHT = 3;
DHT dht(pinDHT, DHT11); 
float tempDHT = 0;
float humidDHT = 0;
//light sensor in tension divider with a 10 kOhm resistor, in A3 
int pinLUM = A3;
float lumin = 0;
//Air Quality sensor Seeedstudio in A4
int pinAIR = A4;
float airQUAL;

float cycles = 0.0;
float maxCycles = 5;

void setup(){  
  Serial.begin(9600);
  delay(1000); //sensor startup
  dht.begin();
}

void loop(){
  
  while (cycles < maxCycles){
  cycles += 1.0;
  
  //for sound sensors : take the max value
  analogRead(pinSonDFR);
  delay(10);
  int sonTemp1 = analogRead(pinSonDFR);  
  if (sonTemp1 > sonDFR)
    sonDFR = sonTemp1;
  
  analogRead(pinSonEB);
  delay(10);
  int sonTemp2 = analogRead(pinSonEB);
  if (sonTemp2 > sonEB)
    sonEB = sonTemp2;
  
  //for other sensors, take the average value, ie count cycles and keep adding up the measures
  analogRead(pinTMP);
  delay(10);
  float convTMP = analogRead(pinTMP)*5/1024.0; //conversion in voltage
  convTMP = (convTMP - 0.5)*100; //calibration according to datasheet
  tempTMP += convTMP * 20/18; //proportional calibration
  
  dht.readTemperature();
  delay(10);
  tempDHT += dht.readTemperature()*20/22; //proportional calibration 
  humidDHT += dht.readHumidity();
  
  analogRead(pinLUM);
  delay(10);
  int percentLum = map(analogRead(pinLUM), 0, 1023, 1, 100);
  lumin += percentLum;
  
  analogRead(pinAIR);
  delay(10);
  int percentAir = map(analogRead(pinAIR), 0, 1023, 1, 100);
  airQUAL += percentAir;
  }
  
  //after 5 times, average the measurements, send them over Serial, then reset
  tempTMP = tempTMP / cycles;
  tempDHT = tempDHT / cycles;
  humidDHT = humidDHT / cycles;
  lumin = lumin / cycles;
  airQUAL = airQUAL / cycles;
  
  sendToProcessing();
  
  //then reset all
    cycles = 0;
    sonEB = 0;
    sonDFR = 0;
    tempTMP = 0;
    tempDHT = 0;
    humidDHT = 0;
    lumin = 0;
  
  delay(30000);
}

void sendToProcessing(){
  //grammar : first the name of the field, then comma, then the value, then semicolon
  Serial.print("sonDFR,");
  Serial.print(sonDFR);
  Serial.print(";sonEB,");
  Serial.print(sonEB);
  Serial.print(";tempTMP,");
  Serial.print(tempTMP);
  Serial.print(";lumin,");
  Serial.print(lumin);
  Serial.print(";tempDHT,");
  Serial.print(tempDHT);
  Serial.print(";humidDHT,"); 
  Serial.print(humidDHT);
  Serial.print(";airQUAL,");
  Serial.println(airQUAL);
}
