package matrix.test;

import gnu.io.*;

import java.io.IOException;
import java.util.Date;

import matrix.FontLoader;
import matrix.LEDFont;
import matrix.LEDMatrix;

import java.util.Scanner;
import java.io.File;
import java.io.FileNotFoundException;

public class Test {
	static boolean[] BLANK = {false, false, false, false, false, false, false};
	//Don't space these chars
	static char[] SPECIAL = {' ', ':'};

	public static boolean isSpecial(char c) {
		for (char s : SPECIAL) if (c == s) return true;
		return false;
	}

	public static void printChar(LEDMatrix m, LEDFont f, char ch, long milliPerRow) throws IOException {
		boolean[][] val = f.getCharacter(ch);

		boolean[] col = new boolean[val.length];
		for (int i = 0; i < val[0].length; i++) {
			//Get each column
			for (int k = 0; k < col.length; k++) col[k] = val[k][i];
			m.writeColumn(col);
			try {
				Thread.sleep(milliPerRow);
			} catch (InterruptedException e) {}
		}
	}
	
	public static void printStr(LEDMatrix m, LEDFont f, String s, long milliPerRow) throws IOException {
		for (int c = 0; c < s.length(); c++) {
			char ch = s.charAt(c);
			
			printChar(m, f, ch, milliPerRow);
			
			if (ch != ' ' && c != s.length() - 1 && !isSpecial(s.charAt(c + 1))) {
				m.writeColumn(BLANK);
				try {
					Thread.sleep(milliPerRow);
				} catch (InterruptedException e) {}
			}
		}
	}
	public static void main(String[] args) throws IOException {
		System.out.println(System.getProperty("java.library.path"));

		listPorts();

		//Read the port
		Scanner s = new Scanner(Test.class.getResourceAsStream("/port.txt"));
		String port = s.nextLine();

		LEDMatrix matrix = new LEDMatrix(7, 20);
		matrix.open(port);
		
		//Wait for the arduino to boot up
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {}
		
		
		
		LEDFont font = FontLoader.s_loadFont(Test.class.getResourceAsStream("/simple-font.csv"));

		while (true) {
			Date date = new Date();
			printStr(matrix, font, "TIME: " + (date.getHours() > 12 ? date.getHours() - 12 : date.getHours()) + ":" + date.getMinutes() + "    ", 100);
		}
		//printStr(matrix, font, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG", 100);
	}

	public static void listPorts() {
        java.util.Enumeration<CommPortIdentifier> portEnum = CommPortIdentifier.getPortIdentifiers();

		System.out.println("Available ports...");
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = portEnum.nextElement();
            if(portIdentifier.getPortType() == CommPortIdentifier.PORT_SERIAL) 
				System.out.println(portIdentifier.getName()  +  " - " +  getPortTypeName(portIdentifier.getPortType()));
        }
    }
    
    static String getPortTypeName(int portType) {
        switch (portType) {
            case CommPortIdentifier.PORT_I2C:
                return "I2C";
            case CommPortIdentifier.PORT_PARALLEL:
                return "Parallel";
            case CommPortIdentifier.PORT_RAW:
                return "Raw";
            case CommPortIdentifier.PORT_RS485:
                return "RS485";
            case CommPortIdentifier.PORT_SERIAL:
                return "Serial";
            default:
                return "unknown type";
        }
    }
}
