#from pprint import pprint
"
herscheyfonts.py by John Wallin

This python script is used by the mhologram code as a utility
to read the Herschey font files.  It can be run alone
for testing.

You can edit the dots if you like
or alter the code for experimental use.   

I claim no copyright on this code.  It is heavily based
on examples on the internet.  The herschey fonts I found
also didn't claim a copyright.

I wrote this code in Python 2 - because I am a rebel.

"""

import json
import copy
import sys
import numpy as np

import matplotlib.pyplot as plt
import matplotlib.patches as patches
from matplotlib.backends.backend_pdf import PdfPages


class hersheyFonts:

  def __init__(self):
    self.readFontData()
    self.parseFontData()

    findex = 13
    self.readFontIndex(findex)


  def readFontData(self):
    self.json_file="hershey-occidental.json"
    cube='1'
    json_data=open(self.json_file)
    self.fontData = json.load(json_data)
    json_data.close()


  def parseFontData(self):
    nmax = 12000
    self.globalFontIndex = []
    for i in range(nmax):
      self.globalFontIndex.append(0)

    for i in range(len(self.fontData)):
      jj = self.fontData[i]['charcode']
      self.globalFontIndex[jj] = i

      
  def rawFontData(self, cid):
    segments = []
#      print self.fontData[cid]
    l = self.fontData[cid]['lines']
    for ll in l:
      segment = []
      for i in range(len(ll)):
        segment.append( ll[i] )
      segments.append(segment)
    return segments


  def fontSize(self, segments):
    xmin =  segments[0][0][0]
    xmax =  segments[0][0][0]
    ymin =  segments[0][0][1]
    ymax =  segments[0][0][1]
    for s in segments:
      for pt in s:
        x = pt[0]
        y = pt[1]
        if x < xmin: 
          xmin = x
        if x > xmax:
          xmax = x
        if y < ymin:
          ymin = y
        if y > ymax:
          ymax = y
    return [xmin, xmax, ymin, ymax]


  def getFontSize(self, cid):
    size = self.fontData[cid]['bbox']
    return size


  def getFontBoundary(self, cid):
    xstart = self.fontData[cid]['left']
    xend = self.fontData[cid]['right']
    return [xstart, xend]


  def scaleCharacter(self, segments, xscale, yscale):
    segmentsNew = []
    for ii in range(len(segments)):
      s = segments[ii]
      segmentNew = []
      for ipt in range(len(s)):
        pt = segments[ii][ipt]
        x = pt[0] * xscale
        y = pt[1] * yscale
        segmentNew.append( [x,y])
      segmentsNew.append(segmentNew)
    return segmentsNew


  def scaleString(self, xscale, yscale):
    for ii in range(len(self.charString)):
      s = self.charString[ii]
      segments = s[5]
      self.charString[ii][5] = self.scaleCharacter(segments, xscale, yscale)


  def scaleFontBoundary(self, bounds, scale):
    xstart = self.fontData[cid]['left']
    xend = self.fontData[cid]['right']
    return [xstart*scale, xend*scale]


  def readFontIndex(self, fid):
    self.fontList = ['cyrilc', 'gothgbt', 'gothgrt', 'gothitt',  'italicc', 'italiccs', 'italict', 'romanc', 'romancs', 'romand', 'romanp', 'romans', 'romant', 'scriptc', 'scripts', 'greekcs', 'greekc',  'greekp', 'greeks'] 

    fondDir = "font/"
    fontName = self.fontList[fid] 
    fname = fontDir + fontName + ".hmp.txt"

    self.currentFontIndex = []
    for i in range(129):
      self.currentFontIndex.append(-1)

    ii = 32
    f = open(fname, "r")
    for l in f:
      y = l.strip().split()
      if len(y) > 1:
        for k in range(len(y)):
          self.currentFontIndex[ii] = int(y[k])
          ii = ii + 1
      else:
        zz = y[0].strip().split('-')
        h1 = int(zz[0])
        h2 = int(zz[1]) +1
        ct = 1
        for k in range(h1, h2):
          self.currentFontIndex[ii] = k
          ii = ii + 1
          ct = ct + 1
    f.close()


  def showFontSet(self, fid):
    d = 1


  def formString(self, inputString):
    self.fontList = []
    for s in inputString:
      asciiValue = ord(s)
      cf = self.currentFontIndex[asciiValue]
      gf = self.globalFontIndex[cf]
      self.fontList.append([gf,cf,asciiValue, s])

    xOffset = 0
    yOffset = 0
    cWidth = 0
    deltaWidth = -0.1
    self.charString = []
    for s in self.fontList:
      
      cid = s[0]
      asciiValue = s[2]
      size = self.getFontSize(cid)
      bSize = self.getFontBoundary(cid)

      [xstart, xend ] = self.getFontBoundary(cid)
      # update using the width of the last character, and a spacing of 
      #delta * the width of the last character
      xOffset = xOffset + cWidth  
      cWidth = bSize[1] - bSize[0]            
      segments = self.rawFontData(cid)
      newSegments = self.displaceCharacter(segments, xOffset - xstart, yOffset)
      
      #ff = self.fontData[cid]['charcode']
      if asciiValue <> 32:
        self.charString.append([s, asciiValue, cf, gf, bSize, newSegments])
      

  def displaceCharacter(self, segments, dx, dy):
    newSegments = copy.deepcopy(segments)

    for i in range(len(newSegments)):
      seg = newSegments[i]
      for j in range(len(seg)):
        pt = seg[j]
        xnew = pt[0] + dx
        ynew = pt[1] + dy
        newSegments[i][j][0] = xnew
        newSegments[i][j][1] = ynew
    return newSegments


  def displaceString(self, dx, dy):
    for ii in range(len(self.charString)):
      s = self.charString[ii]
      segments = s[5]
      segments= self.displaceCharacter(segments, dx, dy)
      

  def findStringLimits(self):
    segments = self.charString[0][5]
    [xmin, xmax, ymin, ymax] = self.fontSize( segments)
    
    for s in self.charString:
      segments = s[5]
      [x1, x2, y1, y2] = self.fontSize(segments)
      if x1 < xmin:
        xmin = x1
      if x2 > xmax:
        xmax = x2
      if y1 < ymin:
        ymin = y1
      if y2 > ymax:
        ymax = y2

    xcenter = (xmax+xmin)/2.0
    ycenter = (ymax+ymin)/2.0
    return [xmin, xmax, ymin, ymax, xcenter, ycenter]


  def centerString(self):
    [xmin, xmax, ymin, ymax, xcenter, ycenter] = self.findStringLimits()
    self.displaceString(-xcenter, -ycenter)


  def rotateCharacter(self, segment, theta, xc, yc):
    for i in range(len(segments)):
      seg = segments[i]
      for j in range(len(seg)):
        pt = seg[j]
        dx = (pt[0] - xc) 
        dy = (pt[1] - yc)
        # note - this is for clockwise rotations
        xnew =  dx * math.cos(t) + dy * math.sin(t) + xc
        ynew = -dx * math.sin(t) + dy * math.cos(t) + yc
        segments[i][j][0] = xnew
        segments[i][j][1] = ynew


  def rotationString(self, theta, xc, yc):
    for s in self.charString:
      segments = s[5]
      self.rotateCharacter(segments, theta, xc, yc)

  def calcPoints(self, plt):
    self.scaleString(1, -1)
    #self.rotateString(30, 0, 0)

    [xmin, xmax, ymin, ymax, xcenter, ycenter] = self.findStringLimits()

    dr = (xmax - xmin)/500.
    xpts = []
    ypts = []

    # loop over the characters in the string
    for s in self.charString:        
      # pull the charcter sizes, limits, and segments
      bSize = s[4]
      segments = s[5]
      xs = bSize[0]
      xf = bSize[1]
 

      # for each segment in the current character
      for ll in segments:
        x = []
        y = []
        # make a list of the corners
        for i in range(len(ll)):
          x.append(ll[i][0] )
          y.append(ll[i][1] )
      
        # loop over the corners
        for i in range(1,len(x)):
          # form the starting and ending location for the current segment
          xs = x[i-1]
          ys = y[i-1]
          xe = x[i]
          ye = y[i]

          # calculate the length of the segment
          rr = np.sqrt( (xe-xs)**2 + (ye-ys)**2)

          # determine how much to partition the segment
          nn = max(int(rr/dr), 2)
          #nn = nn / 5 

          # split the segment up into points that are the right distance apart
          xps = np.linspace(xs, xe, nn)
          yps = np.linspace(ys, ye, nn)
          #print nn, xps, yps


          # if this is the first point in this segment, append it
          # if it is not, then ignore it so it is not double counted
          if i == i:
            xpts.append(xps[0])
            ypts.append(-yps[0]-30)
          # loop through the other points in the segment and
          # add them to the points table
          for j in range(1,len(xps) ):
            xpts.append(xps[j])
            ypts.append(-yps[j] -30)

    for kk in range(3):  
      for i in range(len(xpts)/2):
        del xpts[i]
        del ypts[i]
#    for i in range(len(xpts)/2):
#      del xpts[i]
#      del ypts[i]

    return xpts, ypts


  def plotString(self, plt, xstart, ystart):

    self.centerString()
    self.scaleString(1, -1)
    #self.rotateString(30, 0, 0)
   
    for s in self.charString:        
      bSize = s[4]
      segments = s[5]
      xs = bSize[0]
      xf = bSize[1]
      
      for ll in segments:
        x =[]
        y = []
        for i in range(len(ll)):
          x.append(ll[i][0] )
          y.append(ll[i][1] )
  
        plt.plot(x, y, '-b')
        


if __name__ == "__main__":
  hf = hersheyFonts()


  aspectratio = 0
  margin = 0.1
  
  figureSize = 8

  for findex in range(1,15):

  #if 1 == 1:
  #  findex = 10
    fig = plt.figure( figsize=(figureSize, figureSize))
    fig.patch.set_facecolor('white')
    ax = fig.add_subplot(111)  #,aspect='equal')
    
    ax.get_xaxis().set_visible(False)
    ax.get_yaxis().set_visible(False)
    ax.set_frame_on(False)

    xstart = 10
    ystart = 0
    print hf.fontList[findex]
    hf.readFontIndex(findex)
    aa =  hf.formString("John Wallin-0123")
    [xmin, xmax, ymin, ymax, xcenter, ycenter] = hf.findStringLimits()

    xmin = xmin - (xmin-xcenter)*1.5
    xmax = xmax + (xmax-xcenter)*1.5

    ymax = (xmax+xmin)/2.0
    ymin = -ymax
    plt.xlim(xmin, xmax)
    plt.ylim(ymin, ymax)
 
    hf.plotString( plt, xstart, ystart)
    hf.calcPoints( plt)
#    plt.plot(xpts, ypts, "+r")          
    plt.show()

  plt.close()


#        circle1 = plt.Circle( (0,0), self.Rmax, color='red', fill=False)
#        ax.add_artist(circle1)



 
