// onetime padlock

use <write/Write.scad>

/* [Global] */

text="R+T"; 
position_x=20; // [-100:100]
position_y=15; // [-100:100]
text_size=18; // [5:25]
letter_space=10; //[5:20]
text_font="knewave.dxf"; //[write/knewave.dxf:Knewave,write/orbitron.dxf:Orbitron,write/Letters.dxf:Letters,write/BlackRose.dxf:BlackRose,write/braille.dxf:Braille]

module herz(h) //heart
{
  scale([1, -1, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[0.000000,20.999850],[-6.291700,20.999850],[-7.666345,20.936866],[-8.461288,20.654075],[-9.072686,20.010722],[-9.896700,18.866050],[-13.123945,14.737206],[-16.349416,10.823645],[-19.318916,7.033228],[-21.778250,3.273812],[-22.737168,1.376936],[-23.473221,-0.546742],[-23.954635,-2.508740],[-24.149634,-4.520577],[-24.026445,-6.593768],[-23.553293,-8.739832],[-22.698402,-10.970287],[-21.430000,-13.296650],[-20.625525,-14.389767],[-19.659381,-15.368673],[-18.550929,-16.226612],[-17.319530,-16.956823],[-15.984543,-17.552550],[-14.565329,-18.007034],[-13.081249,-18.313516],[-11.551663,-18.465238],[-9.995930,-18.455441],[-8.433413,-18.277368],[-6.883471,-17.924259],[-5.365464,-17.389358],[-3.898753,-16.665904],[-2.502699,-15.747141],[-1.196661,-14.626309],[0.000000,-13.296650],[1.196660,-14.626309],[2.502695,-15.747141],[3.898745,-16.665904],[5.365450,-17.389358],[6.883451,-17.924259],[8.433387,-18.277368],[9.995898,-18.455441],[11.551625,-18.465238],[13.081207,-18.313516],[14.565285,-18.007034],[15.984499,-17.552550],[17.319487,-16.956823],[18.550892,-16.226612],[19.659352,-15.368673],[20.625508,-14.389767],[21.430000,-13.296650],[22.698402,-10.970271],[23.553293,-8.739804],[24.026445,-6.593731],[24.149634,-4.520534],[23.954635,-2.508696],[23.473221,-0.546698],[22.737168,1.376978],[21.778250,3.273850],[19.318916,7.033254],[16.349416,10.823659],[13.123945,14.737210],[9.896700,18.866050],[9.072686,20.010722],[8.461288,20.654075],[7.666345,20.936866],[6.291700,20.999850],[0.000000,20.999850]]);
  }
}


module luecke(h) //distance
{
  scale([1, -1, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[13.930000,6.381850],[9.930000,6.381850],[9.930000,10.881850],[3.930000,10.881850],[3.930000,-9.118150],[8.930000,-14.118150],[13.930000,-14.118150],[13.930000,6.381850]]);
    linear_extrude(height=h)
      polygon([[-13.930000,6.381850],[-9.930000,6.381850],[-9.930000,10.881850],[-3.930000,10.881850],[-3.930000,-9.118150],[-8.930000,-14.118150],[-13.930000,-14.118150],[-13.930000,6.381850]]);
  }
}

module klick(h) //clickpin
{
  scale([1, -1, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-8.930000,-18.351150],[-8.930000,-14.117750],[-3.930000,-9.117750],[-3.930000,10.882250],[-6.930000,10.882250],[-6.930000,-4.117750],[-6.930000,-8.117750],[-8.930000,-6.117750],[-10.930000,-4.117750],[-8.930000,-4.117750],[-8.930000,3.882250],[-8.930000,10.882250],[-9.930000,10.882250],[-9.930000,6.382250],[-13.930000,6.382250],[-13.930000,5.882250],[-13.930000,-14.117750],[-13.930000,-18.156650],[-13.930000,-20.999850],[-8.930000,-20.999850],[-8.930000,-18.351150]]);
    linear_extrude(height=h)
      polygon([[8.930000,-20.999850],[13.930000,-20.999850],[13.930000,-18.156550],[13.930000,-14.117750],[13.930000,5.882250],[13.930000,6.382250],[9.930000,6.382250],[9.930000,10.882250],[8.930000,10.882250],[8.930000,3.882250],[8.930000,-4.117750],[10.930000,-4.117750],[8.930000,-6.117750],[6.930000,-8.117750],[6.930000,-4.117750],[6.930000,10.882250],[3.930000,10.882250],[3.930000,-9.117750],[8.930000,-14.117750],[8.930000,-18.351150],[8.930000,-20.999850]]);
  }
}


module buegel(h) //shackle
{
  scale([1, -1, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-11.054300,19.036000],[-13.630000,19.036000],[-13.630000,-20.820000],[-13.612300,-21.526000],[-13.559600,-22.218000],[-13.472900,-22.900000],[-13.353000,-23.571000],[-13.200900,-24.230000],[-13.017200,-24.877000],[-12.803000,-25.510000],[-12.558800,-26.129000],[-12.285900,-26.733000],[-11.984900,-27.320000],[-11.656800,-27.891000],[-11.302000,-28.444000],[-10.922100,-28.979000],[-10.517400,-29.493000],[-10.088900,-29.988000],[-9.637300,-30.461000],[-9.163900,-30.913000],[-8.669400,-31.341000],[-8.154500,-31.746000],[-7.619900,-32.126000],[-7.067000,-32.481000],[-6.496300,-32.809000],[-5.908700,-33.110000],[-5.304800,-33.383000],[-4.686100,-33.627000],[-4.053000,-33.841000],[-3.406400,-34.025000],[-2.746900,-34.177000],[-2.075900,-34.297000],[-1.393800,-34.384000],[-0.701600,-34.436000],[0.000000,-34.454000],[0.701300,-34.436000],[1.393500,-34.384000],[2.075500,-34.297000],[2.746600,-34.177000],[3.405700,-34.025000],[4.052500,-33.841000],[4.685600,-33.627000],[5.304600,-33.383000],[5.908200,-33.110000],[6.495800,-32.809000],[7.066500,-32.481000],[7.619600,-32.126000],[8.154000,-31.746000],[8.669000,-31.341000],[9.163600,-30.913000],[9.637200,-30.461000],[10.088400,-29.988000],[10.517000,-29.493000],[10.921600,-28.979000],[11.301700,-28.444000],[11.656200,-27.891000],[11.984500,-27.320000],[12.285500,-26.733000],[12.558600,-26.129000],[12.802500,-25.510000],[13.016800,-24.877000],[13.200500,-24.230000],[13.352800,-23.571000],[13.472500,-22.900000],[13.559300,-22.218000],[13.612000,-21.526000],[13.630000,-20.820000],[13.630000,19.036000],[11.054300,19.036000],[9.230000,17.212000],[9.230000,10.061000],[9.282500,10.086000],[9.488200,10.150000],[9.709400,10.190000],[9.943600,10.204000],[10.175600,10.190000],[10.395100,10.151000],[10.599400,10.088000],[10.786100,10.000000],[10.951700,9.886000],[11.091300,9.742000],[11.192400,9.561000],[11.229000,9.377000],[11.233300,9.215000],[9.230000,7.212000],[9.230000,-20.828000],[9.217800,-21.299000],[9.182300,-21.767000],[9.123500,-22.229000],[9.042400,-22.684000],[8.939100,-23.131000],[8.814700,-23.569000],[8.669500,-23.998000],[8.504300,-24.417000],[8.319200,-24.826000],[8.115400,-25.224000],[7.893100,-25.610000],[7.653100,-25.985000],[7.395700,-26.347000],[7.121700,-26.695000],[6.831700,-27.030000],[6.526200,-27.350000],[6.205400,-27.656000],[5.870600,-27.946000],[5.521900,-28.220000],[5.160200,-28.477000],[4.785500,-28.718000],[4.399100,-28.940000],[4.001100,-29.144000],[3.592300,-29.329000],[3.173000,-29.494000],[2.744000,-29.639000],[2.306000,-29.764000],[1.859500,-29.867000],[1.404900,-29.948000],[0.942900,-30.006000],[0.474300,-30.042000],[0.000000,-30.054000],[-0.474600,-30.042000],[-0.943200,-30.006000],[-1.405200,-29.948000],[-1.859800,-29.867000],[-2.306500,-29.764000],[-2.744400,-29.639000],[-3.173500,-29.494000],[-3.592600,-29.329000],[-4.001600,-29.144000],[-4.399700,-28.940000],[-4.786300,-28.718000],[-5.160600,-28.477000],[-5.522400,-28.220000],[-5.871000,-27.946000],[-6.205900,-27.656000],[-6.526300,-27.350000],[-6.831900,-27.030000],[-7.122000,-26.695000],[-7.396100,-26.347000],[-7.653300,-25.985000],[-7.893500,-25.610000],[-8.115800,-25.224000],[-8.319700,-24.826000],[-8.504600,-24.417000],[-8.670000,-23.998000],[-8.815100,-23.569000],[-8.939600,-23.131000],[-9.042700,-22.684000],[-9.124000,-22.229000],[-9.182600,-21.767000],[-9.218100,-21.299000],[-9.230000,-20.828000],[-9.230000,7.212000],[-11.233300,9.215000],[-11.229000,9.377000],[-11.192700,9.561000],[-11.091500,9.742000],[-10.952200,9.886000],[-10.786300,10.000000],[-10.599900,10.088000],[-10.395400,10.151000],[-10.175900,10.190000],[-9.943600,10.204000],[-9.709700,10.190000],[-9.488300,10.150000],[-9.282800,10.086000],[-9.230000,10.061000],[-9.230000,17.212000]]);
  }
}


//Body
color("red") translate([0,4.5,42.0/2.0]) rotate([90,0,0]) union()
{
difference()
	{
	translate([0,0,0]) herz(9);
	union()
		{
		translate([0,0,1]) luecke(1);
		translate([0,0,2]) klick(5);
		translate([0,0,7]) luecke(1);
		}
	}
}
//text
color("yellow") translate([0+position_x/10,-4.9,42.0/2.0++position_y/10]) rotate([90,0,0]) write(text,t=1.1,h=text_size,font=text_font,space=letter_space/10,center=true);

//shackle
color("yellow") rotate([0,0,90]) buegel(4.3);

//montiert
//color("yellow") translate([0,2.15,34.5]) rotate([90,0,0]) buegel(4.3);