#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

/* defines */
#define DEFBUFSIZE (4096)
#define DEFPORT    (5001)
#define MAXBUFSIZE (32*1024)

#define UDP_MODE 0
#define TCP_MODE 1
#define PF_WIZNET PF_BLUETOOTH

char buffer[MAXBUFSIZE] = {0,};

static void usage(void)
{
  fprintf(stderr, "\n");
  fprintf(stderr, "usage: loopback [option]\n\n");
  fprintf(stderr, "Options:\n");
  fprintf(stderr, "-h               loopback help\n");
  fprintf(stderr, "-u               UDP loopback mode\n");
  fprintf(stderr, "-t               TCP loopback mode\n");
  fprintf(stderr, "-w               PF_WIZNET loopback mode(Default 'PF_INET')\n");
  fprintf(stderr, "-b <size>        buffer size(Default 4096)\n");
  fprintf(stderr, "-p <port>        port number(Default 5001)\n");
  exit(1);
}

int main (int argc, char *argv[])
{
  int bufsize=DEFBUFSIZE;
  struct sockaddr_in sock_in;
  struct sockaddr addr;
  int family=0;
  int sd, fd;
  int addr_len;
  int opt;
  int ret;
  int proto_mode = -1;
  int proto_type;
  short port = DEFPORT;

  bzero((char *)&sock_in, sizeof (sock_in));
  bzero((char *)&addr, sizeof (addr));

  /* command line argument option */
  while( (opt=getopt(argc, argv, "huwtb:p:")) != EOF )
  {
    switch(opt)
    {
      case 'h':
        usage();
        return 0;
        break;
      case 't':
        if(proto_mode >= 0) 
        {
          fprintf(stderr, "Invalid Option.\n");
          return -1;
        }
        proto_mode = TCP_MODE;
        break;
      case 'u':
        if(proto_mode >= 0) 
        {
          fprintf(stderr, "Invalid Option.\n");
          return -1;
        }
        proto_mode = UDP_MODE;
        break;
      case 'b':
        bufsize = abs(atoi(optarg));
        break;
      case 'p':
        port = abs(atoi(optarg));
        break;
      case 'w':
        family = PF_WIZNET;
        break;
    }
  }

  if(proto_mode < 0)
  {
    fprintf(stderr, "Invalid Option. Input protocal mode option.(-t or -u)\n");
    return -1;
  }

  if(proto_mode)
    proto_type = SOCK_STREAM;
  else
    proto_type = SOCK_DGRAM;

  if(!family)
    family = PF_INET;

  /* create socket */
  sd = socket(family, proto_type, 0);
  if (sd < 0) {
    perror("socket");
    return -1;
  }
  sock_in.sin_family = family;
  sock_in.sin_addr.s_addr = htonl(INADDR_ANY);
  sock_in.sin_port = htons(port);

  /* bind server port to socket */
  if (bind(sd, (struct sockaddr*)&sock_in, sizeof (sock_in)) < 0) {
    perror("bind");
    return -1;
  }

  if(proto_mode)
  {
    /* listen */
    if(listen(sd, 0) < 0)
    {
      perror("listen");
      return -1;
    }

    /* accept */
    addr_len = sizeof(addr);
    fd = accept(sd, &addr, &addr_len);
    if (fd < 0) {
      perror("cannot accept connection ");
      close(sd);
      return -1;
    }
  }

  printf("loopback start!\n");

  if(proto_mode)
  {
    while(1)
    {
      /* recv data from client */
      ret = recv(fd, buffer, bufsize, 0);
      if(ret < 0)
      {
        perror("recv");
        return -1;
      }
      /* send data(=recv data) to client */
      ret = send(fd, buffer, ret, 0);
      if(ret < 0) 
      {
        perror("send");
        return -1;
      }
    }
  } else {
    while(1)
    {
      addr_len = sizeof(addr);
      ret = recvfrom(sd, buffer, bufsize, 0, &addr, &addr_len);
      if(ret < 0)
      {
        perror("recvfrom");
        return -1;
      }
      ret = sendto(sd, buffer, ret, 0, &addr, addr_len);
      if(ret < 0)
      {
        perror("sendto");
        return -1;
      }
    }
  }

  close(sd);
  return 0;
}
