#!/usr/bin/env python
"""Demo server that allows user registration and login."""

import cgi
import cgitb
import os

import time
import zmq



# Allows errors to be dumped onto the page.
cgitb.enable()

# Constants
APP_NAME = os.environ['SCRIPT_NAME'].split('/')[-1:][0]
BASE_URL= 'http://%s%s' % (os.environ['HTTP_HOST'], os.environ['SCRIPT_NAME'])
# TODO(gwc): Store DB credentials elsewhere.
# Update these constants with your DB credentials.


class Error(Exception):
  """The base error class."""


def render_template(filename, data=None):
  """Opens a template file and prints its contents.
  
  Args:
    filename: string. The name of the file to print (without the file type).
    data: dict. Optional dict of values to replace in a template.
  """
  try:
    # Assumes the filename is in templates/
    f = open('templates/%s.html' % filename)
  except IOError as e:
    # The file doesn't exist.
    # TODO(gwc): Serve a custom 404 page instead of the cgi dump.
    raise Error(e)
  try:
    content = f.read()
    # Print the headers. Required otherwise the server encounters an error.
    print('Content-Type: text/html')
    print()
    content = set_template_variables(content, data)
    print(content)
  except Exception as e:
    # There is some other error we're not anticipating.
    raise Error(e)
  finally:
    # This block will close the file even if an error occurs.
    f.close()


def set_template_variables(content, data=None):
  """Replaces string values in a template.

  Args:
    content: string. The HTML content.
    data: dict. Optional dict of values to replace in a template.

  Returns:
    content: string. The formatted HTML content.
  """
  if not data:
    data = {'base_url': BASE_URL}
  return content % data


def send():
  """Handles account authenication."""
  form = cgi.FieldStorage()

  format = form["radio_data_option"].value

  try:
    if format == "hexadecimal": 
    #convert to decimal
      col1_int = int(form["col1_data"].value, 16)
      col2_int = int(form["col2_data"].value, 16)
      col3_int = int(form["col3_data"].value, 16)
      col4_int = int(form["col4_data"].value, 16)
      col5_int = int(form["col5_data"].value, 16)
      col6_int = int(form["col6_data"].value, 16)
      col7_int = int(form["col7_data"].value, 16)
      col8_int = int(form["col8_data"].value, 16)
    else:
      col1_int = int(form["col1_data"].value)
      col2_int = int(form["col2_data"].value)
      col3_int = int(form["col3_data"].value)
      col4_int = int(form["col4_data"].value)
      col5_int = int(form["col5_data"].value)
      col6_int = int(form["col6_data"].value)
      col7_int = int(form["col7_data"].value)
      col8_int = int(form["col8_data"].value)

  except ValueError:
    data = {
      'status': 'failed',
      'message': 'Invalid value',
      'redirect_url': '%s/%s' % (BASE_URL, 'send_pixel'),
    }



  
  else:

    if col1_int < 256 and col2_int < 256 and col3_int < 256 and col4_int < 256 and col5_int < 256 and col6_int < 256 and col7_int < 256 and col8_int < 256:

      pixel_data=str(col1_int)+","+str(col2_int)+","+str(col3_int)+","+str(col4_int)+","+str(col5_int)+","+str(col6_int)+","+str(col7_int)+","+str(col8_int)

    #debug
    #raise Error(pixel_data)

    #  Prepare our context and sockets
      context = zmq.Context()
      socket = context.socket(zmq.REQ)
    #socket.connect("tcp://localhost:5559")
      socket.connect("tcp://localhost:5555")

      socket.send_string(pixel_data)

      #  Get the reply.
      message = socket.recv()
      #print("Received reply %s [ %s ]" % (request, message))

      data = {
        'status': 'ok',
        'message': 'Displaying....',
        'redirect_url': '%s/%s' % (BASE_URL, 'send_pixel'),
      }

    else:

      data = {
        'status': 'failed',
        'message': 'Column value must be less than 256',
        'redirect_url': '%s/%s' % (BASE_URL, 'send_pixel'),
      }

  finally:

    render_template('interstitial', data)


def redirect(location):
  """Redirects to a page.

  Args:
    location: string. The page URL to redirect to.
  """
  print('Status: 302 Found')
  print('Location: %s/%s' % (
      BASE_URL,
      location))
  print()


"""The server logic is here."""
def main():
  # uri is the request URL e.g. [DOMAIN]/server.py
  uri = os.environ['REQUEST_URI'][1:]
  try:
    # If the URL is [DOMAIN]/server.py/register:
    # page = ['server.py', 'register']
    page = uri.split('/')
    page = page[page.index(APP_NAME) + 1]

    # Special handlers for form submission pages.
    if page == 'send':
      send()
    else:
      # The only valid pages right now are 'login' and 'register'.
      render_template(page)
  except IndexError:
    # If the user is only going to [DOMAIN]/server.py then
    # serve the login page.
    redirect('send_pixel')


# This statement tells the system to treat this script as a
# stand-alone application.
if __name__ ==  '__main__':
  main()
