//========================================================//
//
//	apdigitallight.com
//  LED clock ver 1.0 12/27/2009
//  PIC16F876A, NJU6355
//
//========================================================//


#include "C:\projects\pic\LED clock 2009\PIC\led_clock.h"
#include "C:\projects\pic\LED clock 2009\PIC\NJU6355.c"

//turn LED# ON-OFF (0 - 8)
void LED_ON(int8);
void LED_OFF(int8);
void LED_reset(void);

void random_generator(void);

//display current seconds value
void display_sec(BYTE);
void display_hour(BYTE);

void set_array_B(BYTE);
void set_array_R(BYTE);
void set_array_G(BYTE);
void set_array_A(BYTE);
BYTE set_AR(BYTE, BYTE);

void display_array_B(void);
void display_array_AR(void);
void display_array_G(void);

#define test_pin PIN_A0

// BLUE led_col_3, LEDs 0-8
// RED led_col_2, LEDs 1,2,4,5,7,8
// AMBER led_col_2, LEDs 0,3,6
// GREEN led_col_1, LEDs 0-8

#define LED_1 PIN_C3
#define LED_2 PIN_C4
#define LED_3 PIN_C2
#define LED_4 PIN_C5
#define LED_5 PIN_C1
#define LED_6 PIN_C6
#define LED_7 PIN_C0
#define LED_8 PIN_C7
#define LED_9 PIN_B0
#define led_col_1 PIN_B1
#define led_col_2 PIN_B2
#define led_col_3 PIN_B3

//pins are pulled up
//input is high initially
#define pin_PB1 PIN_B4
#define pin_PB2 PIN_B5

//outputs
int8 LED_output[9] = {LED_1, LED_2, LED_3, LED_4, LED_5, LED_6, LED_7, LED_8, LED_9}; 
int8 LED_col[3] = {led_col_1, led_col_2, led_col_3};

//output data matrix for predefined color  
int1 bin_array_B[9];
int1 bin_array_G[9];
int1 bin_array_AR[9];

//random generated data 
BYTE rand_data[3];
 
int i = 0;
int k = 0;

//state
// 0 - initial - display time - hour:min
// 1 
// 2 - display date - mon:day 
// 3
//
// clock swithes itself from state 2 to state 0 after 30 sec 
int state = 0;


//long time inteval counter
int lti = 0;
//30 sec interval counter
int lti30s = 0;

int temp = 0;
int temp1 = 0;

//logic flag 1 sec 
boolean f_one_sec = 0;
//modification mode
boolean f_mdf = 0;
//write data to RTC 
boolean f_write_rtc = 0;	

BYTE RTC_year = 10;
BYTE RTC_mon = 1;
BYTE RTC_day = 1;
BYTE RTC_dow = 1;
BYTE RTC_hour = 0;
BYTE RTC_min = 0;
BYTE RTC_sec = 0;

//max_day of month
const BYTE  max_day[] = {31,29,31,30,31,30,31,31,30,31,30,31};

#int_RTCC
RTCC_isr() 
{


}

//period 0.2S
//long time interval timer (PB scan)
#int_TIMER1
TIMER1_isr() 
{
	//f_state = 1;
	
	lti++;
	if(lti == 5)
	{
		lti = 0;
		f_one_sec = 1;

		if(state == 2)
		{
			lti30s++;
			if(lti30s >=30)
			{
				//switch to state 0 after 30 sec
				lti30s = 0;
				state = 0;
 			}
		}
	}


	switch (state) {
		//initial state - time mode
		case 0:	
				// PB1 pressed
				if (!input(pin_PB1)) 
				{
					state = 1; 
				}
				// PB2 pressed
				if (!input(pin_PB2)) 
				{
					state = 10; 
					f_mdf = 1; 
				}
				break;

		// PB1 released
		case 1:	if (input(pin_PB1)) 
				{
					state = 2; //display date
					//reset 30 sec counter
					lti30s = 0;
				}
				break;
		//date mode
		// PB1 pressed
		case 2:	if (!input(pin_PB1)) 
				{
					state = 3; 
				}
				// PB2 pressed
				if (!input(pin_PB2)) 
				{
					state = 20;
					f_mdf = 1; 
				}
				break;
		// PB1 released
		case 3:	if (input(pin_PB1)) 
				{
					state = 0; //initial state - display time
				}
				break;

		//time modification states
		case 10:
				// PB2 released 
				if (input(pin_PB2)) 
				{
					state = 11; //modify hour 
				}
 				break;
		case 11:
				//PB2 pressed 
				if (!input(pin_PB2)) 
				{
					state = 12; 
				}
				// PB1 pressed	- increase hour
				if (!input(pin_PB1)) 
				{
					RTC_hour++;
					if(RTC_hour>23) RTC_hour = 0; 
					f_write_rtc = 1;
				}
				break;
		case 12:
				// PB2 released 
				if (input(pin_PB2)) 
				{
					state = 13; //modify min 
				}
				break;
		case 13:
				//PB2 pressed 
				if (!input(pin_PB2)) 
				{
					state = 14; 
				}
				// PB1 pressed	- increase min
				if (!input(pin_PB1)) 
				{
					RTC_min++;
					if(RTC_min>59) RTC_min = 0; 
					f_write_rtc = 1;
				}
				break;
		case 14:
				// PB2 released 
				if (input(pin_PB2)) 
				{
					state = 0; //initial state 
					f_mdf = 0;
				}
				break;

		//date modification states
		case 20:
				// PB2 released 
				if (input(pin_PB2)) 
				{
					state = 21; //modify month 
				}
 				break;
		case 21:
				//PB2 pressed 
				if (!input(pin_PB2)) 
				{
					state = 22; 
				}
				// PB1 pressed	- increase month
				if (!input(pin_PB1)) 
				{
					RTC_mon++;
					if(RTC_mon>12) RTC_mon = 1; 
					f_write_rtc = 1;
				}
				break;
		case 22:
				// PB2 released 
				if (input(pin_PB2)) 
				{
					state = 23; //modify day 
				}
				break;
		case 23:
				//PB2 pressed 
				if (!input(pin_PB2)) 
				{
					state = 24; 
				}
				// PB1 pressed	- increase day
				if (!input(pin_PB1)) 
				{
					RTC_day++;
					if(RTC_day>max_day[RTC_mon-1]) RTC_day = 1; 
					f_write_rtc = 1;
				}
				break;
		case 24:
				// PB2 released 
				if (input(pin_PB2)) 
				{
					state = 0; //initial state 
					f_mdf = 0;
				}
				break;

	}


	//output_toggle(test_pin);	

}

#int_TIMER2
TIMER2_isr() 
{

}



void main()
{

   setup_adc_ports(NO_ANALOGS);
   setup_adc(ADC_OFF);
   setup_spi(FALSE);

	//OSC = 10MHz	
	//period = 1/(OSC/4) * RTCC_DIV * (timer_set + 1) 
   	//period = 0.4uS * 1 * 256 = 0.1024 mS
	setup_timer_0(RTCC_INTERNAL|RTCC_DIV_1);
   	//period = 1/(OSC/4) * T1_DIV * (timer_set + 1)
	//period  = 0.4uS * 8 * 65536 = 0.209712S	 
	setup_timer_1(T1_INTERNAL|T1_DIV_BY_8);
	//period  = 1/(OSC/4) * T2_DIV * (timer_reg + 1) * T2_DIV2
	//perood  =  0.4uS * 16 * 225 * 7 = 0.01008S
   setup_timer_2(T2_DIV_BY_16,224,7);
   setup_comparator(NC_NC_NC_NC);
   setup_vref(FALSE);
   //enable_interrupts(INT_RTCC);
   enable_interrupts(INT_TIMER1);
   //enable_interrupts(INT_TIMER2);
   enable_interrupts(GLOBAL);

	rtc_init();  
	
	delay_ms(500);
   // TODO: USER CODE!!

	
	//rtc_get_time(RTC_hour, RTC_min, RTC_sec);

	//if((RTC_hour==0) || (RTC_hour>23) || (RTC_min==0) || (RTC_min>59))
	//{
		rtc_set_datetime(31,12,9,5,14,45);
	//}

	rand_data[0] = RTC_hour;
 	rand_data[1] = RTC_min;
	rand_data[2] = RTC_sec;
	random_generator();

	//LEDs testing  
/*
	for(k = 0; k<3; k++)
	{
		output_high(LED_col[k]);
		for(i = 0; i<9; i++)
		{	
			LED_ON(i);
			delay_ms(100);
			LED_OFF(i);
			delay_ms(100);
		}
		output_low(LED_col[k]);
	}
*/

	LED_reset();

	for(k = 0; k<3; k++)
	{
		output_high(LED_col[k]);
		for(i = 0; i<9; i++)
		{	
			LED_ON(i);
			delay_ms(100);
		}
		for(i = 0; i<9; i++)
		{	
			LED_OFF(i);
			delay_ms(100);
		}
		output_low(LED_col[k]);
	}

/*
		for(i = 0; i<9; i++)
		{	
			LED_ON(i);
		}


	for(;;) {
		output_high(LED_col[0]);
		delay_ms(1);
		output_low(LED_col[0]);
		output_high(LED_col[1]);
		delay_ms(1);
		output_low(LED_col[1]);
		output_high(LED_col[2]);
		delay_ms(1);
		output_low(LED_col[2]);
	}
*/


	LED_reset();

	for(;;)
	{


		if(f_write_rtc)
		{
			f_write_rtc =0;	
			rtc_set_datetime(RTC_day,RTC_mon,RTC_year,RTC_dow,RTC_hour,RTC_min);	
		}


		//time period 1 sec passed
		//change pattern
		if(f_one_sec && (!f_mdf))
		{
			//reset flag
			f_one_sec = 0;
			random_generator();

			switch (state)
			{
				//display time
				case 0:
					//update data
					rtc_get_time(RTC_hour, RTC_min, RTC_sec);
					temp = RTC_min/10;
					temp1 = RTC_min - (temp * 10);
 
					set_array_B(temp1);
					set_array_R(temp);

					temp = RTC_hour/10;
					temp1 = RTC_hour - (temp * 10);
 
					set_array_G(temp1);
					set_array_A(temp);

				break;
				//display date
				case 2:
					rtc_get_date(RTC_day,RTC_mon,RTC_year,RTC_dow);
					temp = RTC_day/10;
					temp1 = RTC_day - (temp * 10);
 
					set_array_B(temp1);
					set_array_R(temp);

					temp = RTC_mon/10;
					temp1 = RTC_mon - (temp * 10);
 
					set_array_G(temp1);
					set_array_A(temp);
				break;
			}
		}

		//data modification mode
		if(f_mdf)
		{
	
		//	output_toggle(test_pin);	

			//reset flag
			//f_state = 0;
			LED_reset();
			switch (state)
			{
				//modify hour
				case 11:
					display_hour(RTC_hour);
 				break;
				//modify min
				case 13:
					display_sec(RTC_min);		
				break;
				//modify month
				case 21:
					display_hour(RTC_mon);
 				break;
				//modify day
				case 23:
					display_sec(RTC_day);		
				break;
			}
		}

		//normal mode - display current data
		else
		{
			display_array_AR();
			output_high(LED_col[1]);
			delay_ms(1);
			LED_reset();

			display_array_B();
			output_high(LED_col[2]);
			delay_ms(5);
			LED_reset();
		
			display_array_G();
			output_high(LED_col[0]);
			delay_ms(1);
			LED_reset();
		}
	}
}

void display_sec(BYTE b_sec)
{
	int nh;
   	int nl;

//HEX 2 BCD convercion 
   	nh=b_sec/10;
   	nl=b_sec-(nh*10);

//	nh = b_sec>>4;
//	nl = b_sec<<4>>4;

	switch (nh) {
		case 0: break;
		case 1: 
			LED_ON(1); 
			break;
		case 2: 
			LED_ON(1);	
			LED_ON(2);
			break;
		case 3: 
			LED_ON(1);	
			LED_ON(2); 
			LED_ON(4);
			break;
		case 4: 
			LED_ON(1);	
			LED_ON(2); 
			LED_ON(4);
			LED_ON(5);
			break;
		case 5: 
			LED_ON(1);	
			LED_ON(2); 
			LED_ON(4);
			LED_ON(5);
			LED_ON(7);
			break;
	}
	output_high(LED_col[1]);
	delay_ms(1);
	LED_reset();

	for(i = 0; i<nl; i++)
	{	
		LED_ON(i);
	}

	output_high(LED_col[2]);
	delay_ms(5);
	LED_reset();

}

void display_hour(BYTE b_hr)
{
	int nh;
   	int nl;

	//HEX 2 BCD convercion 
   	nh=b_hr/10;
   	nl=b_hr -(nh*10);

	switch (nh) {
		case 0: break;
		case 1: 
			LED_ON(0); 
			break;
		case 2: 
			LED_ON(0);	
			LED_ON(3);
			break;
	}
	output_high(LED_col[1]);
	delay_ms(1);
	LED_reset();

	for(i = 0; i<nl; i++)
	{	
		LED_ON(i);
	}

	output_high(LED_col[0]);
	delay_ms(1);
	LED_reset();
}

void set_array_A(BYTE a)
{
	BYTE t_a;
	t_a = a;

	//claer array
	bin_array_AR[0] = 0;
	bin_array_AR[3] = 0;
	bin_array_AR[6] = 0;

	while(t_a>0)
	{
		t_a = set_AR(t_a,0);
		if(t_a == 0) return;
		t_a = set_AR(t_a,3);
		if(t_a == 0) return;
		t_a = set_AR(t_a,6);
		if(t_a == 0) return;
	}
}


void set_array_R(BYTE r)
{
	BYTE t_r;
	t_r = r;

	//claer array
	bin_array_AR[1] = 0;
	bin_array_AR[2] = 0;
	bin_array_AR[4] = 0;
	bin_array_AR[5] = 0;
	bin_array_AR[7] = 0;
	bin_array_AR[8] = 0;

	//all LEDS ON
	if(t_r == 6)
	{
		bin_array_AR[1] = 1;
		bin_array_AR[2] = 1;
		bin_array_AR[4] = 1;
		bin_array_AR[5] = 1;
		bin_array_AR[7] = 1;
		bin_array_AR[8] = 1;
		return;
	}
		
	while(t_r>0)
	{
		t_r = set_AR(t_r,1);
		if(t_r == 0) return;
		t_r = set_AR(t_r,2);
		if(t_r == 0) return;
		t_r = set_AR(t_r,4);
		if(t_r == 0) return;
		t_r = set_AR(t_r,5);
		if(t_r == 0) return;
		t_r = set_AR(t_r,7);
		if(t_r == 0) return;
		t_r = set_AR(t_r,8);
		if(t_r == 0) return;
	}
}

BYTE set_AR(BYTE temp_rr, BYTE ind_r)
{
	random_generator();
	if((bin_array_AR[ind_r] == 0) && (bit_test(rand_data[2],0)))
	{
		bin_array_AR[ind_r] = 1;
		temp_rr--;
	} 
	return temp_rr;
}


void set_array_B(BYTE b)
{
	int temp_b;
	temp_b = b;

	//all LEDs ON
	if(temp_b == 9)
	{
		for(i = 0; i<9; i++)
		{
			bin_array_B[i] = 1;
		}
		return;
	}

	//clear array
	for(i = 0; i<9; i++)
	{
		bin_array_B[i] = 0;
	}
	if(temp_b == 0) return;

	while(temp_b>0)
	{
		for(i = 0; i<9; i++)
		{
			random_generator();
			if((bin_array_B[i] == 0) && (bit_test(rand_data[2],0)))
			{
				bin_array_B[i] = 1;
				temp_b--;
				if(temp_b == 0) return;	
			}
		}
	}
}

void set_array_G(BYTE g)
{
	int temp_g;
	temp_g = g;

	//all LEDs ON
	if(temp_g == 9)
	{
		for(i = 0; i<9; i++)
		{
			bin_array_G[i] = 1;
		}
		return;
	}

	//clear array
	for(i = 0; i<9; i++)
	{
		bin_array_G[i] = 0;
	}
	if(temp_g == 0) return;

	while(temp_g>0)
	{
		for(i = 0; i<9; i++)
		{
			random_generator();
			if((bin_array_G[i] == 0) && (bit_test(rand_data[2],0)))
			{
				bin_array_G[i] = 1;
				temp_g--;
				if(temp_g == 0) return;	
			}
		}
	}
}

void display_array_B(void)
{
	for(i = 0; i<9; i++)
	{
		if(bin_array_B[i] == 1)
		{
			LED_ON(i);	
		}
	}
}

void display_array_G(void)
{
	for(i = 0; i<9; i++)
	{
		if(bin_array_G[i] == 1)
		{
			LED_ON(i);	
		}
	}
}

void display_array_AR(void)
{
	for(i = 0; i<9; i++)
	{
		if(bin_array_AR[i] == 1)
		{
			LED_ON(i);	
		}
	}
}

void LED_ON(int8 led)
{
	output_high(LED_output[led]);
}

void LED_OFF(int8 led)
{
	output_low(LED_output[led]);
}

void LED_reset(void)
{
	for(k = 0; k<3; k++)
	{
		output_low(LED_col[k]);
	}

	for(i = 0; i<9; i++)
	{	
		LED_OFF(i);
	}
}

void random_generator(void)
{
//	shift_right(rand_data,3,1);
	shift_right(rand_data,3,(bit_test(rand_data[2],6) ^ bit_test(rand_data[2],1) ^ bit_test(rand_data[2],0)));	
}