#include <TinyServo.h>
#include <Bounce2.h>
#include <SoftwareSerial.h>

const int up = 10;
const int down = 9;
const int left = 8; 
const int right = 7;
const int laserControl = 4;   // the number of the pin connected to the transistor controlling the laser
const int ledPin = 6;

int panservoval = 112;
int tiltservoval = 102;
int laserState;

char incomingByte; // variable to receive data from the serial port

Bounce updebounce = Bounce();
Bounce downdebounce = Bounce();
Bounce leftdebounce = Bounce();
Bounce rightdebounce = Bounce();
Bounce middebounce = Bounce();

SoftwareSerial BTSerial(3, 2); // RX | TX

const byte SERVOS = 2; // how many servos do you have? up to 5 on ATTiny85 and 8 on ATtiny84/2313
const byte servoPin[SERVOS] = { 
  0, 1 }; // what pins are your servos on?
// you have the option to give your servos nice names. 0 refers to the first servo pin above, 1 to the second, etc
#define PANSERVO 0
#define TILTSERVO 1


void setup(){
  BTSerial.begin(9600);
  setupServos();
  moveServo(PANSERVO, panservoval);   // sets the servo position according to the scaled value
  moveServo(TILTSERVO, tiltservoval);
  pinMode(laserControl, OUTPUT);
  pinMode(ledPin,OUTPUT);
  pinMode(up, INPUT_PULLUP);
  pinMode(down, INPUT_PULLUP);
  pinMode(left, INPUT_PULLUP);
  pinMode(right, INPUT_PULLUP);
  updebounce.attach(up);
  updebounce.interval(50); // interval in ms
  downdebounce.attach(down);
  downdebounce.interval(50); // interval in ms
  leftdebounce.attach(left);
  leftdebounce.interval(50); // interval in ms
  rightdebounce.attach(right);
  rightdebounce.interval(50); // interval in ms
  digitalWrite(laserControl, LOW);
  laserState = 1;
}
void loop(){

  bluetoothcontrol(10, 1);   //function to move servo using bluetooth. value for servo delay before moving again. Lower value to increase movement speed
  buttoncontrol(20, 1);   //function to move servo with onboard buttons. value for servo delay before moving again. Lower value to increase movement speed

  if (panservoval > 225){
    panservoval = 225;
  }
  if (panservoval < 0){
    panservoval = 0;
  }
  if (tiltservoval > 140){
    tiltservoval = 140;
  }
  if (tiltservoval < 10){
    tiltservoval = 10;
  }
  servoPos[PANSERVO] =  panservoval;   // sets the servo position according to the scaled value
  servoPos[TILTSERVO] = tiltservoval;
}

void bluetoothcontrol(int bluetoothdelay, int bluetoothaddsubval){
  if(BTSerial.available()){
    incomingByte = BTSerial.read(); // read it and store it in 'incomingByte'
    if(incomingByte == 'u'){
      delay(bluetoothdelay);
      tiltservoval = tiltservoval - bluetoothaddsubval;
    } 
    if(incomingByte == 'd'){
      delay(bluetoothdelay);
      tiltservoval = tiltservoval + bluetoothaddsubval;
    }
    if(incomingByte == 'l'){
      delay(bluetoothdelay);
      panservoval = panservoval + bluetoothaddsubval;
    } 
    if(incomingByte == 'r'){
      delay(bluetoothdelay);
      panservoval = panservoval - bluetoothaddsubval;
    }
    if(incomingByte == 'm'){
      delay(bluetoothdelay);
      panservoval = 112;
      tiltservoval = 102;
    }
    if(incomingByte == 'o'){
      if(laserState == 1){
        digitalWrite(laserControl, HIGH);
        laserState = 0;
      }
      else if(laserState == 0){
        digitalWrite(laserControl, LOW);
        laserState = 1;
      }
      incomingByte = 0;  
    }
  }
}

void buttoncontrol(int buttondelay, int buttonaddsubval){
  updebounce.update();
  downdebounce.update();
  leftdebounce.update();
  rightdebounce.update();
  middebounce.update();

  int upvalue = updebounce.read();
  int downvalue = downdebounce.read();
  int leftvalue = leftdebounce.read();
  int rightvalue = rightdebounce.read();

  if(upvalue == LOW){
    tiltservoval = tiltservoval - buttonaddsubval;
    delay(buttondelay);
  } 
  else if(downvalue == LOW){
    tiltservoval = tiltservoval + buttonaddsubval;
    delay(buttondelay);
  }
  if(leftvalue == LOW){
    panservoval = panservoval + buttonaddsubval;
    delay(buttondelay);
  } 
  else if(rightvalue == LOW){
    panservoval = panservoval - buttonaddsubval;
    delay(buttondelay);
  } 
}


