
use <MCAD/involute_gears.scad>

$fn=50;

// *NB* of blades
NB = 5;

// *T*hickness of slices
T = 3;

// *R*adius of the box
R = 34;

// *H*eight of the box
H = 15*T;

// type of *S*crew : M4 => 4
S = 4;
// nut diameter on flat side M4 => 7
ND = 7;

// box *W*all
// W > 2*S
W = 14;

// distance of screws from axis
AS = R-W+S+1;

// small gear
TSG = 10;			// nb teeth
// (AS+RSG)*TSG = k*NB*RSG
// RSG = (TSG*AS)/(k*NB-TSG)
// k = 12
RSG = 5;		// radius

// big gear (ring)
RBG = AS+RSG;		// innner radius
TBG = TSG*RBG/RSG;	// nb teeth, RSG must be choosen so that it is a multiple of NB

module blade()
{
	// blade
	translate([0,0,T])
	difference()
	{
		assign( Raxis = AS*(2*sin(360/NB/2)-1) )
		union()
		{
			// axis
			cylinder( h=T, r=Raxis );
			// "croissant"
			difference()
			{
				intersection()
				{
					cylinder(h=T,r=AS-0.1);
					translate([-AS,0,0]) cylinder(h=T,r=R);
				}
				// place for next blade, when closed
				translate([-AS,0,0])
 					rotate([0,0,-360/NB])
						translate([AS,0,0]) cylinder(h=T,r=AS);
				// place for next blade, when open
				rotate([0,0,90-180/NB])
					translate([-AS,0,0])
 						rotate([0,0,-360/NB])
							translate([AS,0,0]) cylinder(h=T,r=AS-0.1);
				// remove sharp corner
				linear_extrude(height=T)
				{
					polygon(points=[[0,0],[R*cos(-90-180/NB),R*sin(-90-180/NB)],[R*cos(-360/NB),R*sin(-360/NB)]]);
				}
			}
		}
		// screw hole
		translate([0,0,-1]) cylinder(h=T+2,r=S/2);
	}
	// gear
	gear (
			number_of_teeth = TSG,
			diametral_pitch = TSG/(2*RSG),
			gear_thickness = T,
			rim_thickness = T,
			hub_thickness = T,
			bore_diameter=S);
}

module box(gear_on=true, blades_on=true)
{
	// box
	difference()
	{
		cylinder(h=H,r=R);
		// cavity
		translate([0,0,2*T]) cylinder(h=H,r=R-W);
		// screw holes
		for (i=[0:NB-1])
		{
			rotate([0,0,360/NB*i])
				translate([AS,0,-1])
				{
					// thread
					cylinder(h=H-T+1,r=S/2);
					// head
					cylinder(h=T+1,r=ND/2);
					// nut
					translate([0,0,1+H-2*T])
						rotate([0,0,90])
							cylinder(h=T,r=ND/sqrt(3),$fn=6);
				}
		}
		// space for the mechanism
		translate([-5*R,-5*R,H-(3+2)*T]) cube([10*R,10*R,2*T]);
	}
	// blades
	if (blades_on)
	for (i=[0:NB-1])
		rotate([0,0,360/NB*i])
			translate([AS,0,H-(3+2)*T])
				//rotate([0,0,-90+180/NB])
				blade();
	// ring gear
	if (gear_on)
	translate([0,0,H-(3+2)*T])
		difference()
		{
			cylinder(h=T,r=RBG+20);
			translate([0,0,-1])
				gear (
					number_of_teeth = TBG,
					diametral_pitch = TBG/(2*RBG),
					gear_thickness = T+2,
					rim_thickness = T+2,
					hub_thickness = T+2,
					bore_diameter=0);
			// outside grip
			translate([0,0,-1])
				for (i=[0:NB-1])
					rotate([0,0,360/NB*i])
						translate([RBG+35,0,0])
							cylinder(r=20,h=T+2);
		}
}

module slice(x,index,gear=true,blades=true)
{
	projection(cut=true)
		translate([x*3*R,0,-index*T-T/2])
			box(gear,blades);
}

module slices()
{
	max_index = H/T;

	slice(0,0);				// bottom with screw head holes
	slice(1,1);				// bottom with screw thread holes
	slice(2,2);				// cavity slice
	//
	slice(3,max_index-5,true,false);		// ring gears
	slice(4,max_index-5,false,true);		// inner gears
	slice(5,max_index-4);		// blades
	//
	slice(6,max_index-2);		// nuts slice
	slice(7,max_index-1);		// top
}

//box();
slices();
