
;
;    IR Widget Firmware
;
;    Copyright (C) 2009 Kevin Timmerman
;    irwidget [@t] compendiumarcana [d0t] com
;    http://www.compendiumarcana.com/irwidget
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <http://www.gnu.org/licenses/>.

;
;
; Version History
;----------------
; Rev 1
; 2009-05-26
; First release
; Derived from IR Widget fimware Rev 5
;



#ifdef __12F629
	include <P12F629.INC>
	#define	CORE14
	#define FIRSTREG 0x20
	#define PGMSIZE 1024
#endif
#ifdef __12F675
	include <P12F675.INC>
	#define	CORE14
	#define FIRSTREG 0x20
	#define PGMSIZE 1024
#endif

													; Configuration bits
	__config _CPD_OFF & _CP_OFF & _BODEN_ON & _MCLRE_OFF & _PWRTE_ON & _WDT_ON & _INTRC_OSC_CLKOUT



BANK1		equ 0x80								; Reduce assembler whining

	radix dec										; Default radix of decimal


													; --- I/O
													; 8 Ground
													;
													;
bSerTx			equ	0								; 7 Serial data to host PC
pSerTx			equ	GPIO							;
													;
bStatus			equ	1								; 6 Status LED output
pStatus			equ GPIO							;
													;
bIRDetect		equ	2								; 5 IR Input
pIRDetect		equ	GPIO							;
													;
;				equ	3								; 4 MCLR
;				equ	GPIO							;
													;
;				equ	4								; 3 OSC Output
;				equ GPIO							;
													;
;				equ	5								; 2 OSC Input
;				equ	GPIO							;
													;
													; 1 Power
													;



	cblock FIRSTREG									; Registers
	prev_count
	temp1
	endc



	org		0x0000									; - Start of program memory

	nop												;
	clrf	GPIO									; All outputs off
	goto	skip_isr								; Jump over the ISR
													;
	org		0x0004									; - ISR
	goto	$										; Let the watchdog handle this
													;
													;
skip_isr											;
													; - Initiailize peripherals
													;
	movlw	(1<<CM0) | (1<<CM1) | (1<<CM2)			; Disable comparator
	movwf	CMCON									;
													;
	call	PGMSIZE-1								; Get OSCCAL
													;
	bsf		STATUS,RP0								; Bank 1
													;
	movwf	OSCCAL ^ BANK1							; Setup OSCCAL
													;
#ifdef ANSEL										;
	movlw	(1<<ADCS0) | (1<<ADCS2)					; Make all pins digital I/O
	movwf	ANSEL ^ BANK1							;
#endif												;
													;
	movlw	(1<<bIRDetect)							; Setup TRIS
	movwf	TRISIO ^ BANK1							;
													;
	errorlevel -219									;
	movwf	WPU	^ BANK1								; Setup WPU
	errorlevel +219									;
													;
													; *GPPU = 0 - WPU enabled
													; INTEDG = 0
													; T0CS = 1 - External clock source
													; T0SE = 1 - Inc on falling edge
													; PSA = 1 - Assign prescaller to WDT
													; PSx - Prescaler = 0 (1:1)
	movlw	(1<<T0CS) | (1<<T0SE) | (1<<PSA)		;
	movwf	OPTION_REG ^ BANK1						;
													;
	bcf		STATUS,RP0								; Bank 0
													;
													;
													;
													; ----- Pulse count capture ------
													;
	clrf	TMR0									; - Wait for first IR pulse
	clrf	prev_count								;
irpw												;
	clrwdt											;
	movf	TMR0,W									;
	btfsc	STATUS,Z								;
	goto	irpw									;
	movlw	0										;
	goto	spc										;	
													;
													; --- Count pulses and send to host every 100 microseconds ---
ircl												;
	clrwdt											;  1
	movf	TMR0,W									;  2 Get pulse count
spc													;
	movwf	temp1									;  3 Save pulse count
	xorwf	prev_count,F							;  4 Compare to previous pulse count
	movwf	prev_count								;  5 Update previouse pulse count
	btfss	STATUS,Z								;  6 Count has changed...
	bsf		pStatus,bStatus							;  7  turn on status LED
	btfsc	STATUS,Z								;  8 Count has not changed...
	bcf		pStatus,bStatus							;  9  turn off status LED
													;
	call	tx115									; 10 Send pulse count to host
													;
	nop												; 96
	nop												; 97
	nop												; 98
													;
	goto	ircl									; 99,100
													;
													;
													; --- Async 115 kbps transmission ---
													;
													;
sendbit macro reg, bit								; Macro to send a bit
													;  4 cycles
	andlw	 ~(1<<bSerTx)							; 1  Assume bit is a 1, drive output low - tx data is inverted
	btfss	reg,bit									; 2  Test it
	iorlw	(1<<bSerTx)								; 3  It is a 1, not zero, drive output high
	movwf	pSerTx									; 4  Update output
	endm											;
													;
													;       115200 bps bit times
													;			0.00	8.68	17.36	26.04	34.72
													;			43.40	52.08	60.76	69.44	78.13
tx115												;
	movwf	temp1									;
	movf	pSerTx,W								;        Get port output latch
	iorlw	(1<<bSerTx)								;        Start bit - high
	movwf	pSerTx									; 0
	call	delay5									; 1-5
	sendbit	temp1,0									; 6-9    Bit 0
	call	delay4									; 10-13
	sendbit	temp1,1									; 14-17  Bit 1
	call	delay5									; 18-22
	sendbit	temp1,2									; 23-26  Bit 2
	call	delay5									; 27-31
	sendbit	temp1,3									; 32-35  Bit 3
	call	delay4									; 36-39
	sendbit temp1,4									; 40-43  Bit 4
	call	delay5									; 44-48
	sendbit temp1,5									; 49-52  Bit 5
	call	delay5									; 53-57
	sendbit temp1,6									; 58-61  Bit 6
	call	delay4									; 62-65
	sendbit temp1,7									; 66-69  Bit 7
	call	delay5									; 70-74
	goto	$+1										; 75,76
	andlw	 ~(1<<bSerTx)							; 77     Stop bit - low
	movwf	pSerTx									; 78
	return											;
													;
delay5												; 5 cycle delay subroutine
	nop												;
delay4												; 4 cycle delay subroutine
	return											;
													;
													;
	end												;
													;
