﻿/// Code by Michael J
/// Please do not re-distribute without credit!
/// 
using System;
using System.Threading;
using Microsoft.SPOT;
using Microsoft.SPOT.Hardware;
using SecretLabs.NETMF.Hardware;
using SecretLabs.NETMF.Hardware.Netduino;
using System.IO.Ports;

namespace ioTX
{
    public class Program
    {
        //ID of this netduino
        static string ntID = "1";

        static InterruptPort interruptPort;
        static int buttonPressCount = 0;

        //Defaults to: SerialPorts.COM1 (uses D0 and D1), 9600, Parity.None, 8, StopBits.One
        static SerialPortHelper xbee = new SerialPortHelper(SerialPorts.COM1, 9600, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One, false);

        static AnalogInput AP3 = new AnalogInput(Pins.GPIO_PIN_A3);
        static AnalogInput AP4 = new AnalogInput(Pins.GPIO_PIN_A4);
        static AnalogInput AP5 = new AnalogInput(Pins.GPIO_PIN_A5);

        public static void Main()
        {
            DateTime startTime = DateTime.Now;

            AP5.SetRange(0, 1023);
            AP4.SetRange(0, 1023);
            AP3.SetRange(0, 1023);

            DateTime lastReading = DateTime.Now;

            int updateCount = 0;

            while (true)
            {
                    double temp1_rounded = System.Math.Round((AP3.Read() / 6.875) * 100) / 100;

                    Thread.Sleep(250);

                    xbee.PrintLine("*S|" + ntID + "|0|T1:" + temp1_rounded.ToString("F2"));

                    Debug.Print("*S|" + ntID + "|0|T1:" + temp1_rounded.ToString("F2"));

                    Thread.Sleep(2000);


                    double temp2_rounded = System.Math.Round((AP4.Read() / 6.875) * 100) / 100;

                    Thread.Sleep(250);

                    xbee.PrintLine("*S|" + ntID + "|0|T2:" + temp2_rounded.ToString("F2"));

                    Debug.Print("*S|" + ntID + "|0|T2:" + temp2_rounded.ToString("F2"));

                    Thread.Sleep(2000);


                    xbee.PrintLine("*S|" + ntID + "|0|L1:" + AP5.Read().ToString());

                    Debug.Print("*S|" + ntID + "|0|L1:" + AP5.Read().ToString());


                    updateCount++;

                Thread.Sleep(60000);
            }
        }
    }
}
