﻿/// Code by Michael J
/// Please do not re-distribute without credit!

using System;
//
using System.IO.Ports;
using System.Threading;
using Microsoft.SPOT;
using Microsoft.SPOT.Hardware;
using SecretLabs.NETMF.Hardware;
using SecretLabs.NETMF.Hardware.Netduino;
using System.Collections;

namespace ioRX
{
    public class Program
    {
        //ID of this netduino
        static string ntID = "0";

        //Defaults to: SerialPorts.COM1 (uses D0 and D1), 9600, Parity.None, 8, StopBits.One
        static SerialPortHelper ioBridge = new SerialPortHelper(SerialPorts.COM2, 9600, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One, false);
        static SerialPortHelper xbee = new SerialPortHelper(SerialPorts.COM1, 9600, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One, true);

        static SensorStore mainStore = new SensorStore();

        public static void Main()
        {
            DateTime startTime = DateTime.Now;

            DateTime lastReading = DateTime.Now;

            int updateCount = 0;

            while (true)
            {
                bool processBuffer = true;

                /// Parse serial buffer for sensor data
                while (processBuffer)
                {
                    string line = xbee.ReadLine();

                    if (line.Length >= 3)
                    {
                        switch (line.Substring(0, 3))
                        {
                            case "*S|":
                                string[] sensorRX = line.Split('|');

                                if (sensorRX.Length == 4)
                                {
                                    if (sensorRX[2] == ntID)
                                    {
                                        string[] sensorData = sensorRX[3].Split(':');

                                        if (sensorData.Length == 2)
                                        {
                                            mainStore.updateSensor(sensorData[0], sensorData[1], sensorRX[1]);
                                        }
                                    }
                                }
                                break;
                            default:
                                Debug.Print("Invalid RX");
                                break;
                        }
                    }
                    else
                    {
                        processBuffer = false;
                    }
                }

                Debug.Print("Buffer Size: " + xbee.bufferCount().ToString());

                TimeSpan timeSinceUpdate = DateTime.Now.Subtract(lastReading);
                long secSinceUpdate = 0;

                if (timeSinceUpdate.Ticks > 0)
                {
                    secSinceUpdate = timeSinceUpdate.Ticks / TimeSpan.TicksPerSecond;
                }

                if (secSinceUpdate >= 90 || updateCount == 0)
                {
                    lastReading = DateTime.Now;

                    updateCount++;

                    if (mainStore.sensorDataCount() > 0)
                    {
                        ioBridge.Print("[[[get|URL_TO_THINGSPEAK_HTTP_APP");

                        Thread.Sleep(1000);

                        foreach (DictionaryEntry sensor in mainStore.getAllSensorData(true))
                        {
                            SensorData sensorEntry = sensor.Value as SensorData;

                            if (sensorEntry != null)
                            {
                                ioBridge.Print("&" + sensorEntry.sensorSource + sensorEntry.sensorName + "=" + sensorEntry.sensorData);

                                Debug.Print(sensorEntry.sensorName + "." + sensorEntry.sensorSource + ": " + sensorEntry.sensorData);
                            }
                        }

                        ioBridge.Print("]]]");
                    }
                }

                Thread.Sleep(30000);
            }
        }
    }
}
