import urllib, httplib, requests, re, json, time
import os.path
import config

class InstructablesParser:
    STATS_KEY_REGEX = "LogHit\(\'([A-Z0-9]*)\'"
    STATS_URL = 'http://www.instructables.com/json-api/getIbleStats?id={0}'

    def parse_raw_metrics(self, url):
        page_html = requests.get(url)
        found_matches = re.findall(self.STATS_KEY_REGEX, page_html.content)
        instructables_stats_key = found_matches[0]
        stats_data = requests.get(self.STATS_URL.format(instructables_stats_key))

        return json.loads(stats_data.content)

class Statistics:
    FILE_NAME = 'history.txt'
    DEFAULT_METRICS = {'views' : 0, 'favorites' : 0, 'comments' : 0, 'popularity' : 0}

    def get_since_last(self, id, latest_metrics):
        last_stats = self.__read_last_saved_data(id)
        if len(set(last_stats.items()) & set(self.DEFAULT_METRICS.items())) == 4:
            return last_stats
        stats = {}
        stats['views'] = latest_metrics['views'] - last_stats['views']
        stats['comments'] = latest_metrics['comments'] - last_stats['comments']
        stats['favorites'] = latest_metrics['favorites'] - last_stats['favorites']
        stats['popularity'] = round((latest_metrics['favorites'] / float(latest_metrics['views'])) * 100, 3)

        return stats

    def __read_last_saved_data(self, id = None):
        if not os.path.isfile(self.FILE_NAME):
            open(self.FILE_NAME, 'w').close()
        file = open(self.FILE_NAME, 'r+')
        line = file.readline()
        file.close()
        if len(line) < 2:
            if id != None:
               return self.DEFAULT_METRICS
            else:
                return {}

        data = json.loads(line)
        if id != None:
            if id in data:
                return data[id]
            else:
                return self.DEFAULT_METRICS

        return data

    def update_with_latest(self, id, latest_metrics):
        file = open(self.FILE_NAME, 'r')
        data = self.__read_last_saved_data()
        file.close()
        open(self.FILE_NAME, 'w').close()
        file = open(self.FILE_NAME, 'w')
        data[id] = latest_metrics
        file.write(json.dumps(data))
        file.close()


def post_metrics(key, metrics):
    headers = {"Content-type": "application/x-www-form-urlencoded", "Accept": "text/plain"}
    params = urllib.urlencode(
        {'field1': metrics['views'], 'field2': metrics['favorites'],
         'field3' : metrics['comments'], 'field4' :metrics['popularity'], 'key': key}
    )
    conn = httplib.HTTPConnection("api.thingspeak.com:80")
    try:
        conn.request("POST", "/update", params, headers)
        response = conn.getresponse()
        response.read()
        conn.close()
        return True
    except:
        return False


instrucatables_parser = InstructablesParser()
statistics = Statistics()

for crawl_item in config.crawl_list:
    raw_metrics = instrucatables_parser.parse_raw_metrics(crawl_item['url'])
    latest_metrics = statistics.get_since_last(crawl_item['id'], raw_metrics)
    print 'Latest metrics for instructable: " {0} " '.format(crawl_item['url'])
    print latest_metrics

    statistics.update_with_latest(crawl_item['id'], raw_metrics)
    status = post_metrics(crawl_item['write_api_key'], latest_metrics)
    if not status:
        print 'Could not get instructable {0} statistics'.format(crawl_item['url'])
    time.sleep(16)

