#!/usr/bin/env python

"""Copyright 2008 Phidgets Inc.
This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
"""

__author__ = 'Adam Stelmack'
__version__ = '2.1.5'
__date__ = 'October 23 2008'

#Basic imports
from threading import *
from ctypes import *
import sys
import time
#Phidget specific imports
from Phidgets.PhidgetException import *
from Phidgets.Events.Events import *
from Phidgets.Devices.InterfaceKit import *
#Twitter
import twitter

twit = twitter.Api(username='mcottonsecurity', password='1qaz2wsx')


#Create an interfacekit object
interfaceKit = InterfaceKit()

#Information Display Function
def displayDeviceInfo():
    print "|------------|----------------------------------|--------------|------------|"
    print "|- Attached -|-              Type              -|- Serial No. -|-  Version -|"
    print "|------------|----------------------------------|--------------|------------|"
    print "|- %8s -|- %30s -|- %10d -|- %8d -|" % (interfaceKit.isAttached(), interfaceKit.getDeviceType(), interfaceKit.getSerialNum(), interfaceKit.getDeviceVersion())
    print "|------------|----------------------------------|--------------|------------|"
    return 0

#Event Handler Callback Functions
def inferfaceKitAttached(e):
    attached = e.device
    print "InterfaceKit %i Attached!" % (attached.getSerialNum())
    return 0

def interfaceKitDetached(e):
    detached = e.device
    print "InterfaceKit %i Detached!" % (detached.getSerialNum())
    return 0

def interfaceKitError(e):
    print "Phidget Error %i: %s" % (e.eCode, e.description)
    return 0

def interfaceKitInputChanged(e):
    #print "Input %i: %s" % (e.index, e.state)
    #status = twit.PostUpdate('Door contact was open and now its closed')

    if e.index == 4:
        if interfaceKit.getInputState(e.index):
            status = twit.PostUpdate('Front Door contact was open and now its closed')
        else:
            status = twit.PostUpdate('Front Door contact was closed and now its open')         
    
    if e.index == 5:
        if interfaceKit.getInputState(e.index):
            status = twit.PostUpdate('Side Door contact was open and now its closed')
        else:
            status = twit.PostUpdate('Side Door contact was closed and now its open')

    return 0
    

def interfaceKitSensorChanged(e):
    #print "Sensor %i: %i" % (e.index, e.value)
    repeatLoop(e.value)
    return 0

def interfaceKitOutputChanged(e):
    print "Output %i: %s" % (e.index, e.state)
    return 0

def repeatLoop(num):
    if num > 100:
        interfaceKit.setOutputState(0,True)
        interfaceKit.setOutputState(1,False)
        interfaceKit.setOutputState(2,False)
    if num > 400:
        interfaceKit.setOutputState(0,True)
        interfaceKit.setOutputState(1,True)
        interfaceKit.setOutputState(2,False)
    if num > 800:
        interfaceKit.setOutputState(0,True)
        interfaceKit.setOutputState(1,True)
        interfaceKit.setOutputState(2,True)
    if num < 101:
        interfaceKit.setOutputState(0,False)
        interfaceKit.setOutputState(1,False)
        interfaceKit.setOutputState(2,False)
    return 0

#Main Program Code
try:
    interfaceKit.setOnAttachHandler(inferfaceKitAttached)
    interfaceKit.setOnDetachHandler(interfaceKitDetached)
    interfaceKit.setOnErrorhandler(interfaceKitError)
    interfaceKit.setOnInputChangeHandler(interfaceKitInputChanged)
    interfaceKit.setOnOutputChangeHandler(interfaceKitOutputChanged)
    interfaceKit.setOnSensorChangeHandler(interfaceKitSensorChanged)
except PhidgetException, e:
    print "Phidget Exception %i: %s" % (e.code, e.message)
    print "Exiting...."
    exit(1)

print "Opening phidget object...."

try:
    interfaceKit.openPhidget()
except PhidgetException, e:
    print "Phidget Exception %i: %s" % (e.code, e.message)
    print "Exiting...."
    exit(1)

print "Waiting for attach...."

try:
    interfaceKit.waitForAttach(10000)
except PhidgetException, e:
    print "Phidget Exception %i: %s" % (e.code, e.message)
    try:
        interfaceKit.closePhidget()
    except PhidgetException, e:
        print "Phidget Exception %i: %s" % (e.code, e.message)
        print "Exiting...."
        exit(1)
    print "Exiting...."
    exit(1)
else:
    displayDeviceInfo()

while 1:
    pass
