/*
hexagons
a basic processing sketch that turns the outline of a hexagon on and off with a mouse click.

example file for "Light Animation in Processing" instructable.


by Ben and Matt
*/


int amount = 0;
boolean on = false;;

void setup() {
  fullScreen();
  noCursor();
}

void draw() {
  background(0);
  
  
  pushMatrix();
  translate(width*0.5, height*0.5);
  polygon(0, 0, 400, 6);
  noFill();
  stroke(on ? 255 : 0);
  strokeWeight(12);
  popMatrix();
  
  amount-=4;
  if (amount < 0) amount = 0;
}

void polygon(float x, float y, float radius, int npoints) {
  float angle = TWO_PI / npoints;
  beginShape();
  for (float a = 0; a < TWO_PI; a += angle) {
    float sx = x + cos(a) * radius;
    float sy = y + sin(a) * radius;
    vertex(sx, sy);
  }
  endShape(CLOSE);
}

public void mousePressed() {
  on = !on;
}