
#include <LCheckSIM.h>
#include <LGSM.h>
#include <LAudio.h>
#include <LWs2812.h>


#define PIC_NUM_0_COLOR  0xffffff
#define PIC_NUM_1_COLOR  0x0000ff
#define PIC_NUM_2_COLOR  0xffffff
#define PIC_NUM_3_COLOR  0xffff00
#define PIC_NUM_4_COLOR  0xff0000
#define PIC_NUM_5_COLOR  0xff00ff
#define PIC_NUM_6_COLOR  0xffffff
#define PIC_NUM_7_COLOR  0xffffff
#define PIC_NUM_8_COLOR  0x00ff00

#define PIC_NUM_LOOP_MAX    5
#define PIC_NUM_LOOP_COLOR  0xff00ff


char *charbuffer = "15915323285";
char num_buf[20];
char contex_buf[50];

unsigned char call_state = IDLE_CALL;
unsigned char modePinFlag = 0;
unsigned char play_state = 0;

unsigned int task_uart_key(void);
void power_on_off_light(unsigned char number);
void voice_call_task(void);


void setup() 
{
    Serial.begin(115200);
    Serial.print("\r\n");
    Serial.print("Gift for mom test.\r\n");
    
    pinMode(E1,INPUT);
    pinMode(E2,OUTPUT);
    digitalWrite(E2,HIGH);
    
    LAudio.begin();
}

void loop()
{   
    voice_call_task();
    sms_receive_task();
    delay(50);
}

void power_on_off_light(unsigned char number)
{
    LWs2812.rgb_set_addr(35);
    LWs2812.monochrome(9, 0, 0);
    delay(50);
    switch(number)
    {
        case 0:
            LWs2812.set_pixel_color(PIC_NUM_0_COLOR, 0);
        break;
        case 1:
            LWs2812.set_pixel_color(PIC_NUM_1_COLOR, 1);
        break;
        case 2:
            LWs2812.set_pixel_color(PIC_NUM_2_COLOR, 2);
        break;
        case 3:
            LWs2812.set_pixel_color(PIC_NUM_3_COLOR, 3);
        break;
        /*
        case 4:
            LWs2812.set_pixel_color(PIC_NUM_4_COLOR, 4);
        break;
        */
        case 5:
            LWs2812.set_pixel_color(PIC_NUM_5_COLOR, 5);
        break;
        case 6:
            LWs2812.set_pixel_color(PIC_NUM_6_COLOR, 6);
        break;
        case 7:
            LWs2812.set_pixel_color(PIC_NUM_7_COLOR, 7);
        break;
        case 8:
            LWs2812.set_pixel_color(PIC_NUM_8_COLOR, 8);
        break;
        case 9:
            LWs2812.monochrome(9, 0, 0);
        break;
        default:
        break;
    }
}

unsigned int task_uart_key(void)
{
    String inString = "";
    unsigned int keyValue = 0;
    unsigned char bitCount = 0; 
    unsigned char dataTemp1[10] = {0};
    while(Serial.available() > 0)
    {
            unsigned char inChar = Serial.read();
            inString += (char)inChar;
            dataTemp1[bitCount] = inChar - '0';
            bitCount += 1;
            delay(10);
    }
    if(inString != "")
    {
            if(bitCount > 4)
            {
                Serial.println("Key input error.");
            }
            else
            {
                    for(char i=0;i<bitCount;i++)
                    {
                            unsigned int dataTemp2 = 1;
                            for(char j=0;j<(bitCount-i-1);j++)dataTemp2 *= 10;
                            keyValue += (dataTemp1[i] * dataTemp2);
                    }   
                    Serial.print("Key value is: ");
                    Serial.println(keyValue); 
            }
    }
    return keyValue;   
}

void voice_call_task(void)
{   
    call_state = LVoiceCall.getVoiceCallStatus();
    
    if(call_state == IDLE_CALL)
    {     
        if(modePinFlag == 0)
        {
            modePinFlag = 1;
            if(digitalRead(E1) == 0)
            {
                if(LCheckSIM.isCheck() == 1) 
                {
                    Serial.print("Voice call begin.\r\n");
                    LVoiceCall.voiceCall(charbuffer);
                }
                else
                {
                    Serial.print("No SIM.\r\n");
                }
                LWs2812.rgb_set_addr(35);
                LWs2812.set_pixel_color(PIC_NUM_4_COLOR, 4);
            }
        }
        if(digitalRead(E1))
        {
          modePinFlag = 0; 
          LWs2812.rgb_set_addr(35);
          LWs2812.set_pixel_color(0, 4);
        }
        
        if(play_state == 1)
        {
            play_state = 0;
            LAudio.stop();
            LWs2812.rgb_set_addr(36);
            LWs2812.monochrome(PIC_NUM_LOOP_MAX, 0, 0);
        }
    }
    else if(call_state == RECEIVINGCALL)
    {
        Serial.print("Call come in.\r\n");
        LVoiceCall.retrieveCallingNumber(num_buf, 20);
        Serial.print("Number is ");
        Serial.println(num_buf);
        
        if(strcmp(charbuffer,(char*)(num_buf)) == 0)
        {
            Serial.print("Cal number is match.\r\n");  
            
            if(play_state == 0)
            {
                play_state = 1;
                LAudio.playFile(storageFlash,(char*)"ringtone.mp3");
                LWs2812.rgb_set_addr(36);
                LWs2812.marquee(PIC_NUM_LOOP_MAX, PIC_NUM_LOOP_COLOR, 0);
            }
            
            if(modePinFlag == 0)
            {
                modePinFlag = 1;   
                if(digitalRead(E1) == 0)     
                {  
                    LVoiceCall.answerCall();
                    Serial.print("Answer call.\r\n");
                    LWs2812.rgb_set_addr(35);
                    LWs2812.set_pixel_color(PIC_NUM_4_COLOR, 4);
                }
            }
            if(digitalRead(E1))
            {
              modePinFlag = 0; 
              LWs2812.rgb_set_addr(35);
              LWs2812.set_pixel_color(0, 4);
            }
        }
    }
    else if(call_state == TALKING  || call_state == CALLING)
    {
        if(modePinFlag == 0)
        {
            modePinFlag = 1;   
            if(digitalRead(E1) == 0)   
            {
                LVoiceCall.hangCall();
                Serial.print("Hang call.\r\n");
                LWs2812.rgb_set_addr(35);
                LWs2812.set_pixel_color(PIC_NUM_4_COLOR, 4);
            }
        }
        if(digitalRead(E1))
        {
          modePinFlag = 0;
          LWs2812.rgb_set_addr(35);
          LWs2812.set_pixel_color(0, 4);
        }
    }
}

void sms_receive_task(void)
{
    if(LSMS.available())
    {
        Serial.println("Get new sms: ");
        LSMS.remoteNumber(num_buf, 20);
        LSMS.remoteContent(contex_buf, 50);
        Serial.print("Number:");
        Serial.println(num_buf);
        Serial.print("Content:"); 
        Serial.println(contex_buf);
        
        if(strcmp(charbuffer,(char*)(num_buf + 3)) == 0)
        {
            Serial.print("SMS number is match.\r\n"); 
            power_on_off_light(contex_buf[0] - '0');
        }
    }   
}

