/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import javax.swing.JOptionPane;
import processing.core.PApplet;
import processing.serial.Serial;

public class gctrl
extends PApplet {
    Serial port = null;
    String portname = null;
    boolean streaming = false;
    float speed = 0.001f;
    String[] gcode;
    int i = 0;

    public void openSerialPort() {
        if (this.portname == null) {
            return;
        }
        if (this.port != null) {
            this.port.stop();
        }
        this.port = new Serial((PApplet)this, this.portname, 9600);
        this.port.bufferUntil(10);
    }

    public void selectSerialPort() {
        String result = (String)JOptionPane.showInputDialog(this.frame, "Select the serial port that corresponds to your Arduino board.", "Select serial port", 3, null, Serial.list(), 0);
        if (result != null) {
            this.portname = result;
            this.openSerialPort();
        }
    }

    public void setup() {
        this.openSerialPort();
    }

    public void draw() {
        this.background(0);
        this.fill(255);
        int y = 24;
        int dy = 12;
        this.text("INSTRUCTIONS", 12.0f, y);
        this.text("p: select serial port", 12.0f, y += dy);
        this.text("1: set speed to 0.001 inches (1 mil) per jog", 12.0f, y += dy);
        this.text("2: set speed to 0.010 inches (10 mil) per jog", 12.0f, y += dy);
        this.text("3: set speed to 0.100 inches (100 mil) per jog", 12.0f, y += dy);
        this.text("arrow keys: jog in x-y plane", 12.0f, y += dy);
        this.text("page up & page down: jog in z axis", 12.0f, y += dy);
        this.text("$: display grbl settings", 12.0f, y += dy);
        this.text("h: go home", 12.0f, y += dy);
        this.text("0: zero machine (set home to the current location)", 12.0f, y += dy);
        this.text("g: stream a g-code file", 12.0f, y += dy);
        this.text("x: stop streaming g-code (this is NOT immediate)", 12.0f, y += dy);
        y += dy;
        y = this.height - dy;
        this.text("current jog speed: " + this.speed + " inches per step", 12.0f, y);
        this.text("current serial port: " + this.portname, 12.0f, y -= dy);
        y -= dy;
    }

    public void keyPressed() {
        if (this.key == '1') {
            this.speed = 0.001f;
        }
        if (this.key == '2') {
            this.speed = 0.01f;
        }
        if (this.key == '3') {
            this.speed = 0.1f;
        }
        if (!this.streaming) {
            if (this.keyCode == 37) {
                this.port.write("G91\nG20\nG00 X-" + this.speed + " Y0.000 Z0.000\n");
            }
            if (this.keyCode == 39) {
                this.port.write("G91\nG20\nG00 X" + this.speed + " Y0.000 Z0.000\n");
            }
            if (this.keyCode == 38) {
                this.port.write("G91\nG20\nG00 X0.000 Y" + this.speed + " Z0.000\n");
            }
            if (this.keyCode == 40) {
                this.port.write("G91\nG20\nG00 X0.000 Y-" + this.speed + " Z0.000\n");
            }
            if (this.keyCode == 33) {
                this.port.write("G91\nG20\nG00 X0.000 Y0.000 Z" + this.speed + "\n");
            }
            if (this.keyCode == 34) {
                this.port.write("G91\nG20\nG00 X0.000 Y0.000 Z-" + this.speed + "\n");
            }
            if (this.key == 'h') {
                this.port.write("G90\nG20\nG00 X0.000 Y0.000 Z0.000\n");
            }
            if (this.key == 'v') {
                this.port.write("$0=75\n$1=74\n$2=75\n");
            }
            if (this.key == 's') {
                this.port.write("$3=10\n");
            }
            if (this.key == 'e') {
                this.port.write("$16=1\n");
            }
            if (this.key == 'd') {
                this.port.write("$16=0\n");
            }
            if (this.key == '0') {
                this.openSerialPort();
            }
            if (this.key == 'p') {
                this.selectSerialPort();
            }
            if (this.key == '$') {
                this.port.write("$$\n");
            }
        }
        if (!this.streaming && this.key == 'g') {
            this.gcode = null;
            this.i = 0;
            File file = null;
            gctrl.println((String)"Loading file...");
            this.selectInput("Select a file to process:", "fileSelected", file);
        }
        if (this.key == 'x') {
            this.streaming = false;
        }
    }

    public void fileSelected(File selection) {
        if (selection == null) {
            gctrl.println((String)"Window was closed or the user hit cancel.");
        } else {
            gctrl.println((String)("User selected " + selection.getAbsolutePath()));
            this.gcode = this.loadStrings(selection.getAbsolutePath());
            if (this.gcode == null) {
                return;
            }
            this.streaming = true;
            this.stream();
        }
    }

    public void stream() {
        if (!this.streaming) {
            return;
        }
        while (true) {
            if (this.i == this.gcode.length) {
                this.streaming = false;
                return;
            }
            if (this.gcode[this.i].trim().length() != 0) break;
            ++this.i;
        }
        gctrl.println((String)this.gcode[this.i]);
        this.port.write(String.valueOf(this.gcode[this.i]) + '\n');
        ++this.i;
    }

    public void serialEvent(Serial p) {
        String s = p.readStringUntil(10);
        gctrl.println((String)s.trim());
        if (s.trim().startsWith("ok")) {
            this.stream();
        }
        if (s.trim().startsWith("error")) {
            this.stream();
        }
    }

    public void settings() {
        this.size(500, 250);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"gctrl"};
        if (passedArgs != null) {
            PApplet.main((String[])gctrl.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

