/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import processing.core.PMatrix2D;
import processing.opengl.LineStroker;

public class LinePath {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    public static final byte SEG_MOVETO = 0;
    public static final byte SEG_LINETO = 1;
    public static final byte SEG_CLOSE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private static PMatrix2D identity = new PMatrix2D();
    private static float defaultMiterlimit = 10.0f;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;
    protected byte[] pointTypes;
    protected float[] floatCoords;
    protected int[] pointColors;
    protected int numTypes;
    protected int numCoords;
    protected int windingRule;

    public LinePath() {
        this(1, 20);
    }

    public LinePath(int rule) {
        this(rule, 20);
    }

    public LinePath(int rule, int initialCapacity) {
        this.setWindingRule(rule);
        this.pointTypes = new byte[initialCapacity];
        this.floatCoords = new float[initialCapacity * 2];
        this.pointColors = new int[initialCapacity];
    }

    void needRoom(boolean needMove, int newPoints) {
        int grow;
        if (needMove && this.numTypes == 0) {
            throw new RuntimeException("missing initial moveto in path definition");
        }
        int size = this.pointTypes.length;
        if (this.numTypes >= size) {
            grow = size;
            if (grow > 500) {
                grow = 500;
            }
            this.pointTypes = LinePath.copyOf(this.pointTypes, size + grow);
        }
        if (this.numCoords + newPoints * 2 > (size = this.floatCoords.length)) {
            grow = size;
            if (grow > 1000) {
                grow = 1000;
            }
            if (grow < newPoints * 2) {
                grow = newPoints * 2;
            }
            this.floatCoords = LinePath.copyOf(this.floatCoords, size + grow);
        }
        if (this.numCoords / 2 + newPoints > (size = this.pointColors.length)) {
            grow = size;
            if (grow > 500) {
                grow = 500;
            }
            if (grow < newPoints) {
                grow = newPoints;
            }
            this.pointColors = LinePath.copyOf(this.pointColors, size + grow);
        }
    }

    public final void moveTo(float x, float y, int c) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.floatCoords[this.numCoords - 2] = x;
            this.floatCoords[this.numCoords - 1] = y;
            this.pointColors[this.numCoords / 2 - 1] = c;
        } else {
            this.needRoom(false, 1);
            this.pointTypes[this.numTypes++] = 0;
            this.floatCoords[this.numCoords++] = x;
            this.floatCoords[this.numCoords++] = y;
            this.pointColors[this.numCoords / 2 - 1] = c;
        }
    }

    public final void lineTo(float x, float y, int c) {
        this.needRoom(true, 1);
        this.pointTypes[this.numTypes++] = 1;
        this.floatCoords[this.numCoords++] = x;
        this.floatCoords[this.numCoords++] = y;
        this.pointColors[this.numCoords / 2 - 1] = c;
    }

    public PathIterator getPathIterator() {
        return new PathIterator(this);
    }

    public final void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 2) {
            this.needRoom(false, 0);
            this.pointTypes[this.numTypes++] = 2;
        }
    }

    public final int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int rule) {
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = rule;
    }

    public final void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public static LinePath createStrokedPath(LinePath src, float weight, int caps, int join) {
        return LinePath.createStrokedPath(src, weight, caps, join, defaultMiterlimit, null);
    }

    public static LinePath createStrokedPath(LinePath src, float weight, int caps, int join, float miterlimit) {
        return LinePath.createStrokedPath(src, weight, caps, join, miterlimit, null);
    }

    public static LinePath createStrokedPath(LinePath src, float weight, int caps, int join, float miterlimit, PMatrix2D transform) {
        LinePath dest = new LinePath();
        LinePath.strokeTo(src, weight, caps, join, miterlimit, transform, new LineStroker(){

            @Override
            public void moveTo(int x0, int y0, int c0) {
                LinePath.this.moveTo(LinePath.S15_16ToFloat(x0), LinePath.S15_16ToFloat(y0), c0);
            }

            @Override
            public void lineJoin() {
            }

            @Override
            public void lineTo(int x1, int y1, int c1) {
                LinePath.this.lineTo(LinePath.S15_16ToFloat(x1), LinePath.S15_16ToFloat(y1), c1);
            }

            @Override
            public void close() {
                LinePath.this.closePath();
            }

            @Override
            public void end() {
            }
        });
        return dest;
    }

    private static void strokeTo(LinePath src, float width, int caps, int join, float miterlimit, PMatrix2D transform, LineStroker lsink) {
        lsink = new LineStroker(lsink, LinePath.FloatToS15_16(width), caps, join, LinePath.FloatToS15_16(miterlimit), transform == null ? identity : transform);
        PathIterator pi = src.getPathIterator();
        LinePath.pathTo(pi, lsink);
    }

    private static void pathTo(PathIterator pi, LineStroker lsink) {
        float[] coords = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    int color = (int)coords[2] << 24 | (int)coords[3] << 16 | (int)coords[4] << 8 | (int)coords[5];
                    lsink.moveTo(LinePath.FloatToS15_16(coords[0]), LinePath.FloatToS15_16(coords[1]), color);
                    break;
                }
                case 1: {
                    int color = (int)coords[2] << 24 | (int)coords[3] << 16 | (int)coords[4] << 8 | (int)coords[5];
                    lsink.lineJoin();
                    lsink.lineTo(LinePath.FloatToS15_16(coords[0]), LinePath.FloatToS15_16(coords[1]), color);
                    break;
                }
                case 2: {
                    lsink.lineJoin();
                    lsink.close();
                    break;
                }
                default: {
                    throw new InternalError("unknown flattened segment type");
                }
            }
            pi.next();
        }
        lsink.end();
    }

    public static float[] copyOf(float[] source, int length) {
        float[] target = new float[length];
        int i = 0;
        while (i < target.length) {
            target[i] = i > source.length - 1 ? 0.0f : source[i];
            ++i;
        }
        return target;
    }

    public static byte[] copyOf(byte[] source, int length) {
        byte[] target = new byte[length];
        int i = 0;
        while (i < target.length) {
            target[i] = i > source.length - 1 ? (byte)0 : source[i];
            ++i;
        }
        return target;
    }

    public static int[] copyOf(int[] source, int length) {
        int[] target = new int[length];
        int i = 0;
        while (i < target.length) {
            target[i] = i > source.length - 1 ? 0 : source[i];
            ++i;
        }
        return target;
    }

    public static int isqrt(int x) {
        int fracbits = 16;
        int root = 0;
        int remHi = 0;
        int remLo = x;
        int count = 15 + fracbits / 2;
        do {
            remHi = remHi << 2 | remLo >>> 30;
            remLo <<= 2;
            int testdiv = ((root <<= 1) << 1) + 1;
            if (remHi < testdiv) continue;
            remHi -= testdiv;
            ++root;
        } while (count-- != 0);
        return root;
    }

    public static long lsqrt(long x) {
        int fracbits = 16;
        long root = 0L;
        long remHi = 0L;
        long remLo = x;
        int count = 31 + fracbits / 2;
        do {
            remHi = remHi << 2 | remLo >>> 62;
            remLo <<= 2;
            long testDiv = ((root <<= 1) << 1) + 1L;
            if (remHi < testDiv) continue;
            remHi -= testDiv;
            ++root;
        } while (count-- != 0);
        return root;
    }

    public static double hypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static int hypot(int x, int y) {
        return (int)(LinePath.lsqrt((long)x * (long)x + (long)y * (long)y) + 128L >> 8);
    }

    public static long hypot(long x, long y) {
        return LinePath.lsqrt(x * x + y * y) + 128L >> 8;
    }

    static int FloatToS15_16(float flt) {
        if ((flt = flt * 65536.0f + 0.5f) <= -4.2949673E9f) {
            return Integer.MIN_VALUE;
        }
        if (flt >= 4.2949673E9f) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.floor(flt);
    }

    static float S15_16ToFloat(int fix) {
        return (float)fix / 65536.0f;
    }

    public static class PathIterator {
        float[] floatCoords;
        int typeIdx;
        int pointIdx;
        int colorIdx;
        LinePath path;
        static final int[] curvecoords;

        static {
            int[] nArray = new int[3];
            nArray[0] = 2;
            nArray[1] = 2;
            curvecoords = nArray;
        }

        PathIterator(LinePath p2df) {
            this.path = p2df;
            this.floatCoords = p2df.floatCoords;
            this.pointIdx = 0;
            this.colorIdx = 0;
        }

        public int currentSegment(float[] coords) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                System.arraycopy(this.floatCoords, this.pointIdx, coords, 0, numCoords);
                int color = this.path.pointColors[this.colorIdx];
                coords[numCoords + 0] = color >> 24 & 0xFF;
                coords[numCoords + 1] = color >> 16 & 0xFF;
                coords[numCoords + 2] = color >> 8 & 0xFF;
                coords[numCoords + 3] = color >> 0 & 0xFF;
            }
            return type;
        }

        public int currentSegment(double[] coords) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                int i = 0;
                while (i < numCoords) {
                    coords[i] = this.floatCoords[this.pointIdx + i];
                    ++i;
                }
                int color = this.path.pointColors[this.colorIdx];
                coords[numCoords + 0] = color >> 24 & 0xFF;
                coords[numCoords + 1] = color >> 16 & 0xFF;
                coords[numCoords + 2] = color >> 8 & 0xFF;
                coords[numCoords + 3] = color >> 0 & 0xFF;
            }
            return type;
        }

        public int getWindingRule() {
            return this.path.getWindingRule();
        }

        public boolean isDone() {
            return this.typeIdx >= this.path.numTypes;
        }

        public void next() {
            byte type;
            if (curvecoords[type = this.path.pointTypes[this.typeIdx++]] > 0) {
                this.pointIdx += curvecoords[type];
                ++this.colorIdx;
            }
        }
    }
}

