/*
 * Decompiled with CFR 0.152.
 */
package processing.javafx;

import java.util.HashMap;
import java.util.Map;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PSurface;
import processing.javafx.PGraphicsFX2D;

public class PSurfaceFX
implements PSurface {
    PApplet sketch;
    PGraphicsFX2D fx;
    Stage stage;
    Canvas canvas;
    AnimationTimer timer;
    static Map<EventType<? extends MouseEvent>, Integer> mouseMap = new HashMap<EventType<? extends MouseEvent>, Integer>();

    static {
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_PRESSED, 1);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_RELEASED, 2);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_CLICKED, 3);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_DRAGGED, 4);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_MOVED, 5);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_ENTERED, 6);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_EXITED, 7);
    }

    public PSurfaceFX(PGraphicsFX2D graphics) {
        this.fx = graphics;
        this.canvas = new ResizableCanvas();
        this.fx.context = this.canvas.getGraphicsContext2D();
    }

    @Override
    public Object getNative() {
        return this.canvas;
    }

    @Override
    public void initOffscreen(PApplet sketch) {
    }

    @Override
    public void initFrame(PApplet sketch) {
        this.sketch = sketch;
        PApplicationFX.surface = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Application.launch(PApplicationFX.class, (String[])new String[0]);
            }
        }).start();
        while (this.stage == null) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setSize(sketch.sketchWidth(), sketch.sketchHeight());
    }

    @Override
    public void setTitle(String title) {
        this.stage.setTitle(title);
    }

    @Override
    public void setVisible(boolean visible) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PSurfaceFX.this.stage.show();
                PSurfaceFX.this.canvas.requestFocus();
            }
        });
    }

    @Override
    public void setResizable(boolean resizable) {
        this.stage.setResizable(resizable);
    }

    @Override
    public void setIcon(PImage icon) {
    }

    @Override
    public void placeWindow(int[] location, int[] editorLocation) {
        if (location != null) {
            this.stage.setX((double)location[0]);
            this.stage.setY((double)location[1]);
        } else if (editorLocation != null) {
            int locationX = editorLocation[0] - 20;
            int locationY = editorLocation[1];
            if ((double)locationX - this.stage.getWidth() > 10.0) {
                this.stage.setX((double)locationX - this.stage.getWidth());
                this.stage.setY((double)locationY);
            } else {
                locationX = editorLocation[0] + 66;
                locationY = editorLocation[1] + 66;
                if ((double)locationX + this.stage.getWidth() > (double)(this.sketch.displayWidth - 33) || (double)locationY + this.stage.getHeight() > (double)(this.sketch.displayHeight - 33)) {
                    locationX = (int)(((double)this.sketch.displayWidth - this.stage.getWidth()) / 2.0);
                    locationY = (int)(((double)this.sketch.displayHeight - this.stage.getHeight()) / 2.0);
                }
                this.stage.setX((double)locationX);
                this.stage.setY((double)locationY);
            }
        }
        if (this.stage.getY() < 0.0) {
            this.stage.setY(30.0);
        }
        if (this.sketch.getGraphics().displayable()) {
            this.setVisible(true);
        }
    }

    @Override
    public void placePresent(int stopColor) {
    }

    @Override
    public void setupExternalMessages() {
        this.stage.xProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> value, Number oldX, Number newX) {
                PSurfaceFX.this.sketch.frameMoved(newX.intValue(), PSurfaceFX.this.stage.yProperty().intValue());
            }
        });
        this.stage.yProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> value, Number oldY, Number newY) {
                PSurfaceFX.this.sketch.frameMoved(PSurfaceFX.this.stage.xProperty().intValue(), newY.intValue());
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                PSurfaceFX.this.sketch.exit();
            }
        });
    }

    @Override
    public void setLocation(int x, int y) {
        this.stage.setX((double)x);
        this.stage.setY((double)y);
    }

    @Override
    public void setSize(int width, int height) {
        this.stage.setWidth((double)width);
        this.stage.setHeight((double)height);
        this.fx.setSize(width, height);
    }

    public void setSmooth(int level) {
    }

    @Override
    public void setFrameRate(float fps) {
    }

    @Override
    public void setCursor(int kind) {
    }

    @Override
    public void setCursor(PImage image, int hotspotX, int hotspotY) {
    }

    @Override
    public void showCursor() {
    }

    @Override
    public void hideCursor() {
    }

    @Override
    public void startThread() {
        if (this.timer == null) {
            this.timer = new AnimationTimer(){

                public void handle(long now) {
                    PSurfaceFX.this.sketch.handleDraw();
                    if (PSurfaceFX.this.sketch.exitCalled()) {
                        Platform.exit();
                    }
                }
            };
            this.timer.start();
        }
    }

    @Override
    public void pauseThread() {
    }

    @Override
    public void resumeThread() {
    }

    @Override
    public boolean stopThread() {
        return false;
    }

    @Override
    public boolean isStopped() {
        return false;
    }

    protected void fxMouseEvent(MouseEvent fxEvent) {
        int count = fxEvent.getClickCount();
        int action = mouseMap.get(fxEvent.getEventType());
        int modifiers = 0;
        if (fxEvent.isShiftDown()) {
            modifiers |= 1;
        }
        if (fxEvent.isControlDown()) {
            modifiers |= 2;
        }
        if (fxEvent.isMetaDown()) {
            modifiers |= 4;
        }
        if (fxEvent.isAltDown()) {
            modifiers |= 8;
        }
        int button = 0;
        if (fxEvent.isPrimaryButtonDown()) {
            button = 37;
        } else if (fxEvent.isSecondaryButtonDown()) {
            button = 39;
        } else if (fxEvent.isMiddleButtonDown()) {
            button = 3;
        }
        if (PApplet.platform == 2 && fxEvent.isControlDown() && button == 37) {
            button = 39;
        }
        long when = System.currentTimeMillis();
        int x = (int)fxEvent.getX();
        int y = (int)fxEvent.getY();
        this.sketch.postEvent(new processing.event.MouseEvent(fxEvent, when, action, modifiers, x, y, button, count));
    }

    protected void fxScrollEvent(ScrollEvent event) {
    }

    protected void fxKeyEvent(KeyEvent fxEvent) {
        int action = 0;
        EventType et = fxEvent.getEventType();
        if (et == KeyEvent.KEY_PRESSED) {
            action = 1;
        } else if (et == KeyEvent.KEY_RELEASED) {
            action = 2;
        } else if (et == KeyEvent.KEY_TYPED) {
            action = 3;
        }
        int modifiers = 0;
        if (fxEvent.isShiftDown()) {
            modifiers |= 1;
        }
        if (fxEvent.isControlDown()) {
            modifiers |= 2;
        }
        if (fxEvent.isMetaDown()) {
            modifiers |= 4;
        }
        if (fxEvent.isAltDown()) {
            modifiers |= 8;
        }
        long when = System.currentTimeMillis();
        KeyCode kc = fxEvent.getCode();
        char key = kc.impl_getChar().charAt(0);
        int keyCode = kc.impl_getCode();
        this.sketch.postEvent(new processing.event.KeyEvent(fxEvent, when, action, modifiers, key, keyCode));
    }

    public static class PApplicationFX
    extends Application {
        public static PSurfaceFX surface;

        public void start(Stage stage) {
            PApplicationFX.surface.stage = stage;
            Canvas canvas = PApplicationFX.surface.canvas;
            StackPane stackPane = new StackPane();
            stackPane.getChildren().add((Object)canvas);
            canvas.widthProperty().bind((ObservableValue)stackPane.widthProperty());
            canvas.heightProperty().bind((ObservableValue)stackPane.heightProperty());
            stage.setScene(new Scene((Parent)stackPane));
        }
    }

    class ResizableCanvas
    extends Canvas {
        public ResizableCanvas() {
            this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> value, Number oldWidth, Number newWidth) {
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.setSize(newWidth.intValue(), ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.fx.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                }
            });
            this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> value, Number oldHeight, Number newHeight) {
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, newHeight.intValue());
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.fx.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                }
            });
            EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    PSurfaceFX.this.fxMouseEvent(e);
                }
            };
            this.setOnMousePressed((EventHandler)mouseHandler);
            this.setOnMouseReleased((EventHandler)mouseHandler);
            this.setOnMouseClicked((EventHandler)mouseHandler);
            this.setOnMouseEntered((EventHandler)mouseHandler);
            this.setOnMouseExited((EventHandler)mouseHandler);
            this.setOnMouseDragged((EventHandler)mouseHandler);
            this.setOnMouseMoved((EventHandler)mouseHandler);
            this.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

                public void handle(ScrollEvent e) {
                    PSurfaceFX.this.fxScrollEvent(e);
                }
            });
            EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent e) {
                    PSurfaceFX.this.fxKeyEvent(e);
                }
            };
            this.setOnKeyPressed((EventHandler)keyHandler);
            this.setOnKeyReleased((EventHandler)keyHandler);
            this.setOnKeyTyped((EventHandler)keyHandler);
            this.setFocusTraversable(false);
            this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focused = true;
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focusGained();
                    } else {
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focused = false;
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focusLost();
                    }
                }
            });
        }

        public Stage getStage() {
            return PSurfaceFX.this.stage;
        }

        public boolean isResizable() {
            return true;
        }

        public double prefWidth(double height) {
            return this.getWidth();
        }

        public double prefHeight(double width) {
            return this.getHeight();
        }
    }
}

