// Aj Creations http://www.facebook.com/anjancreations
// g-Force measurement + datalogging to SD card
// For RC car setup tuning and performance optimisation
// Rx signal printing https://www.dropbox.com/s/mpiuuvuwj3q6o3g/Rx_signal_values.ino

#include <SD.h>
const int chipSelect = 10; 
File xFile; // variable to store values of the x axis
File yFile;
File zFile;
const int xPin = A0; // connect x axis pin on accelerometer to analog pin0           
const int yPin = A1;                  
const int zPin = A2;  
unsigned long rxPulse; 
int logEnable= 0;
int statusLED = 2; // Indicates datalogging sequence 
void setup ()
{
  Serial.begin (9800);
  pinMode (9, INPUT); // Connect signal pin of Rx Ch3 to digital pin9
  pinMode (8, OUTPUT);
  Serial.println ("Initializing SD card... ");
  
  pinMode (SS, OUTPUT);
  
  if (!SD.begin(chipSelect)) 
  {
    Serial.println ("SD card not found... Try again");
    
    while (1) ;
  }
    xFile = SD.open ("x_log.txt", FILE_WRITE); // Text file to store x axis values 
    yFile = SD.open ("y_Log.txt", FILE_WRITE);
    zFile = SD.open ("z_Log.txt", FILE_WRITE);

  if (! xFile) 
  {
    Serial.println ("Error opening file");
     
     while (1) ;
  }
  Serial.println ("SD card initialized");
  Serial.println ("Ready to log data");
  Serial.print ("\n");

}
void loop()
{
 rxPulse = pulseIn (9, HIGH); // Read Ch3 signals from Rx
 if (rxPulse > 1000) // "1000" depends on the trim settings of Ch3 on the Tx
 {                   // set Ch3 trim to minimum if errors occur and try again 
 if (logEnable=1){   
  int x = analogRead (xPin);
    delay(1); 
   
  int y = analogRead (yPin);
    delay(1); 

  int z = analogRead (zPin);

  float zeroG = 512.00;  // Typical 0g value at 3.3v 
  float scale = -105.00; // Scale value is determined while caliberating the sensor 
                         
  
 float xAxis= (((float)x - zeroG)/scale); // Calculate x axis output in g's 
  Serial.print (xAxis); // Print x axis values to serial monitor  
  Serial.print ("\t");
  xFile.println (xAxis); // Write x axis values to SD card 
  xFile.flush (); // Save file
  

 float yAxis= (((float)y - zeroG)/scale);
  Serial.print (yAxis);
  Serial.print("\t");
  yFile.println(yAxis);
  yFile.flush ();
  
float zAxis= (((float)z - zeroG)/scale);
  Serial.print(zAxis);
  Serial.print("\n"); 
  zFile.println(zAxis); 
  zFile.flush ();
  
  digitalWrite (statusLED, HIGH); // Turn on status LED
  delay (100); 
  digitalWrite (statusLED, LOW); // Turn off status LED after a 100mS
  
  delay (300); // wait 300mS before repeating loop sequence
              // Decrease the delay value for faster data accumulation
 
 // Warning: decreasing delay value below 50mS could cause data loss
 // Warning: Use SD cards of less than 2GB capacity and less than Class2
 // Warning: format SD card to FAT32 file system before using
 // Warning: use an independent power supply if using xBee/wireless modules
  }
 }
}


