
//** pxnet.h **//

#ifndef PXNET_H
#define PXNET_H

#include "pxcommon.h"
#include "pxmac.h"

#define kMAXSOCKETS     (8)
#define kIPLEN          (4)
#define kTIME_WAIT_SECS (15)
#define kINACTIVE_SECS  (180)

typedef uint8_t  TIpAddr [kIPLEN];
typedef int8_t   sock_t;

extern TIpAddr   gMyIP;

extern void netInit( void );
extern void netEnable( void );
extern void netIdle( void );
extern void netTimer( uint32_t seconds );

extern void netRead( sock_t sock, uint8_t* dst, uint16_t bytes );
extern void netWrite( sock_t sock, const uint8_t *src, uint16_t bytes );
extern void netClose( sock_t sock );

extern void netPutBegin( sock_t sock );
extern void netPutAppend( sock_t sock, const uint8_t *src, uint16_t bytes );
extern void netPutFinalize( sock_t sock );

extern void onTcpConnect( sock_t sock, uint16_t port );
extern void onTcpData( sock_t sock, uint16_t bytes );
extern void onTcpDisconnect( sock_t sock );

extern void netGetAddr( sock_t sock, uint16_t* port, uint8_t* ip, uint8_t *mac, uint8_t* state );

#endif
