
//** pxmac.h **//

#ifndef PXMAC_H
#define PXMAC_H

#define kMACLEN     (6)
#define kTXBUFFERS  (4)

typedef uint8_t TMacAddr[kMACLEN];

extern TMacAddr gMyMAC;

extern void     macInit( void );
extern void     macEnable( void );
extern uint16_t macRxGetBufferFree( void );

extern void     macTxBegin( void );
extern void     macTxWrite( const uint8_t *src, uint16_t bytes );
extern void     macTxSetPtr( uint16_t offset );
extern void     macTxSetLen( uint16_t bytes );
extern void     macTxSend( void );

extern uint8_t  macRxPoll( void );

extern void     macRxBegin( void );
extern void     macRxRead( uint8_t *dst, uint16_t bytes );
extern uint16_t macRxGetLen( void );
extern void     macRxEnd( void );

#endif
