byte yellowFadeDivide;


void updateSettings() {
  
  modeNumber = constrain (modeNumber, 0,modeTop);
  yellowPatterns[modeNumber] = constrain (yellowPatterns[modeNumber], 0,patternTop);
  yellowIntensities[modeNumber] = constrain (yellowIntensities[modeNumber], 0, brightnessTop);
  
  // Intensity levels for each intensity level.
  switch (yellowIntensities[modeNumber]) {
  case 0:
    yellowHighV = 10;
    yellowLowV = 0;
    yellowFadeDivide = 32;
    break;
  case 1:
    yellowHighV = 20;
    yellowLowV = 0;
    yellowFadeDivide = 16;
    break;
  case 2:
    yellowHighV = 41;
    yellowLowV = 0;
    yellowFadeDivide = 8;
    break;
  case 3:
    yellowHighV = 82;
    yellowLowV = 0;
    yellowFadeDivide = 4;
    break;
  case 4:
    yellowHighV = 165;
    yellowLowV = 0;
    yellowFadeDivide = 2;
    break;
  case 5:
    yellowHighV = 300;
    yellowLowV = 0;
    yellowFadeDivide = 1;
    break;
  }
  
  // Waveforms for each pattern number.
  switch (yellowPatterns[modeNumber]) {
  case 0: // Pattern 0: Flash at 2 Hz.
    yellowHiTime = 250;
    yellowLoTime = 250;
    break;
  case 1: // Pattern 1: Flash at 5 Hz.
    yellowHiTime = 100;
    yellowLoTime = 100;
    break;
  case 2: // Pattern 2: Flash at 10 Hz.
    yellowHiTime = 50;
    yellowLoTime = 50;
    break;
  case 3: // Pattern 3: Fade.
    yellowStepTime = 50;
    break;
  case 4: // Pattern 4: Single flash.
    yellowHiTime = 50;
    yellowLoTime = 50;
    yellowDimV = yellowLowV;
    yellowDelayTime = 250; // How much time to wait until it flashes again.
    yellowPulseReps = 1; // Flashes per cycle.
    break;
  case 5: // Pattern 5: Triple flash and pause.
    yellowHiTime = 50;
    yellowLoTime = 50;
    yellowDimV = yellowLowV;
    yellowDelayTime = 250;
    yellowPulseReps = 4;
    break;
  case 6: // Pattern 6: Triple flash and dim.
    yellowHiTime = 50;
    yellowLoTime = 50;
    yellowDimV = yellowHighV / 5;
    yellowDelayTime = 250;
    yellowPulseReps = 4;
    break;
    // Pattern 7 is solid mode.
  }
  
  // Sets the array for the fade mode.
  for (int i = 0; i < 20; i++) {
    yellowFadeLevels[i] = yellowFadeLevelsMax[i] / yellowFadeDivide;
  }
}

