/**********************************************
 Observe ACLK frequency on ACLK pin 
 for MSP430G2211 ACLK is pin 2 (P1.0)
 Copyright: Doug Paradis - 2010
 All rights reserved
 This code may be used for private use, as long
 as, copyright notice retained.

 ACLK  (pin 2) --> crystal osc output (pin labeled P1.0)
 Xin, Xout (pins 13,12) --> 32.768 KHz crystal

 compiled using IAR Embedded Workbench
**********************************************/

#include  "msp430.h"

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;                   // Stop watchdog timer
  BCSCTL3 = LFXT1S_0 + XCAP_1;                // 32768KHz crystal, 12.5 pF

  P1SEL = BIT0;                              // pin P1.0 selected as ACLK
  P1DIR = BIT0;                              // pin P1.0 selected as ACLK

  while(1);

}
