#include <Servo.h>
#include <TCS3200.h>
#include "pitches.h"

uint8_t RGBvalue[3];
Servo myservo;

TCS3200 colSens;

// Check the pitches.h library and change notes below as you wish
int melody1[] = {NOTE_C4};
int melody2[] = {NOTE_G3};
int melody3[] = {NOTE_A3};
int melody4[] = {NOTE_C2};
int melody5[] = {NOTE_G2};
int melody6[] = {NOTE_F4};
int melody7[] = {0}; //no sound
int melody8[] = {NOTE_F4}; 

int noteDurations[] = {4}; //note duration

void setup()
{
  Serial.begin(115200);
  Serial.println("BEGIN");
  
  colSens.begin();     // TCS3200 on digital pins 2-6

  myservo.attach(8);  // servo on digital pin 8 
  myservo.write(22);  
  
  pinMode(9, OUTPUT);  // speaker on digital pin 9 

}

void loop()
{
  int a; 

  colSens.loop();
  colSens.getRGB (RGBvalue);

  
if (RGBvalue[0] >= 170 && RGBvalue[1] >= 150 && RGBvalue[2] >= 60) {tone(9, melody1[a], 300);} //yellow

  else if (RGBvalue[0] >= 220 && RGBvalue[1] >= 70 && RGBvalue[2] >= 80) {tone(9, melody2[a], 300);} //red

    else if (RGBvalue[0] >= 40 && RGBvalue[1] >= 110 && RGBvalue[2] >= 210) {tone(9, melody3[a], 300);} //light blue

      else if (RGBvalue[0] >= 60 && RGBvalue[1] >= 100 && RGBvalue[2] >= 220) {tone(9, melody4[a], 300);} //dark blue

        else if (RGBvalue[0] >= 110 && RGBvalue[1] >= 115 && RGBvalue[2] >= 160) {tone(9, melody5[a], 300);} //purple

          else if (RGBvalue[0] >= 100 && RGBvalue[1] >= 160 && RGBvalue[2] >= 120) {tone(9, melody6[a], 300);} //green

            else if (RGBvalue[0] >= 120 && RGBvalue[1] >= 120 && RGBvalue[2] >= 120) {tone(9, melody7[a], 300);} //black-grey

              else {tone(9, melody8[a], 300);}

// Go to 'Tools -> Serial Monitor' to check RGB values for various colours if you wish to add more notes
     
    Serial.print("C:\t"); Serial.print(1000);
    Serial.print("\tR:\t"); Serial.print(RGBvalue[0]);
    Serial.print("\tG:\t"); Serial.print(RGBvalue[1]);
    Serial.print("\tB:\t"); Serial.print(RGBvalue[2]);
    Serial.print("\t");
    Serial.println();    
   
}
